// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group for which you want to edit the query.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The resource query that determines which AWS resources are members of the
	// resource group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupQueryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGroupQueryInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GroupName", 1))
	}

	if s.ResourceQuery == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGroupQueryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ResourceQuery != nil {
		v := s.ResourceQuery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceQuery", v, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The resource query associated with the resource group after the update.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGroupQueryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupQuery != nil {
		v := s.GroupQuery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GroupQuery", v, metadata)
	}
	return nil
}

const opUpdateGroupQuery = "UpdateGroupQuery"

// UpdateGroupQueryRequest returns a request value for making API operation for
// AWS Resource Groups.
//
// Updates the resource query of a group.
//
//    // Example sending a request using UpdateGroupQueryRequest.
//    req := client.UpdateGroupQueryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery
func (c *Client) UpdateGroupQueryRequest(input *UpdateGroupQueryInput) UpdateGroupQueryRequest {
	op := &aws.Operation{
		Name:       opUpdateGroupQuery,
		HTTPMethod: "PUT",
		HTTPPath:   "/groups/{GroupName}/query",
	}

	if input == nil {
		input = &UpdateGroupQueryInput{}
	}

	req := c.newRequest(op, input, &UpdateGroupQueryOutput{})

	return UpdateGroupQueryRequest{Request: req, Input: input, Copy: c.UpdateGroupQueryRequest}
}

// UpdateGroupQueryRequest is the request type for the
// UpdateGroupQuery API operation.
type UpdateGroupQueryRequest struct {
	*aws.Request
	Input *UpdateGroupQueryInput
	Copy  func(*UpdateGroupQueryInput) UpdateGroupQueryRequest
}

// Send marshals and sends the UpdateGroupQuery API request.
func (r UpdateGroupQueryRequest) Send(ctx context.Context) (*UpdateGroupQueryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGroupQueryResponse{
		UpdateGroupQueryOutput: r.Request.Data.(*UpdateGroupQueryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGroupQueryResponse is the response type for the
// UpdateGroupQuery API operation.
type UpdateGroupQueryResponse struct {
	*UpdateGroupQueryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGroupQuery request.
func (r *UpdateGroupQueryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
