// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeReportCreationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeReportCreationInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeReportCreationOutput struct {
	_ struct{} `type:"structure"`

	// Details of the common errors that all operations return.
	ErrorMessage *string `type:"string"`

	// The path to the Amazon S3 bucket where the report was stored on creation.
	S3Location *string `type:"string"`

	// Reports the status of the operation.
	//
	// The operation status can be one of the following:
	//
	//    * RUNNING - Report creation is in progress.
	//
	//    * SUCCEEDED - Report creation is complete. You can open the report from
	//    the Amazon S3 bucket that you specified when you ran StartReportCreation.
	//
	//    * FAILED - Report creation timed out or the Amazon S3 bucket is not accessible.
	//
	//    * NO REPORT - No report was generated in the last 90 days.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeReportCreationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReportCreation = "DescribeReportCreation"

// DescribeReportCreationRequest returns a request value for making API operation for
// AWS Resource Groups Tagging API.
//
// Describes the status of the StartReportCreation operation.
//
// You can call this operation only from the organization's master account and
// from the us-east-1 Region.
//
//    // Example sending a request using DescribeReportCreationRequest.
//    req := client.DescribeReportCreationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/DescribeReportCreation
func (c *Client) DescribeReportCreationRequest(input *DescribeReportCreationInput) DescribeReportCreationRequest {
	op := &aws.Operation{
		Name:       opDescribeReportCreation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReportCreationInput{}
	}

	req := c.newRequest(op, input, &DescribeReportCreationOutput{})

	return DescribeReportCreationRequest{Request: req, Input: input, Copy: c.DescribeReportCreationRequest}
}

// DescribeReportCreationRequest is the request type for the
// DescribeReportCreation API operation.
type DescribeReportCreationRequest struct {
	*aws.Request
	Input *DescribeReportCreationInput
	Copy  func(*DescribeReportCreationInput) DescribeReportCreationRequest
}

// Send marshals and sends the DescribeReportCreation API request.
func (r DescribeReportCreationRequest) Send(ctx context.Context) (*DescribeReportCreationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReportCreationResponse{
		DescribeReportCreationOutput: r.Request.Data.(*DescribeReportCreationOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeReportCreationResponse is the response type for the
// DescribeReportCreation API operation.
type DescribeReportCreationResponse struct {
	*DescribeReportCreationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReportCreation request.
func (r *DescribeReportCreationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
