// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to exclude resources that are compliant with the tag policy.
	// Set this to true if you are interested in retrieving information on noncompliant
	// resources only.
	//
	// You can use this parameter only if the IncludeComplianceDetails parameter
	// is also set to true.
	ExcludeCompliantResources *bool `type:"boolean"`

	// Specifies whether to include details regarding the compliance with the effective
	// tag policy. Set this to true to determine whether resources are compliant
	// with the tag policy and to get details.
	IncludeComplianceDetails *bool `type:"boolean"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`

	// The constraints on the resources that you want returned. The format of each
	// resource type is service[:resourceType]. For example, specifying a resource
	// type of ec2 returns all Amazon EC2 resources (which includes EC2 instances).
	// Specifying a resource type of ec2:instance returns only EC2 instances.
	//
	// The string for each service name and resource type is the same as that embedded
	// in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference
	// for the following:
	//
	//    * For a list of service name strings, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces).
	//
	//    * For resource type strings, see Example ARNs (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax).
	//
	//    * For more information about ARNs, see Amazon Resource Names (ARNs) and
	//    AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// You can specify multiple resource types by using an array. The array can
	// include up to 100 items. Note that the length constraint requirement applies
	// to each resource type filter.
	ResourceTypeFilters []string `type:"list"`

	// A limit that restricts the number of resources returned by GetResources in
	// paginated output. You can set ResourcesPerPage to a minimum of 1 item and
	// the maximum of 100 items.
	ResourcesPerPage *int64 `type:"integer"`

	// A list of TagFilters (keys and values). Each TagFilter specified must contain
	// a key with values as optional. A request can include up to 50 keys, and each
	// key can include up to 20 values.
	//
	// Note the following when deciding how to use TagFilters:
	//
	//    * If you do specify a TagFilter, the response returns only those resources
	//    that are currently associated with the specified tag.
	//
	//    * If you don't specify a TagFilter, the response includes all resources
	//    that were ever associated with tags. Resources that currently don't have
	//    associated tags are shown with an empty tag set, like this: "Tags": [].
	//
	//    * If you specify more than one filter in a single request, the response
	//    returns only those resources that satisfy all specified filters.
	//
	//    * If you specify a filter that contains more than one value for a key,
	//    the response returns resources that match any of the specified values
	//    for that key.
	//
	//    * If you don't specify any values for a key, the response returns resources
	//    that are tagged with that key irrespective of the value. For example,
	//    for filters: filter1 = {key1, {value1}}, filter2 = {key2, {value2,value3,value4}}
	//    , filter3 = {key3}: GetResources( {filter1} ) returns resources tagged
	//    with key1=value1 GetResources( {filter2} ) returns resources tagged with
	//    key2=value2 or key2=value3 or key2=value4 GetResources( {filter3} ) returns
	//    resources tagged with any tag containing key3 as its tag key, irrespective
	//    of its value GetResources( {filter1,filter2,filter3} ) returns resources
	//    tagged with ( key1=value1) and ( key2=value2 or key2=value3 or key2=value4)
	//    and (key3, irrespective of the value)
	TagFilters []TagFilter `type:"list"`

	// AWS recommends using ResourcesPerPage instead of this parameter.
	//
	// A limit that restricts the number of tags (key and value pairs) returned
	// by GetResources in paginated output. A resource with no tags is counted as
	// having one tag (one key and value pair).
	//
	// GetResources does not split a resource and its associated tags across pages.
	// If the specified TagsPerPage would cause such a break, a PaginationToken
	// is returned in place of the affected resource and its tags. Use that token
	// in another request to get the remaining data. For example, if you specify
	// a TagsPerPage of 100 and the account has 22 resources with 10 tags each (meaning
	// that each resource has 10 key and value pairs), the output will consist of
	// three pages. The first page displays the first 10 resources, each with its
	// 10 tags. The second page displays the next 10 resources, each with its 10
	// tags. The third page displays the remaining 2 resources, each with its 10
	// tags.
	//
	// You can set TagsPerPage to a minimum of 100 items and the maximum of 500
	// items.
	TagsPerPage *int64 `type:"integer"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of resource ARNs and the tags (keys and values) associated with each.
	ResourceTagMappingList []ResourceTagMapping `type:"list"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetResources = "GetResources"

// GetResourcesRequest returns a request value for making API operation for
// AWS Resource Groups Tagging API.
//
// Returns all the tagged or previously tagged resources that are located in
// the specified Region for the AWS account.
//
// Depending on what information you want returned, you can also specify the
// following:
//
//    * Filters that specify what tags and resource types you want returned.
//    The response includes all tags that are associated with the requested
//    resources.
//
//    * Information about compliance with the account's effective tag policy.
//    For more information on tag policies, see Tag Policies (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
//    in the AWS Organizations User Guide.
//
// You can check the PaginationToken response parameter to determine if a query
// is complete. Queries occasionally return fewer results on a page than allowed.
// The PaginationToken response parameter value is null only when there are
// no more results to display.
//
//    // Example sending a request using GetResourcesRequest.
//    req := client.GetResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetResources
func (c *Client) GetResourcesRequest(input *GetResourcesInput) GetResourcesRequest {
	op := &aws.Operation{
		Name:       opGetResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "ResourcesPerPage",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	req := c.newRequest(op, input, &GetResourcesOutput{})

	return GetResourcesRequest{Request: req, Input: input, Copy: c.GetResourcesRequest}
}

// GetResourcesRequest is the request type for the
// GetResources API operation.
type GetResourcesRequest struct {
	*aws.Request
	Input *GetResourcesInput
	Copy  func(*GetResourcesInput) GetResourcesRequest
}

// Send marshals and sends the GetResources API request.
func (r GetResourcesRequest) Send(ctx context.Context) (*GetResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResourcesResponse{
		GetResourcesOutput: r.Request.Data.(*GetResourcesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetResourcesRequestPaginator returns a paginator for GetResources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetResourcesRequest(input)
//   p := resourcegroupstaggingapi.NewGetResourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetResourcesPaginator(req GetResourcesRequest) GetResourcesPaginator {
	return GetResourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetResourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetResourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetResourcesPaginator struct {
	aws.Pager
}

func (p *GetResourcesPaginator) CurrentPage() *GetResourcesOutput {
	return p.Pager.CurrentPage().(*GetResourcesOutput)
}

// GetResourcesResponse is the response type for the
// GetResources API operation.
type GetResourcesResponse struct {
	*GetResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResources request.
func (r *GetResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
