// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteRobotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot.
	//
	// Robot is a required field
	Robot *string `locationName:"robot" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRobotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRobotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRobotInput"}

	if s.Robot == nil {
		invalidParams.Add(aws.NewErrParamRequired("Robot"))
	}
	if s.Robot != nil && len(*s.Robot) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Robot", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRobotInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Robot != nil {
		v := *s.Robot

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "robot", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRobotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRobotOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteRobot = "DeleteRobot"

// DeleteRobotRequest returns a request value for making API operation for
// AWS RoboMaker.
//
// Deletes a robot.
//
//    // Example sending a request using DeleteRobotRequest.
//    req := client.DeleteRobotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot
func (c *Client) DeleteRobotRequest(input *DeleteRobotInput) DeleteRobotRequest {
	op := &aws.Operation{
		Name:       opDeleteRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteRobot",
	}

	if input == nil {
		input = &DeleteRobotInput{}
	}

	req := c.newRequest(op, input, &DeleteRobotOutput{})

	return DeleteRobotRequest{Request: req, Input: input, Copy: c.DeleteRobotRequest}
}

// DeleteRobotRequest is the request type for the
// DeleteRobot API operation.
type DeleteRobotRequest struct {
	*aws.Request
	Input *DeleteRobotInput
	Copy  func(*DeleteRobotInput) DeleteRobotRequest
}

// Send marshals and sends the DeleteRobot API request.
func (r DeleteRobotRequest) Send(ctx context.Context) (*DeleteRobotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRobotResponse{
		DeleteRobotOutput: r.Request.Data.(*DeleteRobotOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRobotResponse is the response type for the
// DeleteRobot API operation.
type DeleteRobotResponse struct {
	*DeleteRobotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRobot request.
func (r *DeleteRobotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
