// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeSimulationJobBatchInput struct {
	_ struct{} `type:"structure"`

	// The id of the batch to describe.
	//
	// Batch is a required field
	Batch *string `locationName:"batch" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSimulationJobBatchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSimulationJobBatchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSimulationJobBatchInput"}

	if s.Batch == nil {
		invalidParams.Add(aws.NewErrParamRequired("Batch"))
	}
	if s.Batch != nil && len(*s.Batch) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Batch", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeSimulationJobBatchInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Batch != nil {
		v := *s.Batch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "batch", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeSimulationJobBatchOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The batch policy.
	BatchPolicy *BatchPolicy `locationName:"batchPolicy" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of created simulation job summaries.
	CreatedRequests []SimulationJobSummary `locationName:"createdRequests" type:"list"`

	// A list of failed create simulation job requests. The request failed to be
	// created into a simulation job. Failed requests do not have a simulation job
	// ID.
	FailedRequests []FailedCreateSimulationJobRequest `locationName:"failedRequests" type:"list"`

	// The failure code of the simulation job batch.
	FailureCode SimulationJobBatchErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// The reason the simulation job batch failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// A list of pending simulation job requests. These requests have not yet been
	// created into simulation jobs.
	PendingRequests []SimulationJobRequest `locationName:"pendingRequests" min:"1" type:"list"`

	// The status of the batch.
	//
	// Pending
	//
	// The simulation job batch request is pending.
	//
	// InProgress
	//
	// The simulation job batch is in progress.
	//
	// Failed
	//
	// The simulation job batch failed. One or more simulation job requests could
	// not be completed due to an internal failure (like InternalServiceError).
	// See failureCode and failureReason for more information.
	//
	// Completed
	//
	// The simulation batch job completed. A batch is complete when (1) there are
	// no pending simulation job requests in the batch and none of the failed simulation
	// job requests are due to InternalServiceError and (2) when all created simulation
	// jobs have reached a terminal state (for example, Completed or Failed).
	//
	// Canceled
	//
	// The simulation batch job was cancelled.
	//
	// Canceling
	//
	// The simulation batch job is being cancelled.
	//
	// Completing
	//
	// The simulation batch job is completing.
	//
	// TimingOut
	//
	// The simulation job batch is timing out.
	//
	// If a batch timing out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), the batch status will
	// be Failed. If there are no such failing request, the batch status will be
	// TimedOut.
	//
	// TimedOut
	//
	// The simulation batch job timed out.
	Status SimulationJobBatchStatus `locationName:"status" type:"string" enum:"true"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job batch.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeSimulationJobBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeSimulationJobBatchOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BatchPolicy != nil {
		v := s.BatchPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "batchPolicy", v, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatedRequests != nil {
		v := s.CreatedRequests

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "createdRequests", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FailedRequests != nil {
		v := s.FailedRequests

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "failedRequests", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PendingRequests != nil {
		v := s.PendingRequests

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "pendingRequests", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opDescribeSimulationJobBatch = "DescribeSimulationJobBatch"

// DescribeSimulationJobBatchRequest returns a request value for making API operation for
// AWS RoboMaker.
//
// Describes a simulation job batch.
//
//    // Example sending a request using DescribeSimulationJobBatchRequest.
//    req := client.DescribeSimulationJobBatchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch
func (c *Client) DescribeSimulationJobBatchRequest(input *DescribeSimulationJobBatchInput) DescribeSimulationJobBatchRequest {
	op := &aws.Operation{
		Name:       opDescribeSimulationJobBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/describeSimulationJobBatch",
	}

	if input == nil {
		input = &DescribeSimulationJobBatchInput{}
	}

	req := c.newRequest(op, input, &DescribeSimulationJobBatchOutput{})

	return DescribeSimulationJobBatchRequest{Request: req, Input: input, Copy: c.DescribeSimulationJobBatchRequest}
}

// DescribeSimulationJobBatchRequest is the request type for the
// DescribeSimulationJobBatch API operation.
type DescribeSimulationJobBatchRequest struct {
	*aws.Request
	Input *DescribeSimulationJobBatchInput
	Copy  func(*DescribeSimulationJobBatchInput) DescribeSimulationJobBatchRequest
}

// Send marshals and sends the DescribeSimulationJobBatch API request.
func (r DescribeSimulationJobBatchRequest) Send(ctx context.Context) (*DescribeSimulationJobBatchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSimulationJobBatchResponse{
		DescribeSimulationJobBatchOutput: r.Request.Data.(*DescribeSimulationJobBatchOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSimulationJobBatchResponse is the response type for the
// DescribeSimulationJobBatch API operation.
type DescribeSimulationJobBatchResponse struct {
	*DescribeSimulationJobBatchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSimulationJobBatch request.
func (r *DescribeSimulationJobBatchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
