// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListSimulationJobBatchesInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	Filters []Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListSimulationJobBatches only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListSimulationJobBatches
	// request with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The nextToken value returned from a previous paginated ListSimulationJobBatches
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSimulationJobBatchesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSimulationJobBatchesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListSimulationJobBatchesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSimulationJobBatchesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListSimulationJobBatchesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListSimulationJobBatches request.
	// When the results of a ListSimulationJobBatches request exceed maxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of simulation job batch summaries.
	SimulationJobBatchSummaries []SimulationJobBatchSummary `locationName:"simulationJobBatchSummaries" type:"list"`
}

// String returns the string representation
func (s ListSimulationJobBatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListSimulationJobBatchesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SimulationJobBatchSummaries != nil {
		v := s.SimulationJobBatchSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationJobBatchSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListSimulationJobBatches = "ListSimulationJobBatches"

// ListSimulationJobBatchesRequest returns a request value for making API operation for
// AWS RoboMaker.
//
// Returns a list simulation job batches. You can optionally provide filters
// to retrieve specific simulation batch jobs.
//
//    // Example sending a request using ListSimulationJobBatchesRequest.
//    req := client.ListSimulationJobBatchesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches
func (c *Client) ListSimulationJobBatchesRequest(input *ListSimulationJobBatchesInput) ListSimulationJobBatchesRequest {
	op := &aws.Operation{
		Name:       opListSimulationJobBatches,
		HTTPMethod: "POST",
		HTTPPath:   "/listSimulationJobBatches",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSimulationJobBatchesInput{}
	}

	req := c.newRequest(op, input, &ListSimulationJobBatchesOutput{})

	return ListSimulationJobBatchesRequest{Request: req, Input: input, Copy: c.ListSimulationJobBatchesRequest}
}

// ListSimulationJobBatchesRequest is the request type for the
// ListSimulationJobBatches API operation.
type ListSimulationJobBatchesRequest struct {
	*aws.Request
	Input *ListSimulationJobBatchesInput
	Copy  func(*ListSimulationJobBatchesInput) ListSimulationJobBatchesRequest
}

// Send marshals and sends the ListSimulationJobBatches API request.
func (r ListSimulationJobBatchesRequest) Send(ctx context.Context) (*ListSimulationJobBatchesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListSimulationJobBatchesResponse{
		ListSimulationJobBatchesOutput: r.Request.Data.(*ListSimulationJobBatchesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListSimulationJobBatchesRequestPaginator returns a paginator for ListSimulationJobBatches.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListSimulationJobBatchesRequest(input)
//   p := robomaker.NewListSimulationJobBatchesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListSimulationJobBatchesPaginator(req ListSimulationJobBatchesRequest) ListSimulationJobBatchesPaginator {
	return ListSimulationJobBatchesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListSimulationJobBatchesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListSimulationJobBatchesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListSimulationJobBatchesPaginator struct {
	aws.Pager
}

func (p *ListSimulationJobBatchesPaginator) CurrentPage() *ListSimulationJobBatchesOutput {
	return p.Pager.CurrentPage().(*ListSimulationJobBatchesOutput)
}

// ListSimulationJobBatchesResponse is the response type for the
// ListSimulationJobBatches API operation.
type ListSimulationJobBatchesResponse struct {
	*ListSimulationJobBatchesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListSimulationJobBatches request.
func (r *ListSimulationJobBatchesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
