// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about the batch policy.
type BatchPolicy struct {
	_ struct{} `type:"structure"`

	// The number of active simulation jobs create as part of the batch that can
	// be in an active state at the same time.
	//
	// Active states include: Pending,Preparing, Running, Restarting, RunningFailed
	// and Terminating. All other states are terminal states.
	MaxConcurrency *int64 `locationName:"maxConcurrency" type:"integer"`

	// The amount of time, in seconds, to wait for the batch to complete.
	//
	// If a batch times out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), they will be moved to
	// the failed list and the batch status will be Failed. If the pending requests
	// were failing for any other reason, the failed pending requests will be moved
	// to the failed list and the batch status will be TimedOut.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s BatchPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxConcurrency != nil {
		v := *s.MaxConcurrency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxConcurrency", protocol.Int64Value(v), metadata)
	}
	if s.TimeoutInSeconds != nil {
		v := *s.TimeoutInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutInSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Compute information for the simulation job.
type Compute struct {
	_ struct{} `type:"structure"`

	// The simulation unit limit. Your simulation is allocated CPU and memory proportional
	// to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB
	// of memory. You are only billed for the SU utilization you consume up to the
	// maximim value provided.
	SimulationUnitLimit *int64 `locationName:"simulationUnitLimit" min:"1" type:"integer"`
}

// String returns the string representation
func (s Compute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Compute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Compute"}
	if s.SimulationUnitLimit != nil && *s.SimulationUnitLimit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("SimulationUnitLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Compute) MarshalFields(e protocol.FieldEncoder) error {
	if s.SimulationUnitLimit != nil {
		v := *s.SimulationUnitLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "simulationUnitLimit", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Compute information for the simulation job
type ComputeResponse struct {
	_ struct{} `type:"structure"`

	// The simulation unit limit. Your simulation is allocated CPU and memory proportional
	// to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB
	// of memory. You are only billed for the SU utilization you consume up to the
	// maximim value provided.
	SimulationUnitLimit *int64 `locationName:"simulationUnitLimit" min:"1" type:"integer"`
}

// String returns the string representation
func (s ComputeResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComputeResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.SimulationUnitLimit != nil {
		v := *s.SimulationUnitLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "simulationUnitLimit", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The name of the data source.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The S3 bucket where the data files are located.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The list of S3 keys identifying the data source files.
	S3Keys []S3KeyOutput `locationName:"s3Keys" type:"list"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Keys != nil {
		v := s.S3Keys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "s3Keys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a data source.
type DataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The S3 bucket where the data files are located.
	//
	// S3Bucket is a required field
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string" required:"true"`

	// The list of S3 keys identifying the data source files.
	//
	// S3Keys is a required field
	S3Keys []string `locationName:"s3Keys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSourceConfig"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.S3Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}

	if s.S3Keys == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Keys"))
	}
	if s.S3Keys != nil && len(s.S3Keys) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Keys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DataSourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Keys != nil {
		v := s.S3Keys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "s3Keys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a deployment application configuration.
type DeploymentApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string" required:"true"`

	// The launch configuration.
	//
	// LaunchConfig is a required field
	LaunchConfig *DeploymentLaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeploymentApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}

	if s.ApplicationVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationVersion"))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Information about a deployment configuration.
type DeploymentConfig struct {
	_ struct{} `type:"structure"`

	// The percentage of robots receiving the deployment at the same time.
	ConcurrentDeploymentPercentage *int64 `locationName:"concurrentDeploymentPercentage" min:"1" type:"integer"`

	// The download condition file.
	DownloadConditionFile *S3Object `locationName:"downloadConditionFile" type:"structure"`

	// The percentage of deployments that need to fail before stopping deployment.
	FailureThresholdPercentage *int64 `locationName:"failureThresholdPercentage" min:"1" type:"integer"`

	// The amount of time, in seconds, to wait for deployment to a single robot
	// to complete. Choose a time between 1 minute and 7 days. The default is 5
	// hours.
	RobotDeploymentTimeoutInSeconds *int64 `locationName:"robotDeploymentTimeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s DeploymentConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentConfig"}
	if s.ConcurrentDeploymentPercentage != nil && *s.ConcurrentDeploymentPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConcurrentDeploymentPercentage", 1))
	}
	if s.FailureThresholdPercentage != nil && *s.FailureThresholdPercentage < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureThresholdPercentage", 1))
	}
	if s.DownloadConditionFile != nil {
		if err := s.DownloadConditionFile.Validate(); err != nil {
			invalidParams.AddNested("DownloadConditionFile", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConcurrentDeploymentPercentage != nil {
		v := *s.ConcurrentDeploymentPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "concurrentDeploymentPercentage", protocol.Int64Value(v), metadata)
	}
	if s.DownloadConditionFile != nil {
		v := s.DownloadConditionFile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "downloadConditionFile", v, metadata)
	}
	if s.FailureThresholdPercentage != nil {
		v := *s.FailureThresholdPercentage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureThresholdPercentage", protocol.Int64Value(v), metadata)
	}
	if s.RobotDeploymentTimeoutInSeconds != nil {
		v := *s.RobotDeploymentTimeoutInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "robotDeploymentTimeoutInSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a deployment job.
type DeploymentJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The deployment application configuration.
	DeploymentApplicationConfigs []DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// The deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The deployment job failure code.
	FailureCode DeploymentJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// A short description of the reason why the deployment job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The status of the deployment job.
	Status DeploymentStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DeploymentJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DeploymentApplicationConfigs != nil {
		v := s.DeploymentApplicationConfigs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "deploymentApplicationConfigs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DeploymentConfig != nil {
		v := s.DeploymentConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deploymentConfig", v, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Fleet != nil {
		v := *s.Fleet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fleet", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Configuration information for a deployment launch.
type DeploymentLaunchConfig struct {
	_ struct{} `type:"structure"`

	// An array of key/value pairs specifying environment variables for the robot
	// application
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// The deployment post-launch file. This file will be executed after the launch
	// file.
	PostLaunchFile *string `locationName:"postLaunchFile" min:"1" type:"string"`

	// The deployment pre-launch file. This file will be executed prior to the launch
	// file.
	PreLaunchFile *string `locationName:"preLaunchFile" min:"1" type:"string"`
}

// String returns the string representation
func (s DeploymentLaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentLaunchConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeploymentLaunchConfig"}

	if s.LaunchFile == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchFile", 1))
	}

	if s.PackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageName", 1))
	}
	if s.PostLaunchFile != nil && len(*s.PostLaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PostLaunchFile", 1))
	}
	if s.PreLaunchFile != nil && len(*s.PreLaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PreLaunchFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeploymentLaunchConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LaunchFile != nil {
		v := *s.LaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageName != nil {
		v := *s.PackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "packageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PostLaunchFile != nil {
		v := *s.PostLaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "postLaunchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PreLaunchFile != nil {
		v := *s.PreLaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "preLaunchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a failed create simulation job request.
type FailedCreateSimulationJobRequest struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// failed.
	FailedAt *time.Time `locationName:"failedAt" type:"timestamp"`

	// The failure code.
	FailureCode SimulationJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// The failure reason of the simulation job request.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The simulation job request.
	Request *SimulationJobRequest `locationName:"request" type:"structure"`
}

// String returns the string representation
func (s FailedCreateSimulationJobRequest) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FailedCreateSimulationJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.FailedAt != nil {
		v := *s.FailedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Request != nil {
		v := s.Request

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "request", v, metadata)
	}
	return nil
}

// Information about a filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of values.
	Values []string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a fleet.
type Fleet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The status of the last fleet deployment.
	LastDeploymentStatus DeploymentStatus `locationName:"lastDeploymentStatus" type:"string" enum:"true"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the fleet.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Fleet) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastDeploymentJob != nil {
		v := *s.LastDeploymentJob

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentJob", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.LastDeploymentStatus) > 0 {
		v := s.LastDeploymentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastDeploymentTime != nil {
		v := *s.LastDeploymentTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a launch configuration.
type LaunchConfig struct {
	_ struct{} `type:"structure"`

	// The environment variables for the application launch.
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// The port forwarding configuration.
	PortForwardingConfig *PortForwardingConfig `locationName:"portForwardingConfig" type:"structure"`

	// Boolean indicating whether a streaming session will be configured for the
	// application. If True, AWS RoboMaker will configure a connection so you can
	// interact with your application as it is running in the simulation. You must
	// configure and luanch the component. It must have a graphical user interface.
	StreamUI *bool `locationName:"streamUI" type:"boolean"`
}

// String returns the string representation
func (s LaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchConfig"}

	if s.LaunchFile == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchFile", 1))
	}

	if s.PackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageName", 1))
	}
	if s.PortForwardingConfig != nil {
		if err := s.PortForwardingConfig.Validate(); err != nil {
			invalidParams.AddNested("PortForwardingConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LaunchConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.LaunchFile != nil {
		v := *s.LaunchFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageName != nil {
		v := *s.PackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "packageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortForwardingConfig != nil {
		v := s.PortForwardingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portForwardingConfig", v, metadata)
	}
	if s.StreamUI != nil {
		v := *s.StreamUI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "streamUI", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The logging configuration.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether to record all ROS topics.
	//
	// RecordAllRosTopics is a required field
	RecordAllRosTopics *bool `locationName:"recordAllRosTopics" type:"boolean" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingConfig"}

	if s.RecordAllRosTopics == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordAllRosTopics"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecordAllRosTopics != nil {
		v := *s.RecordAllRosTopics

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "recordAllRosTopics", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Describes a network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The IPv4 public address of the network interface.
	PublicIpAddress *string `locationName:"publicIpAddress" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkInterface) MarshalFields(e protocol.FieldEncoder) error {
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddress != nil {
		v := *s.PrivateIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublicIpAddress != nil {
		v := *s.PublicIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output location.
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket for output.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The S3 folder in the s3Bucket where output files will be placed.
	S3Prefix *string `locationName:"s3Prefix" min:"1" type:"string"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Prefix != nil {
		v := *s.S3Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration information for port forwarding.
type PortForwardingConfig struct {
	_ struct{} `type:"structure"`

	// The port mappings for the configuration.
	PortMappings []PortMapping `locationName:"portMappings" type:"list"`
}

// String returns the string representation
func (s PortForwardingConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortForwardingConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortForwardingConfig"}
	if s.PortMappings != nil {
		for i, v := range s.PortMappings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortMappings", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortForwardingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortMappings != nil {
		v := s.PortMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "portMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An object representing a port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port number on the application.
	//
	// ApplicationPort is a required field
	ApplicationPort *int64 `locationName:"applicationPort" min:"1024" type:"integer" required:"true"`

	// A Boolean indicating whether to enable this port mapping on public IP.
	EnableOnPublicIp *bool `locationName:"enableOnPublicIp" type:"boolean"`

	// The port number on the simulation job instance to use as a remote connection
	// point.
	//
	// JobPort is a required field
	JobPort *int64 `locationName:"jobPort" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortMapping"}

	if s.ApplicationPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationPort"))
	}
	if s.ApplicationPort != nil && *s.ApplicationPort < 1024 {
		invalidParams.Add(aws.NewErrParamMinValue("ApplicationPort", 1024))
	}

	if s.JobPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobPort"))
	}
	if s.JobPort != nil && *s.JobPort < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("JobPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationPort != nil {
		v := *s.ApplicationPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationPort", protocol.Int64Value(v), metadata)
	}
	if s.EnableOnPublicIp != nil {
		v := *s.EnableOnPublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableOnPublicIp", protocol.BoolValue(v), metadata)
	}
	if s.JobPort != nil {
		v := *s.JobPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobPort", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about the progress of a deployment job.
type ProgressDetail struct {
	_ struct{} `type:"structure"`

	// The current progress status.
	//
	// Validating
	//
	// Validating the deployment.
	//
	// DownloadingExtracting
	//
	// Downloading and extracting the bundle on the robot.
	//
	// ExecutingPreLaunch
	//
	// Executing pre-launch script(s) if provided.
	//
	// Launching
	//
	// Launching the robot application.
	//
	// ExecutingPostLaunch
	//
	// Executing post-launch script(s) if provided.
	//
	// Finished
	//
	// Deployment is complete.
	CurrentProgress RobotDeploymentStep `locationName:"currentProgress" type:"string" enum:"true"`

	// Estimated amount of time in seconds remaining in the step. This currently
	// only applies to the Downloading/Extracting step of the deployment. It is
	// empty for other steps.
	EstimatedTimeRemainingSeconds *int64 `locationName:"estimatedTimeRemainingSeconds" type:"integer"`

	// Precentage of the step that is done. This currently only applies to the Downloading/Extracting
	// step of the deployment. It is empty for other steps.
	PercentDone *float64 `locationName:"percentDone" type:"float"`

	// The Amazon Resource Name (ARN) of the deployment job.
	TargetResource *string `locationName:"targetResource" type:"string"`
}

// String returns the string representation
func (s ProgressDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProgressDetail) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CurrentProgress) > 0 {
		v := s.CurrentProgress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "currentProgress", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EstimatedTimeRemainingSeconds != nil {
		v := *s.EstimatedTimeRemainingSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedTimeRemainingSeconds", protocol.Int64Value(v), metadata)
	}
	if s.PercentDone != nil {
		v := *s.PercentDone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "percentDone", protocol.Float64Value(v), metadata)
	}
	if s.TargetResource != nil {
		v := *s.TargetResource

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "targetResource", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a rendering engine.
type RenderingEngine struct {
	_ struct{} `type:"structure"`

	// The name of the rendering engine.
	Name RenderingEngineType `locationName:"name" type:"string" enum:"true"`

	// The version of the rendering engine.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s RenderingEngine) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderingEngine) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenderingEngine"}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RenderingEngine) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a robot.
type Robot struct {
	_ struct{} `type:"structure"`

	// The architecture of the robot.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `locationName:"fleetArn" min:"1" type:"string"`

	// The Greengrass group associated with the robot.
	GreenGrassGroupId *string `locationName:"greenGrassGroupId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the robot.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the robot.
	Status RobotStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s Robot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Robot) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GreenGrassGroupId != nil {
		v := *s.GreenGrassGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "greenGrassGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentJob != nil {
		v := *s.LastDeploymentJob

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentJob", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentTime != nil {
		v := *s.LastDeploymentTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Application configuration information for a robot.
type RobotApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the robot application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the robot application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s RobotApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RobotApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RobotApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Summary information for a robot application.
type RobotApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s RobotApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotApplicationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a robot deployment.
type RobotDeployment struct {
	_ struct{} `type:"structure"`

	// The robot deployment Amazon Resource Name (ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment finished.
	DeploymentFinishTime *time.Time `locationName:"deploymentFinishTime" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the deployment was started.
	DeploymentStartTime *time.Time `locationName:"deploymentStartTime" type:"timestamp"`

	// The robot deployment failure code.
	FailureCode DeploymentJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// A short description of the reason why the robot deployment failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// Information about how the deployment is progressing.
	ProgressDetail *ProgressDetail `locationName:"progressDetail" type:"structure"`

	// The status of the robot deployment.
	Status RobotStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s RobotDeployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotDeployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentFinishTime != nil {
		v := *s.DeploymentFinishTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentFinishTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DeploymentStartTime != nil {
		v := *s.DeploymentStartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProgressDetail != nil {
		v := s.ProgressDetail

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "progressDetail", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a robot software suite (ROS distribution).
type RobotSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the robot software suite (ROS distribution).
	Name RobotSoftwareSuiteType `locationName:"name" type:"string" enum:"true"`

	// The version of the robot software suite (ROS distribution).
	Version RobotSoftwareSuiteVersionType `locationName:"version" type:"string" enum:"true"`
}

// String returns the string representation
func (s RobotSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RobotSoftwareSuite) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Version) > 0 {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about S3 keys.
type S3KeyOutput struct {
	_ struct{} `type:"structure"`

	// The etag for the object.
	Etag *string `locationName:"etag" type:"string"`

	// The S3 key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s S3KeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3KeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Etag != nil {
		v := *s.Etag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an S3 object.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The bucket containing the object.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The etag of the object.
	Etag *string `locationName:"etag" type:"string"`

	// The key of the object.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Object"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Object) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Etag != nil {
		v := *s.Etag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a simulation application configuration.
type SimulationApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the simulation application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the simulation application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s SimulationApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulationApplicationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SimulationApplicationConfig"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if s.LaunchConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationApplicationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApplicationVersion != nil {
		v := *s.ApplicationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfig != nil {
		v := s.LaunchConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchConfig", v, metadata)
	}
	return nil
}

// Summary information for a simulation application.
type SimulationApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// Information about a simulation software suite.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s SimulationApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationApplicationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotSoftwareSuite != nil {
		v := s.RobotSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "robotSoftwareSuite", v, metadata)
	}
	if s.SimulationSoftwareSuite != nil {
		v := s.SimulationSoftwareSuite

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "simulationSoftwareSuite", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a simulation job.
type SimulationJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A unique identifier for this SimulationJob request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Compute information for the simulation job
	Compute *ComputeResponse `locationName:"compute" type:"structure"`

	// The data sources for the simulation job.
	DataSources []DataSource `locationName:"dataSources" type:"list"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior FailureBehavior `locationName:"failureBehavior" type:"string" enum:"true"`

	// The failure code of the simulation job if it failed.
	FailureCode SimulationJobErrorCode `locationName:"failureCode" type:"string" enum:"true"`

	// The reason why the simulation job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The IAM role that allows the simulation instance to call the AWS APIs that
	// are specified in its associated policies on your behalf. This is how credentials
	// are passed in to your simulation job.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds. The value must be 8 days
	// (691,200 seconds) or less.
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Location for output files generated by the simulation job.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// A list of robot applications.
	RobotApplications []RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// A list of simulation applications.
	SimulationApplications []SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// The simulation job execution duration in milliseconds.
	SimulationTimeMillis *int64 `locationName:"simulationTimeMillis" type:"long"`

	// Status of the simulation job.
	Status SimulationJobStatus `locationName:"status" type:"string" enum:"true"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job.
	Tags map[string]string `locationName:"tags" type:"map"`

	// VPC configuration information.
	VpcConfig *VPCConfigResponse `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s SimulationJob) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJob) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientRequestToken != nil {
		v := *s.ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Compute != nil {
		v := s.Compute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "compute", v, metadata)
	}
	if s.DataSources != nil {
		v := s.DataSources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dataSources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.FailureBehavior) > 0 {
		v := s.FailureBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.FailureCode) > 0 {
		v := s.FailureCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRole != nil {
		v := *s.IamRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iamRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastStartedAt != nil {
		v := *s.LastStartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastStartedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LoggingConfig != nil {
		v := s.LoggingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "loggingConfig", v, metadata)
	}
	if s.MaxJobDurationInSeconds != nil {
		v := *s.MaxJobDurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxJobDurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkInterface != nil {
		v := s.NetworkInterface

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "networkInterface", v, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputLocation", v, metadata)
	}
	if s.RobotApplications != nil {
		v := s.RobotApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "robotApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SimulationApplications != nil {
		v := s.SimulationApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SimulationTimeMillis != nil {
		v := *s.SimulationTimeMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "simulationTimeMillis", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpcConfig", v, metadata)
	}
	return nil
}

// Information about a simulation job batch.
type SimulationJobBatchSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The number of created simulation job requests.
	CreatedRequestCount *int64 `locationName:"createdRequestCount" type:"integer"`

	// The number of failed simulation job requests.
	FailedRequestCount *int64 `locationName:"failedRequestCount" type:"integer"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The number of pending simulation job requests.
	PendingRequestCount *int64 `locationName:"pendingRequestCount" type:"integer"`

	// The status of the simulation job batch.
	//
	// Pending
	//
	// The simulation job batch request is pending.
	//
	// InProgress
	//
	// The simulation job batch is in progress.
	//
	// Failed
	//
	// The simulation job batch failed. One or more simulation job requests could
	// not be completed due to an internal failure (like InternalServiceError).
	// See failureCode and failureReason for more information.
	//
	// Completed
	//
	// The simulation batch job completed. A batch is complete when (1) there are
	// no pending simulation job requests in the batch and none of the failed simulation
	// job requests are due to InternalServiceError and (2) when all created simulation
	// jobs have reached a terminal state (for example, Completed or Failed).
	//
	// Canceled
	//
	// The simulation batch job was cancelled.
	//
	// Canceling
	//
	// The simulation batch job is being cancelled.
	//
	// Completing
	//
	// The simulation batch job is completing.
	//
	// TimingOut
	//
	// The simulation job batch is timing out.
	//
	// If a batch timing out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), the batch status will
	// be Failed. If there are no such failing request, the batch status will be
	// TimedOut.
	//
	// TimedOut
	//
	// The simulation batch job timed out.
	Status SimulationJobBatchStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s SimulationJobBatchSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJobBatchSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreatedRequestCount != nil {
		v := *s.CreatedRequestCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdRequestCount", protocol.Int64Value(v), metadata)
	}
	if s.FailedRequestCount != nil {
		v := *s.FailedRequestCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failedRequestCount", protocol.Int64Value(v), metadata)
	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PendingRequestCount != nil {
		v := *s.PendingRequestCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pendingRequestCount", protocol.Int64Value(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a simulation job request.
type SimulationJobRequest struct {
	_ struct{} `type:"structure"`

	// Compute information for the simulation job
	Compute *Compute `locationName:"compute" type:"structure"`

	// Specify data sources to mount read-only files from S3 into your simulation.
	// These files are available under /opt/robomaker/datasources/data_source_name.
	//
	// There is a limit of 100 files and a combined size of 25GB for all DataSourceConfig
	// objects.
	DataSources []DataSourceConfig `locationName:"dataSources" min:"1" type:"list"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior FailureBehavior `locationName:"failureBehavior" type:"string" enum:"true"`

	// The IAM role name that allows the simulation instance to call the AWS APIs
	// that are specified in its associated policies on your behalf. This is how
	// credentials are passed in to your simulation job.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds. The value must be 8 days
	// (691,200 seconds) or less.
	//
	// MaxJobDurationInSeconds is a required field
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long" required:"true"`

	// The output location.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The robot applications to use in the simulation job.
	RobotApplications []RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// The simulation applications to use in the simulation job.
	SimulationApplications []SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job request.
	Tags map[string]string `locationName:"tags" type:"map"`

	// Boolean indicating whether to use default simulation tool applications.
	UseDefaultApplications *bool `locationName:"useDefaultApplications" type:"boolean"`

	// If your simulation job accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and two subnet
	// IDs.
	VpcConfig *VPCConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s SimulationJobRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulationJobRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SimulationJobRequest"}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DataSources", 1))
	}
	if s.IamRole != nil && len(*s.IamRole) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IamRole", 1))
	}

	if s.MaxJobDurationInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxJobDurationInSeconds"))
	}
	if s.RobotApplications != nil && len(s.RobotApplications) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RobotApplications", 1))
	}
	if s.SimulationApplications != nil && len(s.SimulationApplications) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SimulationApplications", 1))
	}
	if s.Compute != nil {
		if err := s.Compute.Validate(); err != nil {
			invalidParams.AddNested("Compute", err.(aws.ErrInvalidParams))
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.RobotApplications != nil {
		for i, v := range s.RobotApplications {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RobotApplications", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SimulationApplications != nil {
		for i, v := range s.SimulationApplications {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SimulationApplications", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJobRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Compute != nil {
		v := s.Compute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "compute", v, metadata)
	}
	if s.DataSources != nil {
		v := s.DataSources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dataSources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.FailureBehavior) > 0 {
		v := s.FailureBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "failureBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IamRole != nil {
		v := *s.IamRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iamRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LoggingConfig != nil {
		v := s.LoggingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "loggingConfig", v, metadata)
	}
	if s.MaxJobDurationInSeconds != nil {
		v := *s.MaxJobDurationInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxJobDurationInSeconds", protocol.Int64Value(v), metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputLocation", v, metadata)
	}
	if s.RobotApplications != nil {
		v := s.RobotApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "robotApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SimulationApplications != nil {
		v := s.SimulationApplications

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationApplications", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UseDefaultApplications != nil {
		v := *s.UseDefaultApplications

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "useDefaultApplications", protocol.BoolValue(v), metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "vpcConfig", v, metadata)
	}
	return nil
}

// Summary information for a simulation job.
type SimulationJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The names of the data sources.
	DataSourceNames []string `locationName:"dataSourceNames" type:"list"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of simulation job robot application names.
	RobotApplicationNames []string `locationName:"robotApplicationNames" type:"list"`

	// A list of simulation job simulation application names.
	SimulationApplicationNames []string `locationName:"simulationApplicationNames" type:"list"`

	// The status of the simulation job.
	Status SimulationJobStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s SimulationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationJobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DataSourceNames != nil {
		v := s.DataSourceNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "dataSourceNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LastUpdatedAt != nil {
		v := *s.LastUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RobotApplicationNames != nil {
		v := s.RobotApplicationNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "robotApplicationNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SimulationApplicationNames != nil {
		v := s.SimulationApplicationNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "simulationApplicationNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a simulation software suite.
type SimulationSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the simulation software suite.
	Name SimulationSoftwareSuiteType `locationName:"name" type:"string" enum:"true"`

	// The version of the simulation software suite.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s SimulationSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SimulationSoftwareSuite) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a source.
type Source struct {
	_ struct{} `type:"structure"`

	// The taget processor architecture for the application.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// A hash of the object specified by s3Bucket and s3Key.
	Etag *string `locationName:"etag" type:"string"`

	// The s3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Source) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Etag != nil {
		v := *s.Etag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "etag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a source configuration.
type SourceConfig struct {
	_ struct{} `type:"structure"`

	// The target processor architecture for the application.
	Architecture Architecture `locationName:"architecture" type:"string" enum:"true"`

	// The Amazon S3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s SourceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceConfig"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Architecture) > 0 {
		v := s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "architecture", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// If your simulation job accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and two subnet
// IDs.
type VPCConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether to assign a public IP address.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroups []string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of one or more subnet IDs in your VPC.
	//
	// Subnets is a required field
	Subnets []string `locationName:"subnets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VPCConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPCConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VPCConfig"}
	if s.SecurityGroups != nil && len(s.SecurityGroups) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityGroups", 1))
	}

	if s.Subnets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignPublicIp != nil {
		v := *s.AssignPublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assignPublicIp", protocol.BoolValue(v), metadata)
	}
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// VPC configuration associated with your simulation job.
type VPCConfigResponse struct {
	_ struct{} `type:"structure"`

	// A boolean indicating if a public IP was assigned.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of security group IDs associated with the simulation job.
	SecurityGroups []string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of subnet IDs associated with the simulation job.
	Subnets []string `locationName:"subnets" min:"1" type:"list"`

	// The VPC ID associated with your simulation job.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VPCConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPCConfigResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignPublicIp != nil {
		v := *s.AssignPublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "assignPublicIp", protocol.BoolValue(v), metadata)
	}
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
