// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteQueryLoggingConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the configuration that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteQueryLoggingConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueryLoggingConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteQueryLoggingConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteQueryLoggingConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteQueryLoggingConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteQueryLoggingConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteQueryLoggingConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteQueryLoggingConfig = "DeleteQueryLoggingConfig"

// DeleteQueryLoggingConfigRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Deletes a configuration for DNS query logging. If you delete a configuration,
// Amazon Route 53 stops sending query logs to CloudWatch Logs. Route 53 doesn't
// delete any logs that are already in CloudWatch Logs.
//
// For more information about DNS query logs, see CreateQueryLoggingConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
//
//    // Example sending a request using DeleteQueryLoggingConfigRequest.
//    req := client.DeleteQueryLoggingConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteQueryLoggingConfig
func (c *Client) DeleteQueryLoggingConfigRequest(input *DeleteQueryLoggingConfigInput) DeleteQueryLoggingConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteQueryLoggingConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/queryloggingconfig/{Id}",
	}

	if input == nil {
		input = &DeleteQueryLoggingConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteQueryLoggingConfigOutput{})

	return DeleteQueryLoggingConfigRequest{Request: req, Input: input, Copy: c.DeleteQueryLoggingConfigRequest}
}

// DeleteQueryLoggingConfigRequest is the request type for the
// DeleteQueryLoggingConfig API operation.
type DeleteQueryLoggingConfigRequest struct {
	*aws.Request
	Input *DeleteQueryLoggingConfigInput
	Copy  func(*DeleteQueryLoggingConfigInput) DeleteQueryLoggingConfigRequest
}

// Send marshals and sends the DeleteQueryLoggingConfig API request.
func (r DeleteQueryLoggingConfigRequest) Send(ctx context.Context) (*DeleteQueryLoggingConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteQueryLoggingConfigResponse{
		DeleteQueryLoggingConfigOutput: r.Request.Data.(*DeleteQueryLoggingConfigOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteQueryLoggingConfigResponse is the response type for the
// DeleteQueryLoggingConfig API operation.
type DeleteQueryLoggingConfigResponse struct {
	*DeleteQueryLoggingConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteQueryLoggingConfig request.
func (r *DeleteQueryLoggingConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
