// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to delete a reusable delegation set.
type DeleteReusableDelegationSetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the reusable delegation set that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReusableDelegationSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReusableDelegationSetInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteReusableDelegationSetInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// An empty element.
type DeleteReusableDelegationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteReusableDelegationSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteReusableDelegationSet = "DeleteReusableDelegationSet"

// DeleteReusableDelegationSetRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Deletes a reusable delegation set.
//
// You can delete a reusable delegation set only if it isn't associated with
// any hosted zones.
//
// To verify that the reusable delegation set is not associated with any hosted
// zones, submit a GetReusableDelegationSet (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html)
// request and specify the ID of the reusable delegation set that you want to
// delete.
//
//    // Example sending a request using DeleteReusableDelegationSetRequest.
//    req := client.DeleteReusableDelegationSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet
func (c *Client) DeleteReusableDelegationSetRequest(input *DeleteReusableDelegationSetInput) DeleteReusableDelegationSetRequest {
	op := &aws.Operation{
		Name:       opDeleteReusableDelegationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &DeleteReusableDelegationSetInput{}
	}

	req := c.newRequest(op, input, &DeleteReusableDelegationSetOutput{})

	return DeleteReusableDelegationSetRequest{Request: req, Input: input, Copy: c.DeleteReusableDelegationSetRequest}
}

// DeleteReusableDelegationSetRequest is the request type for the
// DeleteReusableDelegationSet API operation.
type DeleteReusableDelegationSetRequest struct {
	*aws.Request
	Input *DeleteReusableDelegationSetInput
	Copy  func(*DeleteReusableDelegationSetInput) DeleteReusableDelegationSetRequest
}

// Send marshals and sends the DeleteReusableDelegationSet API request.
func (r DeleteReusableDelegationSetRequest) Send(ctx context.Context) (*DeleteReusableDelegationSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReusableDelegationSetResponse{
		DeleteReusableDelegationSetOutput: r.Request.Data.(*DeleteReusableDelegationSetOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReusableDelegationSetResponse is the response type for the
// DeleteReusableDelegationSet API operation.
type DeleteReusableDelegationSetResponse struct {
	*DeleteReusableDelegationSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReusableDelegationSet request.
func (r *DeleteReusableDelegationSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
