// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A complex type that contains the information about the request to list your
// traffic policy instances.
type ListTrafficPolicyInstancesByPolicyInput struct {
	_ struct{} `type:"structure"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of hostedzoneid, specify the value of HostedZoneIdMarker from
	// the previous response, which is the hosted zone ID of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	HostedZoneIdMarker *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance that Amazon Route 53 will return
	// if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The ID of the traffic policy for which you want to list traffic policy instances.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `location:"querystring" locationName:"id" min:"1" type:"string" required:"true"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of trafficpolicyinstancename, specify the value of TrafficPolicyInstanceNameMarker
	// from the previous response, which is the name of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// If the value of IsTruncated in the previous response was true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstancesByPolicy request.
	//
	// For the value of trafficpolicyinstancetype, specify the value of TrafficPolicyInstanceTypeMarker
	// from the previous response, which is the name of the first traffic policy
	// instance that Amazon Route 53 will return if you submit another request.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker RRType `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"true"`

	// The version of the traffic policy for which you want to list traffic policy
	// instances. The version must be associated with the traffic policy that is
	// specified by TrafficPolicyId.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `location:"querystring" locationName:"version" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByPolicyInput"}

	if s.TrafficPolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrafficPolicyId"))
	}
	if s.TrafficPolicyId != nil && len(*s.TrafficPolicyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrafficPolicyId", 1))
	}

	if s.TrafficPolicyVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrafficPolicyVersion"))
	}
	if s.TrafficPolicyVersion != nil && *s.TrafficPolicyVersion < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TrafficPolicyVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTrafficPolicyInstancesByPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HostedZoneIdMarker != nil {
		v := *s.HostedZoneIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "hostedzoneid", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxitems", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyId != nil {
		v := *s.TrafficPolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyInstanceNameMarker != nil {
		v := *s.TrafficPolicyInstanceNameMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "trafficpolicyinstancename", protocol.StringValue(v), metadata)
	}
	if len(s.TrafficPolicyInstanceTypeMarker) > 0 {
		v := s.TrafficPolicyInstanceTypeMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "trafficpolicyinstancetype", v, metadata)
	}
	if s.TrafficPolicyVersion != nil {
		v := *s.TrafficPolicyVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If IsTruncated is true, HostedZoneIdMarker is the ID of the hosted zone of
	// the first traffic policy instance in the next group of traffic policy instances.
	HostedZoneIdMarker *string `type:"string"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of traffic
	// policy instances by calling ListTrafficPolicyInstancesByPolicy again and
	// specifying the values of the HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker elements in the corresponding request
	// parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the call to ListTrafficPolicyInstancesByPolicy
	// that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of MaxItems traffic policy
	// instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of MaxItems traffic policy instances.
	TrafficPolicyInstanceTypeMarker RRType `type:"string" enum:"true"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTrafficPolicyInstancesByPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZoneIdMarker != nil {
		v := *s.HostedZoneIdMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneIdMarker", protocol.StringValue(v), metadata)
	}
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyInstanceNameMarker != nil {
		v := *s.TrafficPolicyInstanceNameMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyInstanceNameMarker", protocol.StringValue(v), metadata)
	}
	if len(s.TrafficPolicyInstanceTypeMarker) > 0 {
		v := s.TrafficPolicyInstanceTypeMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyInstanceTypeMarker", v, metadata)
	}
	if s.TrafficPolicyInstances != nil {
		v := s.TrafficPolicyInstances

		metadata := protocol.Metadata{ListLocationName: "TrafficPolicyInstance"}
		ls0 := e.List(protocol.BodyTarget, "TrafficPolicyInstances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListTrafficPolicyInstancesByPolicy = "ListTrafficPolicyInstancesByPolicy"

// ListTrafficPolicyInstancesByPolicyRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Gets information about the traffic policy instances that you created by using
// a specify traffic policy version.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// Route 53 returns a maximum of 100 items in each response. If you have a lot
// of traffic policy instances, you can use the MaxItems parameter to list them
// in groups of up to 100.
//
//    // Example sending a request using ListTrafficPolicyInstancesByPolicyRequest.
//    req := client.ListTrafficPolicyInstancesByPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy
func (c *Client) ListTrafficPolicyInstancesByPolicyRequest(input *ListTrafficPolicyInstancesByPolicyInput) ListTrafficPolicyInstancesByPolicyRequest {
	op := &aws.Operation{
		Name:       opListTrafficPolicyInstancesByPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/trafficpolicy",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByPolicyInput{}
	}

	req := c.newRequest(op, input, &ListTrafficPolicyInstancesByPolicyOutput{})

	return ListTrafficPolicyInstancesByPolicyRequest{Request: req, Input: input, Copy: c.ListTrafficPolicyInstancesByPolicyRequest}
}

// ListTrafficPolicyInstancesByPolicyRequest is the request type for the
// ListTrafficPolicyInstancesByPolicy API operation.
type ListTrafficPolicyInstancesByPolicyRequest struct {
	*aws.Request
	Input *ListTrafficPolicyInstancesByPolicyInput
	Copy  func(*ListTrafficPolicyInstancesByPolicyInput) ListTrafficPolicyInstancesByPolicyRequest
}

// Send marshals and sends the ListTrafficPolicyInstancesByPolicy API request.
func (r ListTrafficPolicyInstancesByPolicyRequest) Send(ctx context.Context) (*ListTrafficPolicyInstancesByPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrafficPolicyInstancesByPolicyResponse{
		ListTrafficPolicyInstancesByPolicyOutput: r.Request.Data.(*ListTrafficPolicyInstancesByPolicyOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTrafficPolicyInstancesByPolicyResponse is the response type for the
// ListTrafficPolicyInstancesByPolicy API operation.
type ListTrafficPolicyInstancesByPolicyResponse struct {
	*ListTrafficPolicyInstancesByPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrafficPolicyInstancesByPolicy request.
func (r *ListTrafficPolicyInstancesByPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
