// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to update the comment for a hosted zone.
type UpdateHostedZoneCommentInput struct {
	_ struct{} `locationName:"UpdateHostedZoneCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// The new comment for the hosted zone. If you don't specify a value for Comment,
	// Amazon Route 53 deletes the existing value of the Comment element, if any.
	Comment *string `type:"string"`

	// The ID for the hosted zone that you want to update the comment for.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHostedZoneCommentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateHostedZoneCommentInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateHostedZoneCommentInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "UpdateHostedZoneCommentRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.Comment != nil {
			v := *s.Comment

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "https://route53.amazonaws.com/doc/2013-04-01/"})
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the response to the UpdateHostedZoneComment
// request.
type UpdateHostedZoneCommentOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the response to the UpdateHostedZoneComment
	// request.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateHostedZoneCommentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZone != nil {
		v := s.HostedZone

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HostedZone", v, metadata)
	}
	return nil
}

const opUpdateHostedZoneComment = "UpdateHostedZoneComment"

// UpdateHostedZoneCommentRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Updates the comment for a specified hosted zone.
//
//    // Example sending a request using UpdateHostedZoneCommentRequest.
//    req := client.UpdateHostedZoneCommentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment
func (c *Client) UpdateHostedZoneCommentRequest(input *UpdateHostedZoneCommentInput) UpdateHostedZoneCommentRequest {
	op := &aws.Operation{
		Name:       opUpdateHostedZoneComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &UpdateHostedZoneCommentInput{}
	}

	req := c.newRequest(op, input, &UpdateHostedZoneCommentOutput{})

	return UpdateHostedZoneCommentRequest{Request: req, Input: input, Copy: c.UpdateHostedZoneCommentRequest}
}

// UpdateHostedZoneCommentRequest is the request type for the
// UpdateHostedZoneComment API operation.
type UpdateHostedZoneCommentRequest struct {
	*aws.Request
	Input *UpdateHostedZoneCommentInput
	Copy  func(*UpdateHostedZoneCommentInput) UpdateHostedZoneCommentRequest
}

// Send marshals and sends the UpdateHostedZoneComment API request.
func (r UpdateHostedZoneCommentRequest) Send(ctx context.Context) (*UpdateHostedZoneCommentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateHostedZoneCommentResponse{
		UpdateHostedZoneCommentOutput: r.Request.Data.(*UpdateHostedZoneCommentOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateHostedZoneCommentResponse is the response type for the
// UpdateHostedZoneComment API operation.
type UpdateHostedZoneCommentResponse struct {
	*UpdateHostedZoneCommentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateHostedZoneComment request.
func (r *UpdateHostedZoneCommentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
