// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type GetBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// The bucket name for which to get the cors configuration.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketCorsInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketCorsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

func (s *GetBucketCorsInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketCorsInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	CORSRules []CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketCorsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CORSRules != nil {
		v := s.CORSRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CORSRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the cors configuration information set for the bucket.
//
// To use this operation, you must have permission to perform the s3:GetBucketCORS
// action. By default, the bucket owner has this permission and can grant it
// to others.
//
// For more information about cors, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html).
//
// The following operations are related to GetBucketCors:
//
//    * PutBucketCors
//
//    * DeleteBucketCors
//
//    // Example sending a request using GetBucketCorsRequest.
//    req := client.GetBucketCorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *Client) GetBucketCorsRequest(input *GetBucketCorsInput) GetBucketCorsRequest {
	op := &aws.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	req := c.newRequest(op, input, &GetBucketCorsOutput{})

	return GetBucketCorsRequest{Request: req, Input: input, Copy: c.GetBucketCorsRequest}
}

// GetBucketCorsRequest is the request type for the
// GetBucketCors API operation.
type GetBucketCorsRequest struct {
	*aws.Request
	Input *GetBucketCorsInput
	Copy  func(*GetBucketCorsInput) GetBucketCorsRequest
}

// Send marshals and sends the GetBucketCors API request.
func (r GetBucketCorsRequest) Send(ctx context.Context) (*GetBucketCorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBucketCorsResponse{
		GetBucketCorsOutput: r.Request.Data.(*GetBucketCorsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBucketCorsResponse is the response type for the
// GetBucketCors API operation.
type GetBucketCorsResponse struct {
	*GetBucketCorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBucketCors request.
func (r *GetBucketCorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
