// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type GetBucketLocationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket for which to get the location.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketLocationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketLocationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLocationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

func (s *GetBucketLocationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketLocationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket resides. For a list of all the Amazon
	// S3 supported location constraints by Region, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region).
	// Buckets in Region us-east-1 have a LocationConstraint of null.
	LocationConstraint BucketLocationConstraint `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketLocationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LocationConstraint) > 0 {
		v := s.LocationConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationConstraint", v, metadata)
	}
	return nil
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the Region the bucket resides in. You set the bucket's Region using
// the LocationConstraint request parameter in a CreateBucket request. For more
// information, see CreateBucket.
//
// To use this implementation of the operation, you must be the bucket owner.
//
// The following operations are related to GetBucketLocation:
//
//    * GetObject
//
//    * CreateBucket
//
//    // Example sending a request using GetBucketLocationRequest.
//    req := client.GetBucketLocationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *Client) GetBucketLocationRequest(input *GetBucketLocationInput) GetBucketLocationRequest {
	op := &aws.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	req := c.newRequest(op, input, &GetBucketLocationOutput{})

	return GetBucketLocationRequest{Request: req, Input: input, Copy: c.GetBucketLocationRequest}
}

// GetBucketLocationRequest is the request type for the
// GetBucketLocation API operation.
type GetBucketLocationRequest struct {
	*aws.Request
	Input *GetBucketLocationInput
	Copy  func(*GetBucketLocationInput) GetBucketLocationRequest
}

// Send marshals and sends the GetBucketLocation API request.
func (r GetBucketLocationRequest) Send(ctx context.Context) (*GetBucketLocationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBucketLocationResponse{
		GetBucketLocationOutput: r.Request.Data.(*GetBucketLocationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBucketLocationResponse is the response type for the
// GetBucketLocation API operation.
type GetBucketLocationResponse struct {
	*GetBucketLocationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBucketLocation request.
func (r *GetBucketLocationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
