// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type GetBucketVersioningInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket for which to get the versioning information.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBucketVersioningInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *GetBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketVersioningInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

func (s *GetBucketVersioningInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *GetBucketVersioningInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete MFADeleteStatus `locationName:"MfaDelete" type:"string" enum:"true"`

	// The versioning state of the bucket.
	Status BucketVersioningStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBucketVersioningOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MFADelete) > 0 {
		v := s.MFADelete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MfaDelete", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Returns the versioning state of a bucket.
//
// To retrieve the versioning state of a bucket, you must be the bucket owner.
//
// This implementation also returns the MFA Delete status of the versioning
// state. If the MFA Delete status is enabled, the bucket owner must use an
// authentication device to change the versioning state of the bucket.
//
// The following operations are related to GetBucketVersioning:
//
//    * GetObject
//
//    * PutObject
//
//    * DeleteObject
//
//    // Example sending a request using GetBucketVersioningRequest.
//    req := client.GetBucketVersioningRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *Client) GetBucketVersioningRequest(input *GetBucketVersioningInput) GetBucketVersioningRequest {
	op := &aws.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	req := c.newRequest(op, input, &GetBucketVersioningOutput{})

	return GetBucketVersioningRequest{Request: req, Input: input, Copy: c.GetBucketVersioningRequest}
}

// GetBucketVersioningRequest is the request type for the
// GetBucketVersioning API operation.
type GetBucketVersioningRequest struct {
	*aws.Request
	Input *GetBucketVersioningInput
	Copy  func(*GetBucketVersioningInput) GetBucketVersioningRequest
}

// Send marshals and sends the GetBucketVersioning API request.
func (r GetBucketVersioningRequest) Send(ctx context.Context) (*GetBucketVersioningResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBucketVersioningResponse{
		GetBucketVersioningOutput: r.Request.Data.(*GetBucketVersioningOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBucketVersioningResponse is the response type for the
// GetBucketVersioning API operation.
type GetBucketVersioningResponse struct {
	*GetBucketVersioningOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBucketVersioning request.
func (r *GetBucketVersioningResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
