// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
	"github.com/aws/aws-sdk-go-v2/service/s3/internal/arn"
)

type PutBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// The name of the bucket.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A container for specifying the notification configuration of the bucket.
	// If this element is empty, notifications are turned off for the bucket.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `locationName:"NotificationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketNotificationConfigurationInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.NotificationConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotificationConfiguration"))
	}
	if s.NotificationConfiguration != nil {
		if err := s.NotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketNotificationConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.NotificationConfiguration != nil {
		v := s.NotificationConfiguration

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "NotificationConfiguration", v, metadata)
	}
	return nil
}

func (s *PutBucketNotificationConfigurationInput) getEndpointARN() (arn.Resource, error) {
	if s.Bucket == nil {
		return nil, fmt.Errorf("member Bucket is nil")
	}
	return parseEndpointARN(*s.Bucket)
}

func (s *PutBucketNotificationConfigurationInput) hasEndpointARN() bool {
	if s.Bucket == nil {
		return false
	}
	return arn.IsARN(*s.Bucket)
}

type PutBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketNotificationConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Enables notifications of specified events for a bucket. For more information
// about event notifications, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
//
// Using this API, you can replace an existing notification configuration. The
// configuration is an XML file that defines the event types that you want Amazon
// S3 to publish and the destination where you want Amazon S3 to publish an
// event notification when it detects an event of the specified type.
//
// By default, your bucket has no event notifications configured. That is, the
// notification configuration will be an empty NotificationConfiguration.
//
// <NotificationConfiguration>
//
// </NotificationConfiguration>
//
// This operation replaces the existing notification configuration with the
// configuration you include in the request body.
//
// After Amazon S3 receives this request, it first verifies that any Amazon
// Simple Notification Service (Amazon SNS) or Amazon Simple Queue Service (Amazon
// SQS) destination exists, and that the bucket owner has permission to publish
// to it by sending a test notification. In the case of AWS Lambda destinations,
// Amazon S3 verifies that the Lambda function permissions grant Amazon S3 permission
// to invoke the function from the Amazon S3 bucket. For more information, see
// Configuring Notifications for Amazon S3 Events (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html).
//
// You can disable notifications by adding the empty NotificationConfiguration
// element.
//
// By default, only the bucket owner can configure notifications on a bucket.
// However, bucket owners can use a bucket policy to grant permission to other
// users to set this configuration with s3:PutBucketNotification permission.
//
// The PUT notification is an atomic operation. For example, suppose your notification
// configuration includes SNS topic, SQS queue, and Lambda function configurations.
// When you send a PUT request with this configuration, Amazon S3 sends test
// messages to your SNS topic. If the message fails, the entire PUT operation
// will fail, and Amazon S3 will not add the configuration to your bucket.
//
// Responses
//
// If the configuration in the request body includes only one TopicConfiguration
// specifying only the s3:ReducedRedundancyLostObject event type, the response
// will also include the x-amz-sns-test-message-id header containing the message
// ID of the test notification sent to the topic.
//
// The following operation is related to PutBucketNotificationConfiguration:
//
//    * GetBucketNotificationConfiguration
//
//    // Example sending a request using PutBucketNotificationConfigurationRequest.
//    req := client.PutBucketNotificationConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *Client) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) PutBucketNotificationConfigurationRequest {
	op := &aws.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	req := c.newRequest(op, input, &PutBucketNotificationConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutBucketNotificationConfigurationRequest{Request: req, Input: input, Copy: c.PutBucketNotificationConfigurationRequest}
}

// PutBucketNotificationConfigurationRequest is the request type for the
// PutBucketNotificationConfiguration API operation.
type PutBucketNotificationConfigurationRequest struct {
	*aws.Request
	Input *PutBucketNotificationConfigurationInput
	Copy  func(*PutBucketNotificationConfigurationInput) PutBucketNotificationConfigurationRequest
}

// Send marshals and sends the PutBucketNotificationConfiguration API request.
func (r PutBucketNotificationConfigurationRequest) Send(ctx context.Context) (*PutBucketNotificationConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketNotificationConfigurationResponse{
		PutBucketNotificationConfigurationOutput: r.Request.Data.(*PutBucketNotificationConfigurationOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketNotificationConfigurationResponse is the response type for the
// PutBucketNotificationConfiguration API operation.
type PutBucketNotificationConfigurationResponse struct {
	*PutBucketNotificationConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketNotificationConfiguration request.
func (r *PutBucketNotificationConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
