// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies the days since the initiation of an incomplete multipart upload
// that Amazon S3 will wait before permanently removing all parts of the upload.
// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
// in the Amazon Simple Storage Service Developer Guide.
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after which Amazon S3 aborts an incomplete multipart
	// upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AbortIncompleteMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.DaysAfterInitiation != nil {
		v := *s.DaysAfterInitiation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DaysAfterInitiation", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Configures the transfer acceleration state for an Amazon S3 bucket. For more
// information, see Amazon S3 Transfer Acceleration (https://docs.aws.amazon.com/AmazonS3/latest/dev/transfer-acceleration.html)
// in the Amazon Simple Storage Service Developer Guide.
type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the transfer acceleration status of the bucket.
	Status BucketAccelerateStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccelerateConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Contains the elements that set the ACL permissions for an object per grantee.
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	// Container for the bucket owner's display name and ID.
	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grants != nil {
		v := s.Grants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// A container for information about access control for replicas.
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// Specifies the replica ownership. For default and valid values, see PUT bucket
	// replication (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html)
	// in the Amazon Simple Storage Service API Reference.
	//
	// Owner is a required field
	Owner OwnerOverride `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccessControlTranslation"}
	if len(s.Owner) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlTranslation) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Owner) > 0 {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", v, metadata)
	}
	return nil
}

// A conjunction (logical AND) of predicates, which is used in evaluating a
// metrics filter. The operator must have at least two predicates in any combination,
// and an object must match all of the predicates for the filter to apply.
type AnalyticsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix to use when evaluating an AND predicate: The prefix that an object
	// must have to be included in the metrics results.
	Prefix *string `type:"string"`

	// The list of tags to use when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s AnalyticsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the configuration and any analyses for the analytics filter of
// an Amazon S3 bucket.
type AnalyticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The filter used to describe a set of objects for analyses. A filter must
	// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
	// If no filter is provided, all objects will be considered in any analysis.
	Filter *AnalyticsFilter `type:"structure"`

	// The ID that identifies the analytics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Contains data related to access patterns to be collected and made available
	// to analyze the tradeoffs between different storage classes.
	//
	// StorageClassAnalysis is a required field
	StorageClassAnalysis *StorageClassAnalysis `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.StorageClassAnalysis == nil {
		invalidParams.Add(aws.NewErrParamRequired("StorageClassAnalysis"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.StorageClassAnalysis != nil {
		if err := s.StorageClassAnalysis.Validate(); err != nil {
			invalidParams.AddNested("StorageClassAnalysis", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.StorageClassAnalysis != nil {
		v := s.StorageClassAnalysis

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StorageClassAnalysis", v, metadata)
	}
	return nil
}

// Where to publish the analytics results.
type AnalyticsExportDestination struct {
	_ struct{} `type:"structure"`

	// A destination signifying output to an S3 bucket.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *AnalyticsS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsExportDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsExportDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsExportDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsExportDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// The filter used to describe a set of objects for analyses. A filter must
// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
// If no filter is provided, all objects will be considered in any analysis.
type AnalyticsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating an
	// analytics filter. The operator must have at least two predicates.
	And *AnalyticsAndOperator `type:"structure"`

	// The prefix to use when evaluating an analytics filter.
	Prefix *string `type:"string"`

	// The tag to use when evaluating an analytics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s AnalyticsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Contains information about where to publish the analytics results.
type AnalyticsS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the bucket to which data is exported.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The account ID that owns the destination S3 bucket. If no account ID is provided,
	// the owner is not validated before exporting data.
	//
	// Although this value is optional, we strongly recommend that you set it to
	// help prevent problems if the destination bucket ownership changes.
	BucketAccountId *string `type:"string"`

	// Specifies the file format used when exporting data to Amazon S3.
	//
	// Format is a required field
	Format AnalyticsS3ExportFileFormat `type:"string" required:"true" enum:"true"`

	// The prefix to use when exporting data. The prefix is prepended to all results.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AnalyticsS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *AnalyticsS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AnalyticsS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.BucketAccountId != nil {
		v := *s.BucketAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketAccountId", protocol.StringValue(v), metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// In terms of implementation, a Bucket is a resource. An Amazon S3 bucket name
// is globally unique, and the namespace is shared by all AWS accounts.
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bucket) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies the lifecycle configuration for objects in an Amazon S3 bucket.
// For more information, see Object Lifecycle Management (https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html)
// in the Amazon Simple Storage Service Developer Guide.
type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// A lifecycle rule for individual objects in an Amazon S3 bucket.
	//
	// Rules is a required field
	Rules []LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for logging status information.
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	// Describes where logs are stored and the prefix that Amazon S3 assigns to
	// all log object keys for a bucket. For more information, see PUT Bucket logging
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
	// in the Amazon Simple Storage Service API Reference.
	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLoggingStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.LoggingEnabled != nil {
		v := s.LoggingEnabled

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LoggingEnabled", v, metadata)
	}
	return nil
}

// Describes the cross-origin access configuration for objects in an Amazon
// S3 bucket. For more information, see Enabling Cross-Origin Resource Sharing
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html) in the Amazon
// Simple Storage Service Developer Guide.
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of origins and methods (cross-origin access that you want to allow).
	// You can add up to 100 rules to the configuration.
	//
	// CORSRules is a required field
	CORSRules []CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSConfiguration"}

	if s.CORSRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CORSRules != nil {
		v := s.CORSRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CORSRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies a cross-origin access rule for an Amazon S3 bucket.
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Headers that are specified in the Access-Control-Request-Headers header.
	// These headers are allowed in a preflight OPTIONS request. In response to
	// any preflight OPTIONS request, Amazon S3 returns any requested headers that
	// are allowed.
	AllowedHeaders []string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// An HTTP method that you allow the origin to execute. Valid values are GET,
	// PUT, HEAD, POST, and DELETE.
	//
	// AllowedMethods is a required field
	AllowedMethods []string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CORSRule"}

	if s.AllowedMethods == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedMethods"))
	}

	if s.AllowedOrigins == nil {
		invalidParams.Add(aws.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CORSRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowedHeaders != nil {
		v := s.AllowedHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.AllowedMethods != nil {
		v := s.AllowedMethods

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedMethod", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.AllowedOrigins != nil {
		v := s.AllowedOrigins

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "AllowedOrigin", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.ExposeHeaders != nil {
		v := s.ExposeHeaders

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "ExposeHeader", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.MaxAgeSeconds != nil {
		v := *s.MaxAgeSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxAgeSeconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Describes how an uncompressed comma-separated values (CSV)-formatted input
// object is formatted.
type CSVInput struct {
	_ struct{} `type:"structure"`

	// Specifies that CSV field values may contain quoted record delimiters and
	// such records should be allowed. Default value is FALSE. Setting this value
	// to TRUE may lower performance.
	AllowQuotedRecordDelimiter *bool `type:"boolean"`

	// A single character used to indicate that a row should be ignored when the
	// character is present at the start of that row. You can specify any character
	// to indicate a comment line.
	Comments *string `type:"string"`

	// A single character used to separate individual fields in a record. You can
	// specify an arbitrary delimiter.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values are:
	//
	//    * NONE: First line is not a header.
	//
	//    * IGNORE: First line is a header, but you can't use the header values
	//    to indicate the column in an expression. You can use column position (such
	//    as _1, _2, …) to indicate the column (SELECT s._1 FROM OBJECT s).
	//
	//    * Use: First line is a header, and you can use the header value to identify
	//    a column in an expression (SELECT "name" FROM OBJECT).
	FileHeaderInfo FileHeaderInfo `type:"string" enum:"true"`

	// A single character used for escaping when the field delimiter is part of
	// the value. For example, if the value is a, b, Amazon S3 wraps this field
	// value in quotation marks, as follows: " a , b ".
	//
	// Type: String
	//
	// Default: "
	//
	// Ancestors: CSV
	QuoteCharacter *string `type:"string"`

	// A single character used for escaping the quotation mark character inside
	// an already escaped value. For example, the value """ a , b """ is parsed
	// as " a , b ".
	QuoteEscapeCharacter *string `type:"string"`

	// A single character used to separate individual records in the input. Instead
	// of the default value, you can specify an arbitrary delimiter.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowQuotedRecordDelimiter != nil {
		v := *s.AllowQuotedRecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AllowQuotedRecordDelimiter", protocol.BoolValue(v), metadata)
	}
	if s.Comments != nil {
		v := *s.Comments

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comments", protocol.StringValue(v), metadata)
	}
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if len(s.FileHeaderInfo) > 0 {
		v := s.FileHeaderInfo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FileHeaderInfo", v, metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes how uncompressed comma-separated values (CSV)-formatted results
// are formatted.
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual fields in a record. You can specify
	// an arbitrary delimiter.
	FieldDelimiter *string `type:"string"`

	// A single character used for escaping when the field delimiter is part of
	// the value. For example, if the value is a, b, Amazon S3 wraps this field
	// value in quotation marks, as follows: " a , b ".
	QuoteCharacter *string `type:"string"`

	// The single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Indicates whether to use quotation marks around output fields.
	//
	//    * ALWAYS: Always use quotation marks for output fields.
	//
	//    * ASNEEDED: Use quotation marks for output fields when needed.
	QuoteFields QuoteFields `type:"string" enum:"true"`

	// A single character used to separate individual records in the output. Instead
	// of the default value, you can specify an arbitrary delimiter.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CSVOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FieldDelimiter != nil {
		v := *s.FieldDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FieldDelimiter", protocol.StringValue(v), metadata)
	}
	if s.QuoteCharacter != nil {
		v := *s.QuoteCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteCharacter", protocol.StringValue(v), metadata)
	}
	if s.QuoteEscapeCharacter != nil {
		v := *s.QuoteEscapeCharacter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteEscapeCharacter", protocol.StringValue(v), metadata)
	}
	if len(s.QuoteFields) > 0 {
		v := s.QuoteFields

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QuoteFields", v, metadata)
	}
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for specifying the AWS Lambda notification configuration.
type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	CloudFunction *string `type:"string"`

	// The bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	// Bucket events for which to send notifications.
	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The role supporting the invocation of the Lambda function
	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunction != nil {
		v := *s.CloudFunction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.InvocationRole != nil {
		v := *s.InvocationRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvocationRole", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for all (if there are any) keys between Prefix and the next occurrence
// of the string specified by a delimiter. CommonPrefixes lists keys that act
// like subdirectories in the directory specified by Prefix. For example, if
// the prefix is notes/ and the delimiter is a slash (/) as in notes/summer/july,
// the common prefix is notes/summer/.
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	// Container for the specified common prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CommonPrefix) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// The container for the completed multipart upload details.
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Array of CompletedPart data types.
	Parts []CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedMultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.Parts != nil {
		v := s.Parts

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Part", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details of the parts that were uploaded.
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompletedPart) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A container for describing a condition that must be met for the specified
// redirect to apply. For example, 1. If request is for pages in the /docs folder,
// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
// redirect request to another host where you might process the error.
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.HttpErrorCodeReturnedEquals != nil {
		v := *s.HttpErrorCodeReturnedEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpErrorCodeReturnedEquals", protocol.StringValue(v), metadata)
	}
	if s.KeyPrefixEquals != nil {
		v := *s.KeyPrefixEquals

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyPrefixEquals", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for all response elements.
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	// Returns the ETag of the new object. The ETag reflects only changes to the
	// contents of an object, not its metadata. The source and destination ETag
	// is identical for a successfully copied object.
	ETag *string `type:"string"`

	// Returns the date that the object was last modified.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyObjectResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

// Container for all response elements.
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CopyPartResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	return nil
}

// The configuration information for the bucket.
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the Region where the bucket will be created. If you don't specify
	// a Region, the bucket is created in the US East (N. Virginia) Region (us-east-1).
	LocationConstraint BucketLocationConstraint `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateBucketConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LocationConstraint) > 0 {
		v := s.LocationConstraint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationConstraint", v, metadata)
	}
	return nil
}

// The container element for specifying the default Object Lock retention settings
// for new objects placed in the specified bucket.
type DefaultRetention struct {
	_ struct{} `type:"structure"`

	// The number of days that you want to specify for the default retention period.
	Days *int64 `type:"integer"`

	// The default Object Lock retention mode you want to apply to new objects placed
	// in the specified bucket.
	Mode ObjectLockRetentionMode `type:"string" enum:"true"`

	// The number of years that you want to specify for the default retention period.
	Years *int64 `type:"integer"`
}

// String returns the string representation
func (s DefaultRetention) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultRetention) MarshalFields(e protocol.FieldEncoder) error {
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", v, metadata)
	}
	if s.Years != nil {
		v := *s.Years

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Years", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for the objects to delete.
type Delete struct {
	_ struct{} `type:"structure"`

	// The objects to delete.
	//
	// Objects is a required field
	Objects []ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Delete"}

	if s.Objects == nil {
		invalidParams.Add(aws.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Delete) MarshalFields(e protocol.FieldEncoder) error {
	if s.Objects != nil {
		v := s.Objects

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Object", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Quiet != nil {
		v := *s.Quiet

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Quiet", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information about the delete marker.
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp"`

	// The account that created the delete marker.>
	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies whether Amazon S3 replicates the delete markers. If you specify
// a Filter, you must specify this element. However, in the latest version of
// replication configuration (when Filter is specified), Amazon S3 doesn't replicate
// delete markers. Therefore, the DeleteMarkerReplication element can contain
// only <Status>Disabled</Status>. For an example configuration, see Basic Rule
// Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
//
// If you don't specify the Filter element, Amazon S3 assumes that the replication
// configuration is the earlier version, V1. In the earlier version, Amazon
// S3 handled replication of delete markers differently. For more information,
// see Backward Compatibility (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
type DeleteMarkerReplication struct {
	_ struct{} `type:"structure"`

	// Indicates whether to replicate delete markers.
	//
	// In the current implementation, Amazon S3 doesn't replicate the delete markers.
	// The status must be Disabled.
	Status DeleteMarkerReplicationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeleteMarkerReplication) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteMarkerReplication) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Information about the deleted object.
type DeletedObject struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker. In a simple DELETE, this header indicates
	// whether (true) or not (false) a delete marker was created.
	DeleteMarker *bool `type:"boolean"`

	// The version ID of the delete marker created as a result of the DELETE operation.
	// If you delete a specific object version, the value returned by this header
	// is the version ID of the object version deleted.
	DeleteMarkerVersionId *string `type:"string"`

	// The name of the deleted object.
	Key *string `min:"1" type:"string"`

	// The version ID of the deleted object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletedObject) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarker != nil {
		v := *s.DeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarker", protocol.BoolValue(v), metadata)
	}
	if s.DeleteMarkerVersionId != nil {
		v := *s.DeleteMarkerVersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteMarkerVersionId", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies information about where to publish analysis or configuration results
// for an Amazon S3 bucket and S3 Replication Time Control (S3 RTC).
type Destination struct {
	_ struct{} `type:"structure"`

	// Specify this only in a cross-account scenario (where source and destination
	// bucket owners are not the same), and you want to change replica ownership
	// to the AWS account that owns the destination bucket. If this is not specified
	// in the replication configuration, the replicas are owned by same AWS account
	// that owns the source object.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// Destination bucket owner account ID. In a cross-account scenario, if you
	// direct Amazon S3 to change replica ownership to the AWS account that owns
	// the destination bucket by specifying the AccessControlTranslation property,
	// this is the account ID of the destination bucket owner. For more information,
	// see Replication Additional Configuration: Changing the Replica Owner (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-change-owner.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Account *string `type:"string"`

	// The Amazon Resource Name (ARN) of the bucket where you want Amazon S3 to
	// store the results.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// A container that provides information about encryption. If SourceSelectionCriteria
	// is specified, you must specify this element.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A container specifying replication metrics-related settings enabling metrics
	// and Amazon S3 events for S3 Replication Time Control (S3 RTC). Must be specified
	// together with a ReplicationTime block.
	Metrics *Metrics `type:"structure"`

	// A container specifying S3 Replication Time Control (S3 RTC), including whether
	// S3 RTC is enabled and the time when all objects and operations on objects
	// must be replicated. Must be specified together with a Metrics block.
	ReplicationTime *ReplicationTime `type:"structure"`

	// The storage class to use when replicating objects, such as S3 Standard or
	// reduced redundancy. By default, Amazon S3 uses the storage class of the source
	// object to create the object replica.
	//
	// For valid values, see the StorageClass element of the PUT Bucket replication
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTreplication.html)
	// action in the Amazon Simple Storage Service API Reference.
	StorageClass StorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Destination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(aws.ErrInvalidParams))
		}
	}
	if s.Metrics != nil {
		if err := s.Metrics.Validate(); err != nil {
			invalidParams.AddNested("Metrics", err.(aws.ErrInvalidParams))
		}
	}
	if s.ReplicationTime != nil {
		if err := s.ReplicationTime.Validate(); err != nil {
			invalidParams.AddNested("ReplicationTime", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *Destination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlTranslation != nil {
		v := s.AccessControlTranslation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AccessControlTranslation", v, metadata)
	}
	if s.Account != nil {
		v := *s.Account

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Account", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.EncryptionConfiguration != nil {
		v := s.EncryptionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionConfiguration", v, metadata)
	}
	if s.Metrics != nil {
		v := s.Metrics

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metrics", v, metadata)
	}
	if s.ReplicationTime != nil {
		v := s.ReplicationTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ReplicationTime", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Contains the type of server-side encryption used.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3 (for example, AES256, aws:kms).
	//
	// EncryptionType is a required field
	EncryptionType ServerSideEncryption `type:"string" required:"true" enum:"true"`

	// If the encryption type is aws:kms, this optional value can be used to specify
	// the encryption context for the restore results.
	KMSContext *string `type:"string"`

	// If the encryption type is aws:kms, this optional value specifies the ID of
	// the symmetric customer managed AWS KMS CMK to use for encryption of job results.
	// Amazon S3 only supports symmetric CMKs. For more information, see Using Symmetric
	// and Asymmetric Keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the AWS Key Management Service Developer Guide.
	KMSKeyId *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Encryption"}
	if len(s.EncryptionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Encryption) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncryptionType) > 0 {
		v := s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionType", v, metadata)
	}
	if s.KMSContext != nil {
		v := *s.KMSContext

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSContext", protocol.StringValue(v), metadata)
	}
	if s.KMSKeyId != nil {
		v := *s.KMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSKeyId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies encryption-related information for an Amazon S3 bucket that is
// a destination for replicated objects.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the ID (Key ARN or Alias ARN) of the customer managed customer
	// master key (CMK) stored in AWS Key Management Service (KMS) for the destination
	// bucket. Amazon S3 uses this key to encrypt replica objects. Amazon S3 only
	// supports symmetric customer managed CMKs. For more information, see Using
	// Symmetric and Asymmetric Keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the AWS Key Management Service Developer Guide.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ReplicaKmsKeyID != nil {
		v := *s.ReplicaKmsKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicaKmsKeyID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for all error elements.
type Error struct {
	_ struct{} `type:"structure"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// Amazon S3 error codes
	//
	//    * Code: AccessDenied Description: Access Denied HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AccountProblem Description: There is a problem with your AWS account
	//    that prevents the operation from completing successfully. Contact AWS
	//    Support for further assistance. HTTP Status Code: 403 Forbidden SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: AllAccessDisabled Description: All access to this Amazon S3 resource
	//    has been disabled. Contact AWS Support for further assistance. HTTP Status
	//    Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: AmbiguousGrantByEmailAddress Description: The email address you
	//    provided is associated with more than one account. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: AuthorizationHeaderMalformed Description: The authorization header
	//    you provided is invalid. HTTP Status Code: 400 Bad Request HTTP Status
	//    Code: N/A
	//
	//    * Code: BadDigest Description: The Content-MD5 you specified did not match
	//    what we received. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: BucketAlreadyExists Description: The requested bucket name is
	//    not available. The bucket namespace is shared by all users of the system.
	//    Please select a different name and try again. HTTP Status Code: 409 Conflict
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketAlreadyOwnedByYou Description: The bucket you tried to create
	//    already exists, and you own it. Amazon S3 returns this error in all AWS
	//    Regions except in the North Virginia Region. For legacy compatibility,
	//    if you re-create an existing bucket that you already own in the North
	//    Virginia Region, Amazon S3 returns 200 OK and resets the bucket access
	//    control lists (ACLs). Code: 409 Conflict (in all Regions except the North
	//    Virginia Region) SOAP Fault Code Prefix: Client
	//
	//    * Code: BucketNotEmpty Description: The bucket you tried to delete is
	//    not empty. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: CredentialsNotSupported Description: This request does not support
	//    credentials. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: CrossLocationLoggingProhibited Description: Cross-location logging
	//    not allowed. Buckets in one geographic location cannot log information
	//    to a bucket in another location. HTTP Status Code: 403 Forbidden SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooSmall Description: Your proposed upload is smaller than
	//    the minimum allowed object size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: EntityTooLarge Description: Your proposed upload exceeds the maximum
	//    allowed object size. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: ExpiredToken Description: The provided token has expired. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IllegalVersioningConfigurationException Description: Indicates
	//    that the versioning configuration specified in the request is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncompleteBody Description: You did not provide the number of
	//    bytes specified by the Content-Length HTTP header HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: IncorrectNumberOfFilesInPostRequest Description: POST requires
	//    exactly one file upload per request. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: InlineDataTooLarge Description: Inline data exceeds the maximum
	//    allowed size. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InternalError Description: We encountered an internal error. Please
	//    try again. HTTP Status Code: 500 Internal Server Error SOAP Fault Code
	//    Prefix: Server
	//
	//    * Code: InvalidAccessKeyId Description: The AWS access key ID you provided
	//    does not exist in our records. HTTP Status Code: 403 Forbidden SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidAddressingHeader Description: You must specify the Anonymous
	//    role. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidArgument Description: Invalid Argument HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketName Description: The specified bucket is not valid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidBucketState Description: The request is not valid with
	//    the current state of the bucket. HTTP Status Code: 409 Conflict SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: InvalidDigest Description: The Content-MD5 you specified is not
	//    valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidEncryptionAlgorithmError Description: The encryption request
	//    you specified is not valid. The valid value is AES256. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidLocationConstraint Description: The specified location
	//    constraint is not valid. For more information about Regions, see How to
	//    Select a Region for Your Buckets (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro).
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidObjectState Description: The operation is not valid for
	//    the current state of the object. HTTP Status Code: 403 Forbidden SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: InvalidPart Description: One or more of the specified parts could
	//    not be found. The part might not have been uploaded, or the specified
	//    entity tag might not have matched the part's entity tag. HTTP Status Code:
	//    400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPartOrder Description: The list of parts was not in ascending
	//    order. Parts list must be specified in order by part number. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPayer Description: All access to this object has been disabled.
	//    Please contact AWS Support for further assistance. HTTP Status Code: 403
	//    Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidPolicyDocument Description: The content of the form does
	//    not meet the conditions specified in the policy document. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidRange Description: The requested range cannot be satisfied.
	//    HTTP Status Code: 416 Requested Range Not Satisfiable SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: InvalidRequest Description: Please use AWS4-HMAC-SHA256. HTTP
	//    Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: SOAP requests must be made over an
	//    HTTPS connection. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with non-DNS compliant names. HTTP Status Code:
	//    400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported for buckets with periods (.) in their names. HTTP Status
	//    Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate endpoint
	//    only supports virtual style requests. HTTP Status Code: 400 Bad Request
	//    Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is not
	//    configured on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Accelerate is disabled
	//    on this bucket. HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration is
	//    not supported on this bucket. Contact AWS Support for more information.
	//    HTTP Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidRequest Description: Amazon S3 Transfer Acceleration cannot
	//    be enabled on this bucket. Contact AWS Support for more information. HTTP
	//    Status Code: 400 Bad Request Code: N/A
	//
	//    * Code: InvalidSecurity Description: The provided security credentials
	//    are not valid. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidSOAPRequest Description: The SOAP request body is invalid.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidStorageClass Description: The storage class you specified
	//    is not valid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: InvalidTargetBucketForLogging Description: The target bucket for
	//    logging does not exist, is not owned by you, or does not have the appropriate
	//    grants for the log-delivery group. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: InvalidToken Description: The provided token is malformed or otherwise
	//    invalid. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: InvalidURI Description: Couldn't parse the specified URI. HTTP
	//    Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: KeyTooLongError Description: Your key is too long. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedACLError Description: The XML you provided was not well-formed
	//    or did not validate against our published schema. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedPOSTRequest Description: The body of your POST request
	//    is not well-formed multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: MalformedXML Description: This happens when the user sends malformed
	//    XML (XML that doesn't conform to the published XSD) for the configuration.
	//    The error message is, "The XML you provided was not well-formed or did
	//    not validate against our published schema." HTTP Status Code: 400 Bad
	//    Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxMessageLengthExceeded Description: Your request was too big.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MaxPostPreDataLengthExceededError Description: Your POST request
	//    fields preceding the upload file were too large. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: MetadataTooLarge Description: Your metadata headers exceed the
	//    maximum allowed metadata size. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: MethodNotAllowed Description: The specified method is not allowed
	//    against this resource. HTTP Status Code: 405 Method Not Allowed SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: MissingAttachment Description: A SOAP attachment was expected,
	//    but none were found. HTTP Status Code: N/A SOAP Fault Code Prefix: Client
	//
	//    * Code: MissingContentLength Description: You must provide the Content-Length
	//    HTTP header. HTTP Status Code: 411 Length Required SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingRequestBodyError Description: This happens when the user
	//    sends an empty XML document as a request. The error message is, "Request
	//    body is empty." HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: MissingSecurityElement Description: The SOAP 1.1 request is missing
	//    a security element. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: MissingSecurityHeader Description: Your request is missing a required
	//    header. HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: NoLoggingStatusForKey Description: There is no such thing as a
	//    logging status subresource for a key. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucket Description: The specified bucket does not exist.
	//    HTTP Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchBucketPolicy Description: The specified bucket does not
	//    have a bucket policy. HTTP Status Code: 404 Not Found SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: NoSuchKey Description: The specified key does not exist. HTTP
	//    Status Code: 404 Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NoSuchLifecycleConfiguration Description: The lifecycle configuration
	//    does not exist. HTTP Status Code: 404 Not Found SOAP Fault Code Prefix:
	//    Client
	//
	//    * Code: NoSuchUpload Description: The specified multipart upload does
	//    not exist. The upload ID might be invalid, or the multipart upload might
	//    have been aborted or completed. HTTP Status Code: 404 Not Found SOAP Fault
	//    Code Prefix: Client
	//
	//    * Code: NoSuchVersion Description: Indicates that the version ID specified
	//    in the request does not match an existing version. HTTP Status Code: 404
	//    Not Found SOAP Fault Code Prefix: Client
	//
	//    * Code: NotImplemented Description: A header you provided implies functionality
	//    that is not implemented. HTTP Status Code: 501 Not Implemented SOAP Fault
	//    Code Prefix: Server
	//
	//    * Code: NotSignedUp Description: Your account is not signed up for the
	//    Amazon S3 service. You must sign up before you can use Amazon S3. You
	//    can sign up at the following URL: https://aws.amazon.com/s3 HTTP Status
	//    Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: OperationAborted Description: A conflicting conditional operation
	//    is currently in progress against this resource. Try again. HTTP Status
	//    Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: PermanentRedirect Description: The bucket you are attempting to
	//    access must be addressed using the specified endpoint. Send all future
	//    requests to this endpoint. HTTP Status Code: 301 Moved Permanently SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: PreconditionFailed Description: At least one of the preconditions
	//    you specified did not hold. HTTP Status Code: 412 Precondition Failed
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: Redirect Description: Temporary redirect. HTTP Status Code: 307
	//    Moved Temporarily SOAP Fault Code Prefix: Client
	//
	//    * Code: RestoreAlreadyInProgress Description: Object restore is already
	//    in progress. HTTP Status Code: 409 Conflict SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestIsNotMultiPartContent Description: Bucket POST must be
	//    of the enclosure-type multipart/form-data. HTTP Status Code: 400 Bad Request
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeout Description: Your socket connection to the server
	//    was not read from or written to within the timeout period. HTTP Status
	//    Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTimeTooSkewed Description: The difference between the request
	//    time and the server's time is too large. HTTP Status Code: 403 Forbidden
	//    SOAP Fault Code Prefix: Client
	//
	//    * Code: RequestTorrentOfBucketError Description: Requesting the torrent
	//    file of a bucket is not permitted. HTTP Status Code: 400 Bad Request SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: SignatureDoesNotMatch Description: The request signature we calculated
	//    does not match the signature you provided. Check your AWS secret access
	//    key and signing method. For more information, see REST Authentication
	//    (https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html)
	//    and SOAP Authentication (https://docs.aws.amazon.com/AmazonS3/latest/dev/SOAPAuthentication.html)
	//    for details. HTTP Status Code: 403 Forbidden SOAP Fault Code Prefix: Client
	//
	//    * Code: ServiceUnavailable Description: Reduce your request rate. HTTP
	//    Status Code: 503 Service Unavailable SOAP Fault Code Prefix: Server
	//
	//    * Code: SlowDown Description: Reduce your request rate. HTTP Status Code:
	//    503 Slow Down SOAP Fault Code Prefix: Server
	//
	//    * Code: TemporaryRedirect Description: You are being redirected to the
	//    bucket while DNS updates. HTTP Status Code: 307 Moved Temporarily SOAP
	//    Fault Code Prefix: Client
	//
	//    * Code: TokenRefreshRequired Description: The provided token must be refreshed.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: TooManyBuckets Description: You have attempted to create more
	//    buckets than allowed. HTTP Status Code: 400 Bad Request SOAP Fault Code
	//    Prefix: Client
	//
	//    * Code: UnexpectedContent Description: This request does not support content.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UnresolvableGrantByEmailAddress Description: The email address
	//    you provided does not match any account on record. HTTP Status Code: 400
	//    Bad Request SOAP Fault Code Prefix: Client
	//
	//    * Code: UserKeyMustBeSpecified Description: The bucket POST must contain
	//    the specified field name. If it is specified, check the order of the fields.
	//    HTTP Status Code: 400 Bad Request SOAP Fault Code Prefix: Client
	Code *string `type:"string"`

	// The error key.
	Key *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message *string `type:"string"`

	// The version ID of the error.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Error) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// The error information.
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ErrorDocument"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	return nil
}

// Optional configuration to replicate existing source bucket objects. For more
// information, see Replicating Existing Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication)
// in the Amazon S3 Developer Guide.
type ExistingObjectReplication struct {
	_ struct{} `type:"structure"`

	// Status is a required field
	Status ExistingObjectReplicationStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ExistingObjectReplication) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExistingObjectReplication) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExistingObjectReplication"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExistingObjectReplication) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies the Amazon S3 object key name to filter on and whether to filter
// on the suffix or prefix of the key name.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// The object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. The maximum length is 1,024 characters. Overlapping
	// prefixes and suffixes are not supported. For more information, see Configuring
	// Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Name FilterRuleName `type:"string" enum:"true"`

	// The value that the filter searches for in object key names.
	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FilterRule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for S3 Glacier job parameters.
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// S3 Glacier retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier Tier `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlacierJobParameters"}
	if len(s.Tier) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlacierJobParameters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	return nil
}

// Container for grant information.
type Grant struct {
	_ struct{} `type:"structure"`

	// The person being granted permissions.
	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission Permission `type:"string" enum:"true"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// Container for the person being granted permissions.
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	//
	// Using email addresses to specify a grantee is only supported in the following
	// AWS Regions:
	//
	//    * US East (N. Virginia)
	//
	//    * US West (N. California)
	//
	//    * US West (Oregon)
	//
	//    * Asia Pacific (Singapore)
	//
	//    * Asia Pacific (Sydney)
	//
	//    * Asia Pacific (Tokyo)
	//
	//    * Europe (Ireland)
	//
	//    * South America (São Paulo)
	//
	// For a list of all the Amazon S3 supported Regions and endpoints, see Regions
	// and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the AWS General Reference.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type Type `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"true"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Grantee"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Grantee) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	// Skipping Type XML Attribute.
	if s.URI != nil {
		v := *s.URI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "URI", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for the Suffix element.
type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (for example,if the suffix is index.html and you make a request
	// to samplebucket/images/ the data that is returned will be for the object
	// with the key name images/index.html) The suffix must not be empty and must
	// not include a slash character.
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IndexDocument"}

	if s.Suffix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IndexDocument) MarshalFields(e protocol.FieldEncoder) error {
	if s.Suffix != nil {
		v := *s.Suffix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Suffix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container element that identifies who initiated the multipart upload.
type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Initiator) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the serialization format of the object.
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	CSV *CSVInput `type:"structure"`

	// Specifies object's compression format. Valid values: NONE, GZIP, BZIP2. Default
	// Value: NONE.
	CompressionType CompressionType `type:"string" enum:"true"`

	// Specifies JSON as object's input serialization format.
	JSON *JSONInput `type:"structure"`

	// Specifies Parquet as object's input serialization format.
	Parquet *ParquetInput `type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if len(s.CompressionType) > 0 {
		v := s.CompressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompressionType", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	if s.Parquet != nil {
		v := s.Parquet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Parquet", v, metadata)
	}
	return nil
}

// Specifies the inventory configuration for an Amazon S3 bucket. For more information,
// see GET Bucket inventory (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html)
// in the Amazon Simple Storage Service API Reference.
type InventoryConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about where to publish the inventory results.
	//
	// Destination is a required field
	Destination *InventoryDestination `type:"structure" required:"true"`

	// Specifies an inventory filter. The inventory only includes objects that meet
	// the filter's criteria.
	Filter *InventoryFilter `type:"structure"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Object versions to include in the inventory list. If set to All, the list
	// includes all the object versions, which adds the version-related fields VersionId,
	// IsLatest, and DeleteMarker to the list. If set to Current, the list does
	// not contain these version-related fields.
	//
	// IncludedObjectVersions is a required field
	IncludedObjectVersions InventoryIncludedObjectVersions `type:"string" required:"true" enum:"true"`

	// Specifies whether the inventory is enabled or disabled. If set to True, an
	// inventory list is generated. If set to False, no inventory list is generated.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`

	// Contains the optional fields that are included in the inventory results.
	OptionalFields []InventoryOptionalField `locationNameList:"Field" type:"list"`

	// Specifies the schedule for generating inventory results.
	//
	// Schedule is a required field
	Schedule *InventorySchedule `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryConfiguration"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if len(s.IncludedObjectVersions) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("IncludedObjectVersions"))
	}

	if s.IsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("IsEnabled"))
	}

	if s.Schedule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schedule"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.IncludedObjectVersions) > 0 {
		v := s.IncludedObjectVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludedObjectVersions", v, metadata)
	}
	if s.IsEnabled != nil {
		v := *s.IsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.OptionalFields != nil {
		v := s.OptionalFields

		metadata := protocol.Metadata{ListLocationName: "Field"}
		ls0 := e.List(protocol.BodyTarget, "OptionalFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	return nil
}

// Specifies the inventory configuration for an Amazon S3 bucket.
type InventoryDestination struct {
	_ struct{} `type:"structure"`

	// Contains the bucket name, file format, bucket owner (optional), and prefix
	// (optional) where inventory results are published.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *InventoryS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryDestination"}

	if s.S3BucketDestination == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketDestination != nil {
		v := s.S3BucketDestination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3BucketDestination", v, metadata)
	}
	return nil
}

// Contains the type of server-side encryption used to encrypt the inventory
// results.
type InventoryEncryption struct {
	_ struct{} `type:"structure"`

	// Specifies the use of SSE-KMS to encrypt delivered inventory reports.
	SSEKMS *SSEKMS `locationName:"SSE-KMS" type:"structure"`

	// Specifies the use of SSE-S3 to encrypt delivered inventory reports.
	SSES3 *SSES3 `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s InventoryEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.SSEKMS != nil {
		v := s.SSEKMS

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-KMS", v, metadata)
	}
	if s.SSES3 != nil {
		v := s.SSES3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SSE-S3", v, metadata)
	}
	return nil
}

// Specifies an inventory filter. The inventory only includes objects that meet
// the filter's criteria.
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The prefix that an object must have to be included in the inventory results.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryFilter"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Contains the bucket name, file format, bucket owner (optional), and prefix
// (optional) where inventory results are published.
type InventoryS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the destination S3 bucket. If no account ID is provided,
	// the owner is not validated before exporting data.
	//
	// Although this value is optional, we strongly recommend that you set it to
	// help prevent problems if the destination bucket ownership changes.
	AccountId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the bucket where inventory results will
	// be published.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Contains the type of server-side encryption used to encrypt the inventory
	// results.
	Encryption *InventoryEncryption `type:"structure"`

	// Specifies the output format of the inventory results.
	//
	// Format is a required field
	Format InventoryFormat `type:"string" required:"true" enum:"true"`

	// The prefix that is prepended to all inventory results.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s InventoryS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryS3BucketDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventoryS3BucketDestination"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *InventoryS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventoryS3BucketDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.StringValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Format", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies the schedule for generating inventory results.
type InventorySchedule struct {
	_ struct{} `type:"structure"`

	// Specifies how frequently inventory results are produced.
	//
	// Frequency is a required field
	Frequency InventoryFrequency `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InventorySchedule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventorySchedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InventorySchedule"}
	if len(s.Frequency) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Frequency"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InventorySchedule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Frequency) > 0 {
		v := s.Frequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Frequency", v, metadata)
	}
	return nil
}

// Specifies JSON as object's input serialization format.
type JSONInput struct {
	_ struct{} `type:"structure"`

	// The type of JSON. Valid values: Document, Lines.
	Type JSONType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JSONInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONInput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Specifies JSON as request's output serialization format.
type JSONOutput struct {
	_ struct{} `type:"structure"`

	// The value used to separate individual records in the output. If no value
	// is specified, Amazon S3 uses a newline character ('\n').
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s JSONOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JSONOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RecordDelimiter != nil {
		v := *s.RecordDelimiter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordDelimiter", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for specifying the configuration for AWS Lambda notifications.
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket event for which to invoke the AWS Lambda function. For
	// more information, see Supported Event Types (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Specifies object key name filtering rules. For information about key name
	// filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the AWS Lambda function that Amazon S3
	// invokes when the specified event type occurs.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaFunctionConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.LambdaFunctionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaFunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LambdaFunctionArn != nil {
		v := *s.LambdaFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudFunction", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for lifecycle rules. You can add as many as 1000 rules.
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies lifecycle configuration rules for an Amazon S3 bucket.
	//
	// Rules is a required field
	Rules []Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for the expiration for the lifecycle of the object.
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired; if set to false
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.ExpiredObjectDeleteMarker != nil {
		v := *s.ExpiredObjectDeleteMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpiredObjectDeleteMarker", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A lifecycle rule for individual objects in an Amazon S3 bucket.
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an incomplete multipart upload
	// that Amazon S3 will wait before permanently removing all parts of the upload.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
	// in the Amazon Simple Storage Service Developer Guide.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	// Specifies the expiration for the lifecycle of the object in the form of date,
	// days and, whether the object has a delete marker.
	Expiration *LifecycleExpiration `type:"structure"`

	// The Filter is used to identify objects that a Lifecycle Rule applies to.
	// A Filter must have exactly one of Prefix, Tag, or And specified.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Specifies the transition rule for the lifecycle rule that describes when
	// noncurrent objects transition to a specific storage class. If your bucket
	// is versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to a specific
	// storage class at a set period in the object's lifetime.
	NoncurrentVersionTransitions []NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies. This is
	// No longer used; use Filter instead.
	Prefix *string `deprecated:"true" type:"string"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	// Specifies when an Amazon S3 object transitions to a specified storage class.
	Transitions []Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRule"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if s.NoncurrentVersionTransitions != nil {
		v := s.NoncurrentVersionTransitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "NoncurrentVersionTransition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Transitions != nil {
		v := s.Transitions

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Transition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
// more predicates. The Lifecycle Rule will apply to any object matching all
// of the predicates configured inside the And operator.
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The Filter is used to identify objects that a Lifecycle Rule applies to.
// A Filter must have exactly one of Prefix, Tag, or And specified.
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
	// more predicates. The Lifecycle Rule will apply to any object matching all
	// of the predicates configured inside the And operator.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// This tag must exist in the object's tag set in order for the rule to apply.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LifecycleRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Describes where logs are stored and the prefix that Amazon S3 assigns to
// all log object keys for a bucket. For more information, see PUT Bucket logging
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlogging.html)
// in the Amazon Simple Storage Service API Reference.
type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case, you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	//
	// TargetBucket is a required field
	TargetBucket *string `type:"string" required:"true"`

	// Container for granting information.
	TargetGrants []TargetGrant `locationNameList:"Grant" type:"list"`

	// A prefix for all log object keys. If you store log files from multiple Amazon
	// S3 buckets in a single bucket, you can use a prefix to distinguish which
	// log files came from which bucket.
	//
	// TargetPrefix is a required field
	TargetPrefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingEnabled"}

	if s.TargetBucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetBucket"))
	}

	if s.TargetPrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetPrefix"))
	}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingEnabled) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetBucket != nil {
		v := *s.TargetBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetBucket", protocol.StringValue(v), metadata)
	}
	if s.TargetGrants != nil {
		v := s.TargetGrants

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "TargetGrants", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TargetPrefix != nil {
		v := *s.TargetPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetPrefix", protocol.StringValue(v), metadata)
	}
	return nil
}

// A metadata key-value pair to store with an object.
type MetadataEntry struct {
	_ struct{} `type:"structure"`

	// Name of the Object.
	Name *string `type:"string"`

	// Value of the Object.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MetadataEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetadataEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container specifying replication metrics-related settings enabling metrics
// and Amazon S3 events for S3 Replication Time Control (S3 RTC). Must be specified
// together with a ReplicationTime block.
type Metrics struct {
	_ struct{} `type:"structure"`

	// A container specifying the time threshold for emitting the s3:Replication:OperationMissedThreshold
	// event.
	//
	// EventThreshold is a required field
	EventThreshold *ReplicationTimeValue `type:"structure" required:"true"`

	// Specifies whether the replication metrics are enabled.
	//
	// Status is a required field
	Status MetricsStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Metrics) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Metrics"}

	if s.EventThreshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventThreshold"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Metrics) MarshalFields(e protocol.FieldEncoder) error {
	if s.EventThreshold != nil {
		v := s.EventThreshold

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EventThreshold", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// A conjunction (logical AND) of predicates, which is used in evaluating a
// metrics filter. The operator must have at least two predicates, and an object
// must match all of the predicates in order for the filter to apply.
type MetricsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix used when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags used when evaluating an AND predicate.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s MetricsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies a metrics configuration for the CloudWatch request metrics (specified
// by the metrics configuration ID) from an Amazon S3 bucket. If you're updating
// an existing metrics configuration, note that this is a full replacement of
// the existing metrics configuration. If you don't include the elements you
// want to keep, they are erased. For more information, see PUT Bucket metrics
// (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTMetricConfiguration.html)
// in the Amazon Simple Storage Service API Reference.
type MetricsConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies a metrics configuration filter. The metrics configuration will
	// only include objects that meet the filter's criteria. A filter must be a
	// prefix, a tag, or a conjunction (MetricsAndOperator).
	Filter *MetricsFilter `type:"structure"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies a metrics configuration filter. The metrics configuration only
// includes objects that meet the filter's criteria. A filter must be a prefix,
// a tag, or a conjunction (MetricsAndOperator).
type MetricsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating a
	// metrics filter. The operator must have at least two predicates, and an object
	// must match all of the predicates in order for the filter to apply.
	And *MetricsAndOperator `type:"structure"`

	// The prefix used when evaluating a metrics filter.
	Prefix *string `type:"string"`

	// The tag used when evaluating a metrics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s MetricsFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MetricsFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// Container for the MultipartUpload for the Amazon S3 object.
type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Specifies the owner of the object that is part of the multipart upload.
	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass StorageClass `type:"string" enum:"true"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MultipartUpload) MarshalFields(e protocol.FieldEncoder) error {
	if s.Initiated != nil {
		v := *s.Initiated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Initiated",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Initiator != nil {
		v := s.Initiator

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Initiator", v, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UploadId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionExpiration) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER,
// or DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning
// is suspended), you can set this action to request that Amazon S3 transition
// noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING,
// GLACIER, or DEEP_ARCHIVE storage class at a specific period in the object's
// lifetime.
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates How Long an Object Has Been Noncurrent
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/intro-lifecycle-rules.html#non-current-days-calculations)
	// in the Amazon Simple Storage Service Developer Guide.
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoncurrentVersionTransition) MarshalFields(e protocol.FieldEncoder) error {
	if s.NoncurrentDays != nil {
		v := *s.NoncurrentDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NoncurrentDays", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// A container for specifying the notification configuration of the bucket.
// If this element is empty, notifications are turned off for the bucket.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the AWS Lambda functions to invoke and the events for which to
	// invoke them.
	LambdaFunctionConfigurations []LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	// The Amazon Simple Queue Service queues to publish messages to and the events
	// for which to publish messages.
	QueueConfigurations []QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	// The topic to which notifications are sent and the events for which notifications
	// are generated.
	TopicConfigurations []TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.LambdaFunctionConfigurations != nil {
		for i, v := range s.LambdaFunctionConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigurations != nil {
		for i, v := range s.QueueConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurations != nil {
		for i, v := range s.TopicConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.LambdaFunctionConfigurations != nil {
		v := s.LambdaFunctionConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "CloudFunctionConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.QueueConfigurations != nil {
		v := s.QueueConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "QueueConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TopicConfigurations != nil {
		v := s.TopicConfigurations

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "TopicConfiguration", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type NotificationConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Container for specifying the AWS Lambda notification configuration.
	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	// This data type is deprecated. This data type specifies the configuration
	// for publishing messages to an Amazon Simple Queue Service (Amazon SQS) queue
	// when Amazon S3 detects specified events.
	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	// This data type is deprecated. A container for specifying the configuration
	// for publication of messages to an Amazon Simple Notification Service (Amazon
	// SNS) topic when Amazon S3 detects specified events.
	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudFunctionConfiguration != nil {
		v := s.CloudFunctionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudFunctionConfiguration", v, metadata)
	}
	if s.QueueConfiguration != nil {
		v := s.QueueConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "QueueConfiguration", v, metadata)
	}
	if s.TopicConfiguration != nil {
		v := s.TopicConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TopicConfiguration", v, metadata)
	}
	return nil
}

// Specifies object key name filtering rules. For information about key name
// filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// in the Amazon Simple Storage Service Developer Guide.
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// A container for object key name prefix and suffix filtering rules.
	Key *S3KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NotificationConfigurationFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := s.Key

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3Key", v, metadata)
	}
	return nil
}

// An object consists of data and its descriptive metadata.
type Object struct {
	_ struct{} `type:"structure"`

	// The entity tag is an MD5 hash of the object. ETag reflects only changes to
	// the contents of an object, not its metadata.
	ETag *string `type:"string"`

	// The name that you assign to an object. You use the object key to retrieve
	// the object.
	Key *string `min:"1" type:"string"`

	// The date the Object was Last Modified
	LastModified *time.Time `type:"timestamp"`

	// The owner of the object
	Owner *Owner `type:"structure"`

	// Size in bytes of the object
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Object) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Object Identifier is unique value to identify objects.
type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ObjectIdentifier"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// The container element for Object Lock configuration parameters.
type ObjectLockConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether this bucket has an Object Lock configuration enabled.
	ObjectLockEnabled ObjectLockEnabled `type:"string" enum:"true"`

	// The Object Lock rule in place for the specified object.
	Rule *ObjectLockRule `type:"structure"`
}

// String returns the string representation
func (s ObjectLockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ObjectLockEnabled) > 0 {
		v := s.ObjectLockEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ObjectLockEnabled", v, metadata)
	}
	if s.Rule != nil {
		v := s.Rule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Rule", v, metadata)
	}
	return nil
}

// A Legal Hold configuration for an object.
type ObjectLockLegalHold struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified object has a Legal Hold in place.
	Status ObjectLockLegalHoldStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ObjectLockLegalHold) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockLegalHold) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// A Retention configuration for an object.
type ObjectLockRetention struct {
	_ struct{} `type:"structure"`

	// Indicates the Retention mode for the specified object.
	Mode ObjectLockRetentionMode `type:"string" enum:"true"`

	// The date on which this Object Lock Retention will expire.
	RetainUntilDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ObjectLockRetention) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockRetention) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Mode) > 0 {
		v := s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", v, metadata)
	}
	if s.RetainUntilDate != nil {
		v := *s.RetainUntilDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetainUntilDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	return nil
}

// The container element for an Object Lock rule.
type ObjectLockRule struct {
	_ struct{} `type:"structure"`

	// The default retention period that you want to apply to new objects placed
	// in the specified bucket.
	DefaultRetention *DefaultRetention `type:"structure"`
}

// String returns the string representation
func (s ObjectLockRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectLockRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultRetention != nil {
		v := s.DefaultRetention

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultRetention", v, metadata)
	}
	return nil
}

// The version of an object.
type ObjectVersion struct {
	_ struct{} `type:"structure"`

	// The entity tag is an MD5 hash of that version of the object.
	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp"`

	// Specifies the owner of the object.
	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass ObjectVersionStorageClass `type:"string" enum:"true"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ObjectVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.IsLatest != nil {
		v := *s.IsLatest

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsLatest", protocol.BoolValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Owner", v, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Describes the location where the restore job's output is stored.
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the restore request.
	S3 *S3Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3 != nil {
		v := s.S3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3", v, metadata)
	}
	return nil
}

// Describes how results of the Select job are serialized.
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded Select results.
	CSV *CSVOutput `type:"structure"`

	// Specifies JSON as request's output serialization format.
	JSON *JSONOutput `type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputSerialization) MarshalFields(e protocol.FieldEncoder) error {
	if s.CSV != nil {
		v := s.CSV

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CSV", v, metadata)
	}
	if s.JSON != nil {
		v := s.JSON

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "JSON", v, metadata)
	}
	return nil
}

// Container for the owner's display name and ID.
type Owner struct {
	_ struct{} `type:"structure"`

	// Container for the display name of the owner.
	DisplayName *string `type:"string"`

	// Container for the ID of the owner.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Owner) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.StringValue(v), metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for Parquet.
type ParquetInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ParquetInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParquetInput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Container for elements related to a part.
type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size in bytes of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Part) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.PartNumber != nil {
		v := *s.PartNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PartNumber", protocol.Int64Value(v), metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The container element for a bucket's policy status.
type PolicyStatus struct {
	_ struct{} `type:"structure"`

	// The policy status for this bucket. TRUE indicates that this bucket is public.
	// FALSE indicates that the bucket is not public.
	IsPublic *bool `locationName:"IsPublic" type:"boolean"`
}

// String returns the string representation
func (s PolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PolicyStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsPublic != nil {
		v := *s.IsPublic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsPublic", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The PublicAccessBlock configuration that you want to apply to this Amazon
// S3 bucket. You can enable the configuration options in any combination. For
// more information about when Amazon S3 considers a bucket or object public,
// see The Meaning of "Public" (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
// in the Amazon Simple Storage Service Developer Guide.
type PublicAccessBlockConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 should block public access control lists (ACLs)
	// for this bucket and objects in this bucket. Setting this element to TRUE
	// causes the following behavior:
	//
	//    * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is
	//    public.
	//
	//    * PUT Object calls fail if the request includes a public ACL.
	//
	//    * PUT Bucket calls fail if the request includes a public ACL.
	//
	// Enabling this setting doesn't affect existing policies or ACLs.
	BlockPublicAcls *bool `locationName:"BlockPublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should block public bucket policies for this
	// bucket. Setting this element to TRUE causes Amazon S3 to reject calls to
	// PUT Bucket policy if the specified bucket policy allows public access.
	//
	// Enabling this setting doesn't affect existing bucket policies.
	BlockPublicPolicy *bool `locationName:"BlockPublicPolicy" type:"boolean"`

	// Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket. Setting this element to TRUE causes Amazon S3 to
	// ignore all public ACLs on this bucket and objects in this bucket.
	//
	// Enabling this setting doesn't affect the persistence of any existing ACLs
	// and doesn't prevent new public ACLs from being set.
	IgnorePublicAcls *bool `locationName:"IgnorePublicAcls" type:"boolean"`

	// Specifies whether Amazon S3 should restrict public bucket policies for this
	// bucket. Setting this element to TRUE restricts access to this bucket to only
	// AWS services and authorized users within this account if the bucket has a
	// public policy.
	//
	// Enabling this setting doesn't affect previously stored bucket policies, except
	// that public and cross-account access within any public bucket policy, including
	// non-public delegation to specific accounts, is blocked.
	RestrictPublicBuckets *bool `locationName:"RestrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s PublicAccessBlockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicAccessBlockConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAcls != nil {
		v := *s.BlockPublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.BlockPublicPolicy != nil {
		v := *s.BlockPublicPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BlockPublicPolicy", protocol.BoolValue(v), metadata)
	}
	if s.IgnorePublicAcls != nil {
		v := *s.IgnorePublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IgnorePublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.RestrictPublicBuckets != nil {
		v := *s.RestrictPublicBuckets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestrictPublicBuckets", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Specifies the configuration for publishing messages to an Amazon Simple Queue
// Service (Amazon SQS) queue when Amazon S3 detects specified events.
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	// A collection of bucket events for which to send notifications
	//
	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Specifies object key name filtering rules. For information about key name
	// filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3
	// publishes a message when it detects events of the specified type.
	//
	// QueueArn is a required field
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueueConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueueConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.QueueArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("QueueArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.QueueArn != nil {
		v := *s.QueueArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// This data type is deprecated. Use QueueConfiguration for the same purposes.
// This data type specifies the configuration for publishing messages to an
// Amazon Simple Queue Service (Amazon SQS) queue when Amazon S3 detects specified
// events.
type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// The bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	// A collection of bucket events for which to send notifications
	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SQS queue to which Amazon S3
	// publishes a message when it detects events of the specified type.
	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueueConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Queue != nil {
		v := *s.Queue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Queue", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies how requests are redirected. In the event of an error, you can
// specify a different error code to return.
type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use when redirecting requests. The default is the protocol that
	// is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the siblings is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Redirect) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if s.HttpRedirectCode != nil {
		v := *s.HttpRedirectCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HttpRedirectCode", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	if s.ReplaceKeyPrefixWith != nil {
		v := *s.ReplaceKeyPrefixWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyPrefixWith", protocol.StringValue(v), metadata)
	}
	if s.ReplaceKeyWith != nil {
		v := *s.ReplaceKeyWith

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplaceKeyWith", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies the redirect behavior of all requests to a website endpoint of
// an Amazon S3 bucket.
type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests are redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use when redirecting requests. The default is the protocol that
	// is used in the original request.
	Protocol Protocol `type:"string" enum:"true"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedirectAllRequestsTo"}

	if s.HostName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedirectAllRequestsTo) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostName != nil {
		v := *s.HostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostName", protocol.StringValue(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", v, metadata)
	}
	return nil
}

// A container for replication rules. You can add up to 1,000 rules. The maximum
// size of a replication configuration is 2 MB.
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that Amazon S3 assumes when replicating objects. For more information,
	// see How to Set Up Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-how-setup.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// A container for one or more replication rules. A replication configuration
	// must have at least one rule and can contain a maximum of 1,000 rules.
	//
	// Rules is a required field
	Rules []ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationConfiguration"}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.StringValue(v), metadata)
	}
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies which Amazon S3 objects to replicate and where to store the replicas.
type ReplicationRule struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 replicates the delete markers. If you specify
	// a Filter, you must specify this element. However, in the latest version of
	// replication configuration (when Filter is specified), Amazon S3 doesn't replicate
	// delete markers. Therefore, the DeleteMarkerReplication element can contain
	// only <Status>Disabled</Status>. For an example configuration, see Basic Rule
	// Configuration (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-config-min-rule-config).
	//
	// If you don't specify the Filter element, Amazon S3 assumes that the replication
	// configuration is the earlier version, V1. In the earlier version, Amazon
	// S3 handled replication of delete markers differently. For more information,
	// see Backward Compatibility (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-add-config.html#replication-backward-compat-considerations).
	DeleteMarkerReplication *DeleteMarkerReplication `type:"structure"`

	// A container for information about the replication destination and its configurations
	// including enabling the S3 Replication Time Control (S3 RTC).
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// Optional configuration to replicate existing source bucket objects. For more
	// information, see Replicating Existing Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication-what-is-isnot-replicated.html#existing-object-replication)
	// in the Amazon S3 Developer Guide.
	ExistingObjectReplication *ExistingObjectReplication `type:"structure"`

	// A filter that identifies the subset of objects to which the replication rule
	// applies. A Filter must specify exactly one Prefix, Tag, or an And child element.
	Filter *ReplicationRuleFilter `type:"structure"`

	// A unique identifier for the rule. The maximum value is 255 characters.
	ID *string `type:"string"`

	// An object key name prefix that identifies the object or objects to which
	// the rule applies. The maximum prefix length is 1,024 characters. To include
	// all objects in a bucket, specify an empty string.
	Prefix *string `deprecated:"true" type:"string"`

	// The priority associated with the rule. If you specify multiple rules in a
	// replication configuration, Amazon S3 prioritizes the rules to prevent conflicts
	// when filtering. If two or more rules identify the same object based on a
	// specified filter, the rule with higher priority takes precedence. For example:
	//
	//    * Same object quality prefix-based filter criteria if prefixes you specified
	//    in multiple rules overlap
	//
	//    * Same object qualify tag-based filter criteria specified in multiple
	//    rules
	//
	// For more information, see Replication (https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Priority *int64 `type:"integer"`

	// A container that describes additional filters for identifying the source
	// objects that you want to replicate. You can choose to enable or disable the
	// replication of these objects. Currently, Amazon S3 supports only the filter
	// that you can specify for objects created with server-side encryption using
	// a customer master key (CMK) stored in AWS Key Management Service (SSE-KMS).
	SourceSelectionCriteria *SourceSelectionCriteria `type:"structure"`

	// Specifies whether the rule is enabled.
	//
	// Status is a required field
	Status ReplicationRuleStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRule"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.ExistingObjectReplication != nil {
		if err := s.ExistingObjectReplication.Validate(); err != nil {
			invalidParams.AddNested("ExistingObjectReplication", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.SourceSelectionCriteria != nil {
		if err := s.SourceSelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SourceSelectionCriteria", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteMarkerReplication != nil {
		v := s.DeleteMarkerReplication

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeleteMarkerReplication", v, metadata)
	}
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.ExistingObjectReplication != nil {
		v := s.ExistingObjectReplication

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ExistingObjectReplication", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.SourceSelectionCriteria != nil {
		v := s.SourceSelectionCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SourceSelectionCriteria", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// A container for specifying rule filters. The filters determine the subset
// of objects to which the rule applies. This element is required only if you
// specify more than one filter.
//
// For example:
//
//    * If you specify both a Prefix and a Tag filter, wrap these filters in
//    an And tag.
//
//    * If you specify a filter based on multiple tags, wrap the Tag elements
//    in an And tag
type ReplicationRuleAndOperator struct {
	_ struct{} `type:"structure"`

	// An object key name prefix that identifies the subset of objects to which
	// the rule applies.
	Prefix *string `type:"string"`

	// An array of tags containing key and value pairs.
	Tags []Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ReplicationRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleAndOperator) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleAndOperator) MarshalFields(e protocol.FieldEncoder) error {
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Tag", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A filter that identifies the subset of objects to which the replication rule
// applies. A Filter must specify exactly one Prefix, Tag, or an And child element.
type ReplicationRuleFilter struct {
	_ struct{} `type:"structure"`

	// A container for specifying rule filters. The filters determine the subset
	// of objects to which the rule applies. This element is required only if you
	// specify more than one filter. For example:
	//
	//    * If you specify both a Prefix and a Tag filter, wrap these filters in
	//    an And tag.
	//
	//    * If you specify a filter based on multiple tags, wrap the Tag elements
	//    in an And tag.
	And *ReplicationRuleAndOperator `type:"structure"`

	// An object key name prefix that identifies the subset of objects to which
	// the rule applies.
	Prefix *string `type:"string"`

	// A container for specifying a tag key and value.
	//
	// The rule applies only to objects that have the tag in their tag set.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s ReplicationRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRuleFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationRuleFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.And != nil {
		v := s.And

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "And", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if s.Tag != nil {
		v := s.Tag

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tag", v, metadata)
	}
	return nil
}

// A container specifying S3 Replication Time Control (S3 RTC) related information,
// including whether S3 RTC is enabled and the time when all objects and operations
// on objects must be replicated. Must be specified together with a Metrics
// block.
type ReplicationTime struct {
	_ struct{} `type:"structure"`

	// Specifies whether the replication time is enabled.
	//
	// Status is a required field
	Status ReplicationTimeStatus `type:"string" required:"true" enum:"true"`

	// A container specifying the time by which replication should be complete for
	// all objects and operations on objects.
	//
	// Time is a required field
	Time *ReplicationTimeValue `type:"structure" required:"true"`
}

// String returns the string representation
func (s ReplicationTime) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationTime) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReplicationTime"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if s.Time == nil {
		invalidParams.Add(aws.NewErrParamRequired("Time"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationTime) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Time != nil {
		v := s.Time

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Time", v, metadata)
	}
	return nil
}

// A container specifying the time value for S3 Replication Time Control (S3
// RTC) and replication metrics EventThreshold.
type ReplicationTimeValue struct {
	_ struct{} `type:"structure"`

	// Contains an integer specifying time in minutes.
	//
	// Valid values: 15 minutes.
	Minutes *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTimeValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReplicationTimeValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Minutes != nil {
		v := *s.Minutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Minutes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for Payer.
type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	//
	// Payer is a required field
	Payer Payer `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPaymentConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RequestPaymentConfiguration"}
	if len(s.Payer) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Payer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RequestPaymentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Payer) > 0 {
		v := s.Payer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Payer", v, metadata)
	}
	return nil
}

// Container for restore job parameters.
type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days. Do not use with restores that specify
	// OutputLocation.
	Days *int64 `type:"integer"`

	// The optional description for the job.
	Description *string `type:"string"`

	// S3 Glacier related parameters pertaining to this job. Do not use with restores
	// that specify OutputLocation.
	GlacierJobParameters *GlacierJobParameters `type:"structure"`

	// Describes the location where the restore job's output is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// Describes the parameters for Select job types.
	SelectParameters *SelectParameters `type:"structure"`

	// S3 Glacier retrieval tier at which the restore will be processed.
	Tier Tier `type:"string" enum:"true"`

	// Type of restore request.
	Type RestoreRequestType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreRequest"}
	if s.GlacierJobParameters != nil {
		if err := s.GlacierJobParameters.Validate(); err != nil {
			invalidParams.AddNested("GlacierJobParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.SelectParameters != nil {
		if err := s.SelectParameters.Validate(); err != nil {
			invalidParams.AddNested("SelectParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.GlacierJobParameters != nil {
		v := s.GlacierJobParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GlacierJobParameters", v, metadata)
	}
	if s.OutputLocation != nil {
		v := s.OutputLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputLocation", v, metadata)
	}
	if s.SelectParameters != nil {
		v := s.SelectParameters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SelectParameters", v, metadata)
	}
	if len(s.Tier) > 0 {
		v := s.Tier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Tier", v, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// Specifies the redirect behavior and when a redirect is applied.
type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RoutingRule"}

	if s.Redirect == nil {
		invalidParams.Add(aws.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoutingRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := s.Condition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Condition", v, metadata)
	}
	if s.Redirect != nil {
		v := s.Redirect

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Redirect", v, metadata)
	}
	return nil
}

// Specifies lifecycle rules for an Amazon S3 bucket. For more information,
// see Put Bucket Lifecycle Configuration (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html)
// in the Amazon Simple Storage Service API Reference. For examples, see Put
// Bucket Lifecycle Configuration Examples (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLifecycleConfiguration.html#API_PutBucketLifecycleConfiguration_Examples)
type Rule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an incomplete multipart upload
	// that Amazon S3 will wait before permanently removing all parts of the upload.
	// For more information, see Aborting Incomplete Multipart Uploads Using a Bucket
	// Lifecycle Policy (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config)
	// in the Amazon Simple Storage Service Developer Guide.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	// Specifies the expiration for the lifecycle of the object.
	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value can't be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING, GLACIER,
	// or DEEP_ARCHIVE storage class. If your bucket is versioning-enabled (or versioning
	// is suspended), you can set this action to request that Amazon S3 transition
	// noncurrent object versions to the STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING,
	// GLACIER, or DEEP_ARCHIVE storage class at a specific period in the object's
	// lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Object key prefix that identifies one or more objects to which this rule
	// applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If Enabled, the rule is currently being applied. If Disabled, the rule is
	// not currently being applied.
	//
	// Status is a required field
	Status ExpirationStatus `type:"string" required:"true" enum:"true"`

	// Specifies when an object transitions to a specified storage class. For more
	// information about Amazon S3 lifecycle configuration rules, see Transitioning
	// Objects Using Amazon S3 Lifecycle (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Rule"}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Rule) MarshalFields(e protocol.FieldEncoder) error {
	if s.AbortIncompleteMultipartUpload != nil {
		v := s.AbortIncompleteMultipartUpload

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AbortIncompleteMultipartUpload", v, metadata)
	}
	if s.Expiration != nil {
		v := s.Expiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Expiration", v, metadata)
	}
	if s.ID != nil {
		v := *s.ID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ID", protocol.StringValue(v), metadata)
	}
	if s.NoncurrentVersionExpiration != nil {
		v := s.NoncurrentVersionExpiration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionExpiration", v, metadata)
	}
	if s.NoncurrentVersionTransition != nil {
		v := s.NoncurrentVersionTransition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NoncurrentVersionTransition", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.Transition != nil {
		v := s.Transition

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Transition", v, metadata)
	}
	return nil
}

// A container for object key name prefix and suffix filtering rules.
type S3KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for the key-value pair that defines the criteria for
	// the filter rule.
	FilterRules []FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s S3KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3KeyFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.FilterRules != nil {
		v := s.FilterRules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "FilterRule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes an Amazon S3 location that will receive the results of the restore
// request.
type S3Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []Grant `locationNameList:"Grant" type:"list"`

	// The name of the bucket where the restore results will be placed.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The canned ACL to apply to the restore results.
	CannedACL ObjectCannedACL `type:"string" enum:"true"`

	// Contains the type of server-side encryption used.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the restore results for this request.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// The class of storage used to store the restore results.
	StorageClass StorageClass `type:"string" enum:"true"`

	// The tag-set that is applied to the restore results.
	Tagging *Tagging `type:"structure"`

	// A list of metadata to store with the restore results in S3.
	UserMetadata []MetadataEntry `locationNameList:"MetadataEntry" type:"list"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}

	if s.BucketName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketName"))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Location) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlList != nil {
		v := s.AccessControlList

		metadata := protocol.Metadata{ListLocationName: "Grant"}
		ls0 := e.List(protocol.BodyTarget, "AccessControlList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.BucketName != nil {
		v := *s.BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BucketName", protocol.StringValue(v), metadata)
	}
	if len(s.CannedACL) > 0 {
		v := s.CannedACL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CannedACL", v, metadata)
	}
	if s.Encryption != nil {
		v := s.Encryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Encryption", v, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.StringValue(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Tagging", v, metadata)
	}
	if s.UserMetadata != nil {
		v := s.UserMetadata

		metadata := protocol.Metadata{ListLocationName: "MetadataEntry"}
		ls0 := e.List(protocol.BodyTarget, "UserMetadata", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the use of SSE-KMS to encrypt delivered inventory reports.
type SSEKMS struct {
	_ struct{} `locationName:"SSE-KMS" type:"structure"`

	// Specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer
	// managed customer master key (CMK) to use for encrypting inventory reports.
	//
	// KeyId is a required field
	KeyId *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SSEKMS) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSEKMS) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SSEKMS"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSEKMS) MarshalFields(e protocol.FieldEncoder) error {
	e.SetFields(protocol.BodyTarget, "SSE-KMS", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.KeyId != nil {
			v := *s.KeyId

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "KeyId", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{})
	return nil
}

// Specifies the use of SSE-S3 to encrypt delivered inventory reports.
type SSES3 struct {
	_ struct{} `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s SSES3) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SSES3) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Describes the parameters for Select job types.
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to query the object.
	//
	// Expression is a required field
	Expression *string `type:"string" required:"true"`

	// The type of the provided expression (for example, SQL).
	//
	// ExpressionType is a required field
	ExpressionType ExpressionType `type:"string" required:"true" enum:"true"`

	// Describes the serialization format of the object.
	//
	// InputSerialization is a required field
	InputSerialization *InputSerialization `type:"structure" required:"true"`

	// Describes how the results of the Select job are serialized.
	//
	// OutputSerialization is a required field
	OutputSerialization *OutputSerialization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelectParameters"}

	if s.Expression == nil {
		invalidParams.Add(aws.NewErrParamRequired("Expression"))
	}
	if len(s.ExpressionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ExpressionType"))
	}

	if s.InputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputSerialization"))
	}

	if s.OutputSerialization == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputSerialization"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SelectParameters) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Expression", protocol.StringValue(v), metadata)
	}
	if len(s.ExpressionType) > 0 {
		v := s.ExpressionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExpressionType", v, metadata)
	}
	if s.InputSerialization != nil {
		v := s.InputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InputSerialization", v, metadata)
	}
	if s.OutputSerialization != nil {
		v := s.OutputSerialization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OutputSerialization", v, metadata)
	}
	return nil
}

// Describes the default server-side encryption to apply to new objects in the
// bucket. If a PUT Object request doesn't specify any server-side encryption,
// this default encryption will be applied. For more information, see PUT Bucket
// encryption (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTencryption.html)
// in the Amazon Simple Storage Service API Reference.
type ServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// AWS Key Management Service (KMS) customer master key ID to use for the default
	// encryption. This parameter is allowed if and only if SSEAlgorithm is set
	// to aws:kms.
	//
	// You can specify the key ID or the Amazon Resource Name (ARN) of the CMK.
	// However, if you are using encryption with cross-account operations, you must
	// use a fully qualified CMK ARN. For more information, see Using encryption
	// for cross-account operations (https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html#bucket-encryption-update-bucket-policy).
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// Amazon S3 only supports symmetric CMKs and not asymmetric CMKs. For more
	// information, see Using Symmetric and Asymmetric Keys (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the AWS Key Management Service Developer Guide.
	KMSMasterKeyID *string `type:"string" sensitive:"true"`

	// Server-side encryption algorithm to use for the default encryption.
	//
	// SSEAlgorithm is a required field
	SSEAlgorithm ServerSideEncryption `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionByDefault) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionByDefault"}
	if len(s.SSEAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SSEAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionByDefault) MarshalFields(e protocol.FieldEncoder) error {
	if s.KMSMasterKeyID != nil {
		v := *s.KMSMasterKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSMasterKeyID", protocol.StringValue(v), metadata)
	}
	if len(s.SSEAlgorithm) > 0 {
		v := s.SSEAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAlgorithm", v, metadata)
	}
	return nil
}

// Specifies the default server-side-encryption configuration.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Container for information about a particular server-side encryption configuration
	// rule.
	//
	// Rules is a required field
	Rules []ServerSideEncryptionRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Rule", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the default server-side encryption configuration.
type ServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Specifies the default server-side encryption to apply to new objects in the
	// bucket. If a PUT Object request doesn't specify any server-side encryption,
	// this default encryption will be applied.
	ApplyServerSideEncryptionByDefault *ServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s ServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerSideEncryptionRule"}
	if s.ApplyServerSideEncryptionByDefault != nil {
		if err := s.ApplyServerSideEncryptionByDefault.Validate(); err != nil {
			invalidParams.AddNested("ApplyServerSideEncryptionByDefault", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServerSideEncryptionRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplyServerSideEncryptionByDefault != nil {
		v := s.ApplyServerSideEncryptionByDefault

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ApplyServerSideEncryptionByDefault", v, metadata)
	}
	return nil
}

// A container that describes additional filters for identifying the source
// objects that you want to replicate. You can choose to enable or disable the
// replication of these objects. Currently, Amazon S3 supports only the filter
// that you can specify for objects created with server-side encryption using
// a customer master key (CMK) stored in AWS Key Management Service (SSE-KMS).
type SourceSelectionCriteria struct {
	_ struct{} `type:"structure"`

	// A container for filter information for the selection of Amazon S3 objects
	// encrypted with AWS KMS. If you include SourceSelectionCriteria in the replication
	// configuration, this element is required.
	SseKmsEncryptedObjects *SseKmsEncryptedObjects `type:"structure"`
}

// String returns the string representation
func (s SourceSelectionCriteria) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSelectionCriteria) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceSelectionCriteria"}
	if s.SseKmsEncryptedObjects != nil {
		if err := s.SseKmsEncryptedObjects.Validate(); err != nil {
			invalidParams.AddNested("SseKmsEncryptedObjects", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SourceSelectionCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.SseKmsEncryptedObjects != nil {
		v := s.SseKmsEncryptedObjects

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SseKmsEncryptedObjects", v, metadata)
	}
	return nil
}

// A container for filter information for the selection of S3 objects encrypted
// with AWS KMS.
type SseKmsEncryptedObjects struct {
	_ struct{} `type:"structure"`

	// Specifies whether Amazon S3 replicates objects created with server-side encryption
	// using a customer master key (CMK) stored in AWS Key Management Service.
	//
	// Status is a required field
	Status SseKmsEncryptedObjectsStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SseKmsEncryptedObjects) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseKmsEncryptedObjects) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SseKmsEncryptedObjects"}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SseKmsEncryptedObjects) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies data related to access patterns to be collected and made available
// to analyze the tradeoffs between different storage classes for an Amazon
// S3 bucket.
type StorageClassAnalysis struct {
	_ struct{} `type:"structure"`

	// Specifies how data related to the storage class analysis for an Amazon S3
	// bucket should be exported.
	DataExport *StorageClassAnalysisDataExport `type:"structure"`
}

// String returns the string representation
func (s StorageClassAnalysis) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysis) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysis"}
	if s.DataExport != nil {
		if err := s.DataExport.Validate(); err != nil {
			invalidParams.AddNested("DataExport", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysis) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataExport != nil {
		v := s.DataExport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataExport", v, metadata)
	}
	return nil
}

// Container for data related to the storage class analysis for an Amazon S3
// bucket for export.
type StorageClassAnalysisDataExport struct {
	_ struct{} `type:"structure"`

	// The place to store the data for an analysis.
	//
	// Destination is a required field
	Destination *AnalyticsExportDestination `type:"structure" required:"true"`

	// The version of the output schema to use when exporting data. Must be V_1.
	//
	// OutputSchemaVersion is a required field
	OutputSchemaVersion StorageClassAnalysisSchemaVersion `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StorageClassAnalysisDataExport) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysisDataExport) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageClassAnalysisDataExport"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if len(s.OutputSchemaVersion) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("OutputSchemaVersion"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StorageClassAnalysisDataExport) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if len(s.OutputSchemaVersion) > 0 {
		v := s.OutputSchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutputSchemaVersion", v, metadata)
	}
	return nil
}

// A container of a key value name pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Container for TagSet elements.
type Tagging struct {
	_ struct{} `type:"structure"`

	// A collection for a set of tags
	//
	// TagSet is a required field
	TagSet []Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tagging"}

	if s.TagSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tagging) MarshalFields(e protocol.FieldEncoder) error {
	if s.TagSet != nil {
		v := s.TagSet

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "TagSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container for granting information.
type TargetGrant struct {
	_ struct{} `type:"structure"`

	// Container for the person being granted permissions.
	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission BucketLogsPermission `type:"string" enum:"true"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TargetGrant) MarshalFields(e protocol.FieldEncoder) error {
	if s.Grantee != nil {
		v := s.Grantee
		attrs := make([]protocol.Attribute, 0, 1)

		if len(s.Grantee.Type) > 0 {

			v := s.Grantee.Type
			attrs = append(attrs, protocol.Attribute{Name: "xsi:type", Value: v, Meta: protocol.Metadata{}})
		}
		metadata := protocol.Metadata{Attributes: attrs, XMLNamespacePrefix: "xsi", XMLNamespaceURI: "http://www.w3.org/2001/XMLSchema-instance"}
		e.SetFields(protocol.BodyTarget, "Grantee", v, metadata)
	}
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", v, metadata)
	}
	return nil
}

// A container for specifying the configuration for publication of messages
// to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3
// detects specified events.
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket event about which to send notifications. For more information,
	// see Supported Event Types (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	//
	// Events is a required field
	Events []Event `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Specifies object key name filtering rules. For information about key name
	// filtering, see Configuring Event Notifications (https://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	// in the Amazon Simple Storage Service Developer Guide.
	Filter *NotificationConfigurationFilter `type:"structure"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which Amazon S3
	// publishes a message when it detects events of the specified type.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TopicConfiguration"}

	if s.Events == nil {
		invalidParams.Add(aws.NewErrParamRequired("Events"))
	}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filter", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.TopicArn != nil {
		v := *s.TopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// A container for specifying the configuration for publication of messages
// to an Amazon Simple Notification Service (Amazon SNS) topic when Amazon S3
// detects specified events. This data type is deprecated. Use TopicConfiguration
// instead.
type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event Event `deprecated:"true" type:"string" enum:"true"`

	// A collection of events related to objects
	Events []Event `locationName:"Event" type:"list" flattened:"true"`

	// An optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TopicConfigurationDeprecated) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Event) > 0 {
		v := s.Event

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Event", v, metadata)
	}
	if s.Events != nil {
		v := s.Events

		metadata := protocol.Metadata{Flatten: true}
		ls0 := e.List(protocol.BodyTarget, "Event", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Topic != nil {
		v := *s.Topic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Topic", protocol.StringValue(v), metadata)
	}
	return nil
}

// Specifies when an object transitions to a specified storage class. For more
// information about Amazon S3 lifecycle configuration rules, see Transitioning
// Objects Using Amazon S3 Lifecycle (https://docs.aws.amazon.com/AmazonS3/latest/dev/lifecycle-transition-general-considerations.html)
// in the Amazon Simple Storage Service Developer Guide.
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates when objects are transitioned to the specified storage class. The
	// date value must be in ISO 8601 format. The time is always midnight UTC.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the number of days after creation when objects are transitioned
	// to the specified storage class. The value must be a positive integer.
	Days *int64 `type:"integer"`

	// The storage class to which you want the object to transition.
	StorageClass TransitionStorageClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Transition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Date != nil {
		v := *s.Date

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Date",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: false}, metadata)
	}
	if s.Days != nil {
		v := *s.Days

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Days", protocol.Int64Value(v), metadata)
	}
	if len(s.StorageClass) > 0 {
		v := s.StorageClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageClass", v, metadata)
	}
	return nil
}

// Describes the versioning state of an Amazon S3 bucket. For more information,
// see PUT Bucket versioning (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTVersioningStatus.html)
// in the Amazon Simple Storage Service API Reference.
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete MFADelete `locationName:"MfaDelete" type:"string" enum:"true"`

	// The versioning state of the bucket.
	Status BucketVersioningStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersioningConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MFADelete) > 0 {
		v := s.MFADelete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MfaDelete", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	return nil
}

// Specifies website configuration parameters for an Amazon S3 bucket.
type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the error document for the website.
	ErrorDocument *ErrorDocument `type:"structure"`

	// The name of the index document for the website.
	IndexDocument *IndexDocument `type:"structure"`

	// The redirect behavior for every request to this bucket's website endpoint.
	//
	// If you specify this property, you can't specify any other property.
	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	// Rules that define when a redirect is applied and the redirect behavior.
	RoutingRules []RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(aws.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(aws.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebsiteConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorDocument != nil {
		v := s.ErrorDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ErrorDocument", v, metadata)
	}
	if s.IndexDocument != nil {
		v := s.IndexDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "IndexDocument", v, metadata)
	}
	if s.RedirectAllRequestsTo != nil {
		v := s.RedirectAllRequestsTo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RedirectAllRequestsTo", v, metadata)
	}
	if s.RoutingRules != nil {
		v := s.RoutingRules

		metadata := protocol.Metadata{ListLocationName: "RoutingRule"}
		ls0 := e.List(protocol.BodyTarget, "RoutingRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}
