// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	DataCaptureConfig *DataCaptureConfig `type:"structure"`

	// The name of the endpoint configuration. You specify this name in a CreateEndpoint
	// request.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to the ML compute
	// instance that hosts the endpoint.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// The KMS key policy must grant permission to the IAM role that you specify
	// in your CreateEndpoint, UpdateEndpoint requests. For more information, refer
	// to the AWS Key Management Service section Using Key Policies in AWS KMS (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a KmsKeyId when using an instance type with local
	// storage. If any of the models that you specify in the ProductionVariants
	// parameter use nitro-based instances with local storage, do not specify a
	// value for the KmsKeyId parameter. If you specify a value for KmsKeyId when
	// using any nitro-based instances with local storage, the call to CreateEndpointConfig
	// fails.
	//
	// For a list of instance types that support local instance storage, see Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
	//
	// For more information about local instance storage encryption, see SSD Instance
	// Store Volumes (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
	KmsKeyId *string `type:"string"`

	// An list of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []ProductionVariant `min:"1" type:"list" required:"true"`

	// A list of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEndpointConfigInput"}

	if s.EndpointConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointConfigName"))
	}

	if s.ProductionVariants == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductionVariants"))
	}
	if s.ProductionVariants != nil && len(s.ProductionVariants) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductionVariants", 1))
	}
	if s.DataCaptureConfig != nil {
		if err := s.DataCaptureConfig.Validate(); err != nil {
			invalidParams.AddNested("DataCaptureConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ProductionVariants != nil {
		for i, v := range s.ProductionVariants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductionVariants", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEndpointConfig = "CreateEndpointConfig"

// CreateEndpointConfigRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates an endpoint configuration that Amazon SageMaker hosting services
// uses to deploy models. In the configuration, you identify one or more models,
// created using the CreateModel API, to deploy and the resources that you want
// Amazon SageMaker to provision. Then you call the CreateEndpoint API.
//
// Use this API if you want to use Amazon SageMaker hosting services to deploy
// models into production.
//
// In the request, you define a ProductionVariant, for each model that you want
// to deploy. Each ProductionVariant parameter also describes the resources
// that you want Amazon SageMaker to provision. This includes the number and
// type of ML compute instances to deploy.
//
// If you are hosting multiple models, you also assign a VariantWeight to specify
// how much traffic you want to allocate to each model. For example, suppose
// that you want to host two models, A and B, and you assign traffic weight
// 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds
// of the traffic to Model A, and one-third to model B.
//
// For an example that calls this method when deploying a model to Amazon SageMaker
// hosting services, see Deploy the Model to Amazon SageMaker Hosting Services
// (AWS SDK for Python (Boto 3)). (https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto)
//
// When you call CreateEndpoint, a load call is made to DynamoDB to verify that
// your endpoint configuration exists. When you read data from a DynamoDB table
// supporting Eventually Consistent Reads (https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html),
// the response might not reflect the results of a recently completed write
// operation. The response might include some stale data. If the dependent entities
// are not yet in DynamoDB, this causes a validation error. If you repeat your
// read request after a short time, the response should return the latest data.
// So retry logic is recommended to handle these possible issues. We also recommend
// that customers call DescribeEndpointConfig before calling CreateEndpoint
// to minimize the potential impact of a DynamoDB eventually consistent read.
//
//    // Example sending a request using CreateEndpointConfigRequest.
//    req := client.CreateEndpointConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *Client) CreateEndpointConfigRequest(input *CreateEndpointConfigInput) CreateEndpointConfigRequest {
	op := &aws.Operation{
		Name:       opCreateEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointConfigInput{}
	}

	req := c.newRequest(op, input, &CreateEndpointConfigOutput{})

	return CreateEndpointConfigRequest{Request: req, Input: input, Copy: c.CreateEndpointConfigRequest}
}

// CreateEndpointConfigRequest is the request type for the
// CreateEndpointConfig API operation.
type CreateEndpointConfigRequest struct {
	*aws.Request
	Input *CreateEndpointConfigInput
	Copy  func(*CreateEndpointConfigInput) CreateEndpointConfigRequest
}

// Send marshals and sends the CreateEndpointConfig API request.
func (r CreateEndpointConfigRequest) Send(ctx context.Context) (*CreateEndpointConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEndpointConfigResponse{
		CreateEndpointConfigOutput: r.Request.Data.(*CreateEndpointConfigOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEndpointConfigResponse is the response type for the
// CreateEndpointConfig API operation.
type CreateEndpointConfigResponse struct {
	*CreateEndpointConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEndpointConfig request.
func (r *CreateEndpointConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
