// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The registry path of the Docker image that contains the training algorithm
	// and algorithm-specific metadata, including the input mode. For more information
	// about algorithms provided by Amazon SageMaker, see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	// For information about providing your own algorithms, see Using Your Own Algorithms
	// with Amazon SageMaker (https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// Configuration information for the debug hook parameters, collection configuration,
	// and storage paths.
	DebugHookConfig *DebugHookConfig `type:"structure"`

	// Configuration information for debugging rules.
	DebugRuleConfigurations []DebugRuleConfiguration `type:"list"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithm in distributed training. For more information,
	// see Protect Communications Between ML Compute Instances in a Distributed
	// Training Job (https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// To train models using managed spot training, choose True. Managed spot training
	// provides a fully managed and scalable infrastructure for training machine
	// learning models. this option is useful when training jobs can be interrupted
	// and when there is flexibility when the training job is run.
	//
	// The complete and intermediate results of jobs are stored in an Amazon S3
	// bucket, and can be used as a starting point to train models incrementally.
	// Amazon SageMaker provides metrics and logs in CloudWatch. They can be used
	// to see when managed spot training jobs are running, interrupted, resumed,
	// or completed.
	EnableManagedSpotTraining *bool `type:"boolean"`

	// Isolates the training container. No inbound or outbound network calls can
	// be made, except for calls between peers within a training cluster for distributed
	// training. If you enable network isolation for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// Algorithm-specific parameters that influence the quality of the model. You
	// set hyperparameters before you start the learning process. For a list of
	// hyperparameters for each training algorithm provided by Amazon SageMaker,
	// see Algorithms (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
	//
	// You can specify a maximum of 100 hyperparameters. Each hyperparameter is
	// a key-value pair. Each key and value is limited to 256 characters, as specified
	// by the Length Constraint.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects. Each channel is a named input source. InputDataConfig
	// describes the input data and its location.
	//
	// Algorithms can accept input data from one or more channels. For example,
	// an algorithm might have two channels of input data, training_data and validation_data.
	// The configuration for each channel provides the S3, EFS, or FSx location
	// where the input data is stored. It also provides information about the stored
	// data: the MIME type, compression method, and whether the data is wrapped
	// in RecordIO format.
	//
	// Depending on the input mode that the algorithm supports, Amazon SageMaker
	// either copies input data files from an S3 bucket to a local directory in
	// the Docker container, or makes it available as input streams. For example,
	// if you specify an EFS location, input data files will be made available as
	// input streams. They do not need to be downloaded.
	InputDataConfig []Channel `min:"1" type:"list"`

	// Specifies the path to the S3 location where you want to store model artifacts.
	// Amazon SageMaker creates subfolders for the artifacts.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// The resources, including the ML compute instances and ML storage volumes,
	// to use for model training.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use ML storage volumes for scratch space. If you want
	// Amazon SageMaker to use the ML storage volume to store the training data,
	// choose File as the TrainingInputMode in the algorithm specification. For
	// distributed training algorithms, specify an instance count greater than 1.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// During model training, Amazon SageMaker needs your permission to read input
	// data from an S3 bucket, download a Docker image that contains training code,
	// write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs,
	// and publish metrics to Amazon CloudWatch. You grant permissions for all of
	// these tasks to an IAM role. For more information, see Amazon SageMaker Roles
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
	//
	// To be able to pass this role to Amazon SageMaker, the caller of this API
	// must have the iam:PassRole permission.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies a limit to how long a model training job can run. When the job
	// reaches the time limit, Amazon SageMaker ends the training job. Use this
	// API to cap model training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// An array of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`

	// Configuration of storage locations for TensorBoard output.
	TensorBoardOutputConfig *TensorBoardOutputConfig `type:"structure"`

	// The name of the training job. The name must be unique within an AWS Region
	// in an AWS account.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// A VpcConfig object that specifies the VPC that you want your training job
	// to connect to. Control access to and from your training container by configuring
	// the VPC. For more information, see Protect Training Jobs by Using an Amazon
	// Virtual Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrainingJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTrainingJobInput"}

	if s.AlgorithmSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmSpecification"))
	}
	if s.InputDataConfig != nil && len(s.InputDataConfig) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputDataConfig", 1))
	}

	if s.OutputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputDataConfig"))
	}

	if s.ResourceConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfig"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.StoppingCondition == nil {
		invalidParams.Add(aws.NewErrParamRequired("StoppingCondition"))
	}

	if s.TrainingJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrainingJobName", 1))
	}
	if s.AlgorithmSpecification != nil {
		if err := s.AlgorithmSpecification.Validate(); err != nil {
			invalidParams.AddNested("AlgorithmSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.CheckpointConfig != nil {
		if err := s.CheckpointConfig.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DebugHookConfig != nil {
		if err := s.DebugHookConfig.Validate(); err != nil {
			invalidParams.AddNested("DebugHookConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.DebugRuleConfigurations != nil {
		for i, v := range s.DebugRuleConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DebugRuleConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ExperimentConfig != nil {
		if err := s.ExperimentConfig.Validate(); err != nil {
			invalidParams.AddNested("ExperimentConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputDataConfig != nil {
		for i, v := range s.InputDataConfig {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputDataConfig", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.StoppingCondition != nil {
		if err := s.StoppingCondition.Validate(); err != nil {
			invalidParams.AddNested("StoppingCondition", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TensorBoardOutputConfig != nil {
		if err := s.TensorBoardOutputConfig.Validate(); err != nil {
			invalidParams.AddNested("TensorBoardOutputConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTrainingJob = "CreateTrainingJob"

// CreateTrainingJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Starts a model training job. After training completes, Amazon SageMaker saves
// the resulting model artifacts to an Amazon S3 location that you specify.
//
// If you choose to host your model using Amazon SageMaker hosting services,
// you can use the resulting model artifacts as part of the model. You can also
// use the artifacts in a machine learning service other than Amazon SageMaker,
// provided that you know how to use them for inferences.
//
// In the request body, you provide the following:
//
//    * AlgorithmSpecification - Identifies the training algorithm to use.
//
//    * HyperParameters - Specify these algorithm-specific parameters to enable
//    the estimation of model parameters during training. Hyperparameters can
//    be tuned to optimize this learning process. For a list of hyperparameters
//    for each training algorithm provided by Amazon SageMaker, see Algorithms
//    (https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
//
//    * InputDataConfig - Describes the training dataset and the Amazon S3,
//    EFS, or FSx location where it is stored.
//
//    * OutputDataConfig - Identifies the Amazon S3 bucket where you want Amazon
//    SageMaker to save the results of model training.
//
//    * ResourceConfig - Identifies the resources, ML compute instances, and
//    ML storage volumes to deploy for model training. In distributed training,
//    you specify more than one instance.
//
//    * EnableManagedSpotTraining - Optimize the cost of training machine learning
//    models by up to 80% by using Amazon EC2 Spot instances. For more information,
//    see Managed Spot Training (https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html).
//
//    * RoleARN - The Amazon Resource Number (ARN) that Amazon SageMaker assumes
//    to perform tasks on your behalf during model training. You must grant
//    this role the necessary permissions so that Amazon SageMaker can successfully
//    complete model training.
//
//    * StoppingCondition - To help cap training costs, use MaxRuntimeInSeconds
//    to set a time limit for training. Use MaxWaitTimeInSeconds to specify
//    how long you are willing to wait for a managed spot training job to complete.
//
// For more information about Amazon SageMaker, see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
//
//    // Example sending a request using CreateTrainingJobRequest.
//    req := client.CreateTrainingJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob
func (c *Client) CreateTrainingJobRequest(input *CreateTrainingJobInput) CreateTrainingJobRequest {
	op := &aws.Operation{
		Name:       opCreateTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrainingJobInput{}
	}

	req := c.newRequest(op, input, &CreateTrainingJobOutput{})

	return CreateTrainingJobRequest{Request: req, Input: input, Copy: c.CreateTrainingJobRequest}
}

// CreateTrainingJobRequest is the request type for the
// CreateTrainingJob API operation.
type CreateTrainingJobRequest struct {
	*aws.Request
	Input *CreateTrainingJobInput
	Copy  func(*CreateTrainingJobInput) CreateTrainingJobRequest
}

// Send marshals and sends the CreateTrainingJob API request.
func (r CreateTrainingJobRequest) Send(ctx context.Context) (*CreateTrainingJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTrainingJobResponse{
		CreateTrainingJobOutput: r.Request.Data.(*CreateTrainingJobOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTrainingJobResponse is the response type for the
// CreateTrainingJob API operation.
type CreateTrainingJobResponse struct {
	*CreateTrainingJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTrainingJob request.
func (r *CreateTrainingJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
