// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateTrialInput struct {
	_ struct{} `type:"structure"`

	// The name of the trial as displayed. The name doesn't need to be unique. If
	// DisplayName isn't specified, TrialName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The name of the experiment to associate the trial with.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`

	// A list of tags to associate with the trial. You can use Search API to search
	// on the tags.
	Tags []Tag `type:"list"`

	// The name of the trial. The name must be unique in your AWS account and is
	// not case-sensitive.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrialInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrialInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTrialInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DisplayName", 1))
	}

	if s.ExperimentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}

	if s.TrialName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateTrialOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTrialOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTrial = "CreateTrial"

// CreateTrialRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates an Amazon SageMaker trial. A trial is a set of steps called trial
// components that produce a machine learning model. A trial is part of a single
// Amazon SageMaker experiment.
//
// When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
// all experiments, trials, and trial components are automatically tracked,
// logged, and indexed. When you use the AWS SDK for Python (Boto), you must
// use the logging APIs provided by the SDK.
//
// You can add tags to a trial and then use the Search API to search for the
// tags.
//
// To get a list of all your trials, call the ListTrials API. To view a trial's
// properties, call the DescribeTrial API. To create a trial component, call
// the CreateTrialComponent API.
//
//    // Example sending a request using CreateTrialRequest.
//    req := client.CreateTrialRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial
func (c *Client) CreateTrialRequest(input *CreateTrialInput) CreateTrialRequest {
	op := &aws.Operation{
		Name:       opCreateTrial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrialInput{}
	}

	req := c.newRequest(op, input, &CreateTrialOutput{})

	return CreateTrialRequest{Request: req, Input: input, Copy: c.CreateTrialRequest}
}

// CreateTrialRequest is the request type for the
// CreateTrial API operation.
type CreateTrialRequest struct {
	*aws.Request
	Input *CreateTrialInput
	Copy  func(*CreateTrialInput) CreateTrialRequest
}

// Send marshals and sends the CreateTrial API request.
func (r CreateTrialRequest) Send(ctx context.Context) (*CreateTrialResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTrialResponse{
		CreateTrialOutput: r.Request.Data.(*CreateTrialOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTrialResponse is the response type for the
// CreateTrial API operation.
type CreateTrialResponse struct {
	*CreateTrialOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTrial request.
func (r *CreateTrialResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
