// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteNotebookInstanceLifecycleConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the lifecycle configuration to delete.
	//
	// NotebookInstanceLifecycleConfigName is a required field
	NotebookInstanceLifecycleConfigName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotebookInstanceLifecycleConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNotebookInstanceLifecycleConfigInput"}

	if s.NotebookInstanceLifecycleConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NotebookInstanceLifecycleConfigName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteNotebookInstanceLifecycleConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotebookInstanceLifecycleConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNotebookInstanceLifecycleConfig = "DeleteNotebookInstanceLifecycleConfig"

// DeleteNotebookInstanceLifecycleConfigRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes a notebook instance lifecycle configuration.
//
//    // Example sending a request using DeleteNotebookInstanceLifecycleConfigRequest.
//    req := client.DeleteNotebookInstanceLifecycleConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig
func (c *Client) DeleteNotebookInstanceLifecycleConfigRequest(input *DeleteNotebookInstanceLifecycleConfigInput) DeleteNotebookInstanceLifecycleConfigRequest {
	op := &aws.Operation{
		Name:       opDeleteNotebookInstanceLifecycleConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotebookInstanceLifecycleConfigInput{}
	}

	req := c.newRequest(op, input, &DeleteNotebookInstanceLifecycleConfigOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteNotebookInstanceLifecycleConfigRequest{Request: req, Input: input, Copy: c.DeleteNotebookInstanceLifecycleConfigRequest}
}

// DeleteNotebookInstanceLifecycleConfigRequest is the request type for the
// DeleteNotebookInstanceLifecycleConfig API operation.
type DeleteNotebookInstanceLifecycleConfigRequest struct {
	*aws.Request
	Input *DeleteNotebookInstanceLifecycleConfigInput
	Copy  func(*DeleteNotebookInstanceLifecycleConfigInput) DeleteNotebookInstanceLifecycleConfigRequest
}

// Send marshals and sends the DeleteNotebookInstanceLifecycleConfig API request.
func (r DeleteNotebookInstanceLifecycleConfigRequest) Send(ctx context.Context) (*DeleteNotebookInstanceLifecycleConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNotebookInstanceLifecycleConfigResponse{
		DeleteNotebookInstanceLifecycleConfigOutput: r.Request.Data.(*DeleteNotebookInstanceLifecycleConfigOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNotebookInstanceLifecycleConfigResponse is the response type for the
// DeleteNotebookInstanceLifecycleConfig API operation.
type DeleteNotebookInstanceLifecycleConfigResponse struct {
	*DeleteNotebookInstanceLifecycleConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNotebookInstanceLifecycleConfig request.
func (r *DeleteNotebookInstanceLifecycleConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
