// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`

	// The user profile name.
	//
	// UserProfileName is a required field
	UserProfileName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteUserProfileInput"}

	if s.DomainId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainId"))
	}

	if s.UserProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserProfileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Deletes a user profile. When a user profile is deleted, the user loses access
// to their EFS volume, including data, notebooks, and other artifacts.
//
//    // Example sending a request using DeleteUserProfileRequest.
//    req := client.DeleteUserProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile
func (c *Client) DeleteUserProfileRequest(input *DeleteUserProfileInput) DeleteUserProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteUserProfileOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteUserProfileRequest{Request: req, Input: input, Copy: c.DeleteUserProfileRequest}
}

// DeleteUserProfileRequest is the request type for the
// DeleteUserProfile API operation.
type DeleteUserProfileRequest struct {
	*aws.Request
	Input *DeleteUserProfileInput
	Copy  func(*DeleteUserProfileInput) DeleteUserProfileRequest
}

// Send marshals and sends the DeleteUserProfile API request.
func (r DeleteUserProfileRequest) Send(ctx context.Context) (*DeleteUserProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteUserProfileResponse{
		DeleteUserProfileOutput: r.Request.Data.(*DeleteUserProfileOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteUserProfileResponse is the response type for the
// DeleteUserProfile API operation.
type DeleteUserProfileResponse struct {
	*DeleteUserProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteUserProfile request.
func (r *DeleteUserProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
