// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAlgorithmInput struct {
	_ struct{} `type:"structure"`

	// The name of the algorithm to describe.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAlgorithmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAlgorithmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAlgorithmInput"}

	if s.AlgorithmName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AlgorithmName"))
	}
	if s.AlgorithmName != nil && len(*s.AlgorithmName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AlgorithmName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAlgorithmOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// AlgorithmArn is a required field
	AlgorithmArn *string `min:"1" type:"string" required:"true"`

	// A brief summary about the algorithm.
	AlgorithmDescription *string `type:"string"`

	// The name of the algorithm being described.
	//
	// AlgorithmName is a required field
	AlgorithmName *string `min:"1" type:"string" required:"true"`

	// The current status of the algorithm.
	//
	// AlgorithmStatus is a required field
	AlgorithmStatus AlgorithmStatus `type:"string" required:"true" enum:"true"`

	// Details about the current status of the algorithm.
	//
	// AlgorithmStatusDetails is a required field
	AlgorithmStatusDetails *AlgorithmStatusDetails `type:"structure" required:"true"`

	// Whether the algorithm is certified to be listed in AWS Marketplace.
	CertifyForMarketplace *bool `type:"boolean"`

	// A timestamp specifying when the algorithm was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Details about inference jobs that the algorithm runs.
	InferenceSpecification *InferenceSpecification `type:"structure"`

	// The product identifier of the algorithm.
	ProductId *string `type:"string"`

	// Details about training jobs run by this algorithm.
	//
	// TrainingSpecification is a required field
	TrainingSpecification *TrainingSpecification `type:"structure" required:"true"`

	// Details about configurations for one or more training jobs that Amazon SageMaker
	// runs to test the algorithm.
	ValidationSpecification *AlgorithmValidationSpecification `type:"structure"`
}

// String returns the string representation
func (s DescribeAlgorithmOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAlgorithm = "DescribeAlgorithm"

// DescribeAlgorithmRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns a description of the specified algorithm that is in your account.
//
//    // Example sending a request using DescribeAlgorithmRequest.
//    req := client.DescribeAlgorithmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm
func (c *Client) DescribeAlgorithmRequest(input *DescribeAlgorithmInput) DescribeAlgorithmRequest {
	op := &aws.Operation{
		Name:       opDescribeAlgorithm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAlgorithmInput{}
	}

	req := c.newRequest(op, input, &DescribeAlgorithmOutput{})

	return DescribeAlgorithmRequest{Request: req, Input: input, Copy: c.DescribeAlgorithmRequest}
}

// DescribeAlgorithmRequest is the request type for the
// DescribeAlgorithm API operation.
type DescribeAlgorithmRequest struct {
	*aws.Request
	Input *DescribeAlgorithmInput
	Copy  func(*DescribeAlgorithmInput) DescribeAlgorithmRequest
}

// Send marshals and sends the DescribeAlgorithm API request.
func (r DescribeAlgorithmRequest) Send(ctx context.Context) (*DescribeAlgorithmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAlgorithmResponse{
		DescribeAlgorithmOutput: r.Request.Data.(*DescribeAlgorithmOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAlgorithmResponse is the response type for the
// DescribeAlgorithm API operation.
type DescribeAlgorithmResponse struct {
	*DescribeAlgorithmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAlgorithm request.
func (r *DescribeAlgorithmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
