// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAutoMLJobInput struct {
	_ struct{} `type:"structure"`

	// Request information about a job using that job's unique name.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAutoMLJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutoMLJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAutoMLJobInput"}

	if s.AutoMLJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoMLJobName"))
	}
	if s.AutoMLJobName != nil && len(*s.AutoMLJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoMLJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAutoMLJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the job's ARN.
	//
	// AutoMLJobArn is a required field
	AutoMLJobArn *string `min:"1" type:"string" required:"true"`

	// Returns information on the job's artifacts found in AutoMLJobArtifacts.
	AutoMLJobArtifacts *AutoMLJobArtifacts `type:"structure"`

	// Returns the job's config.
	AutoMLJobConfig *AutoMLJobConfig `type:"structure"`

	// Returns the name of a job.
	//
	// AutoMLJobName is a required field
	AutoMLJobName *string `min:"1" type:"string" required:"true"`

	// Returns the job's objective.
	AutoMLJobObjective *AutoMLJobObjective `type:"structure"`

	// Returns the job's AutoMLJobSecondaryStatus.
	//
	// AutoMLJobSecondaryStatus is a required field
	AutoMLJobSecondaryStatus AutoMLJobSecondaryStatus `type:"string" required:"true" enum:"true"`

	// Returns the job's AutoMLJobStatus.
	//
	// AutoMLJobStatus is a required field
	AutoMLJobStatus AutoMLJobStatus `type:"string" required:"true" enum:"true"`

	// Returns the job's BestCandidate.
	BestCandidate *AutoMLCandidate `type:"structure"`

	// Returns the job's creation time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Returns the job's end time.
	EndTime *time.Time `type:"timestamp"`

	// Returns the job's FailureReason.
	FailureReason *string `type:"string"`

	// Returns the job's output from GenerateCandidateDefinitionsOnly.
	GenerateCandidateDefinitionsOnly *bool `type:"boolean"`

	// Returns the job's input data config.
	//
	// InputDataConfig is a required field
	InputDataConfig []AutoMLChannel `min:"1" type:"list" required:"true"`

	// Returns the job's last modified time.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`

	// Returns the job's output data config.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *AutoMLOutputDataConfig `type:"structure" required:"true"`

	// Returns the job's problem type.
	ProblemType ProblemType `type:"string" enum:"true"`

	// This contains ProblemType, AutoMLJobObjective and CompletionCriteria. They're
	// auto-inferred values, if not provided by you. If you do provide them, then
	// they'll be the same as provided.
	ResolvedAttributes *ResolvedAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that has read permission to the input data location and write
	// permission to the output data location in Amazon S3.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAutoMLJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAutoMLJob = "DescribeAutoMLJob"

// DescribeAutoMLJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns information about an Amazon SageMaker job.
//
//    // Example sending a request using DescribeAutoMLJobRequest.
//    req := client.DescribeAutoMLJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob
func (c *Client) DescribeAutoMLJobRequest(input *DescribeAutoMLJobInput) DescribeAutoMLJobRequest {
	op := &aws.Operation{
		Name:       opDescribeAutoMLJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoMLJobInput{}
	}

	req := c.newRequest(op, input, &DescribeAutoMLJobOutput{})

	return DescribeAutoMLJobRequest{Request: req, Input: input, Copy: c.DescribeAutoMLJobRequest}
}

// DescribeAutoMLJobRequest is the request type for the
// DescribeAutoMLJob API operation.
type DescribeAutoMLJobRequest struct {
	*aws.Request
	Input *DescribeAutoMLJobInput
	Copy  func(*DescribeAutoMLJobInput) DescribeAutoMLJobRequest
}

// Send marshals and sends the DescribeAutoMLJob API request.
func (r DescribeAutoMLJobRequest) Send(ctx context.Context) (*DescribeAutoMLJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAutoMLJobResponse{
		DescribeAutoMLJobOutput: r.Request.Data.(*DescribeAutoMLJobOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAutoMLJobResponse is the response type for the
// DescribeAutoMLJob API operation.
type DescribeAutoMLJobResponse struct {
	*DescribeAutoMLJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAutoMLJob request.
func (r *DescribeAutoMLJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
