// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDomainInput"}

	if s.DomainId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The domain's authentication mode.
	AuthMode AuthMode `type:"string" enum:"true"`

	// The creation time.
	CreationTime *time.Time `type:"timestamp"`

	// Settings which are applied to all UserProfile in this domain, if settings
	// are not explicitly specified in a given UserProfile.
	DefaultUserSettings *UserSettings `type:"structure"`

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string `type:"string"`

	// The domain ID.
	DomainId *string `type:"string"`

	// The domain name.
	DomainName *string `type:"string"`

	// The failure reason.
	FailureReason *string `type:"string"`

	// The ID of the Amazon Elastic File System (EFS) managed by this Domain.
	HomeEfsFileSystemId *string `type:"string"`

	// The AWS Key Management Service encryption key ID.
	HomeEfsFileSystemKmsKeyId *string `type:"string"`

	// The last modified time.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The SSO managed application instance ID.
	SingleSignOnManagedApplicationInstanceId *string `type:"string"`

	// The status.
	Status DomainStatus `type:"string" enum:"true"`

	// Security setting to limit to a set of subnets.
	SubnetIds []string `min:"1" type:"list"`

	// The domain's URL.
	Url *string `type:"string"`

	// The ID of the Amazon Virtual Private Cloud.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// The description of the domain.
//
//    // Example sending a request using DescribeDomainRequest.
//    req := client.DescribeDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain
func (c *Client) DescribeDomainRequest(input *DescribeDomainInput) DescribeDomainRequest {
	op := &aws.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	req := c.newRequest(op, input, &DescribeDomainOutput{})

	return DescribeDomainRequest{Request: req, Input: input, Copy: c.DescribeDomainRequest}
}

// DescribeDomainRequest is the request type for the
// DescribeDomain API operation.
type DescribeDomainRequest struct {
	*aws.Request
	Input *DescribeDomainInput
	Copy  func(*DescribeDomainInput) DescribeDomainRequest
}

// Send marshals and sends the DescribeDomain API request.
func (r DescribeDomainRequest) Send(ctx context.Context) (*DescribeDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDomainResponse{
		DescribeDomainOutput: r.Request.Data.(*DescribeDomainOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDomainResponse is the response type for the
// DescribeDomain API operation.
type DescribeDomainResponse struct {
	*DescribeDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDomain request.
func (r *DescribeDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
