// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeExperimentInput struct {
	_ struct{} `type:"structure"`

	// The name of the experiment to describe.
	//
	// ExperimentName is a required field
	ExperimentName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeExperimentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeExperimentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeExperimentInput"}

	if s.ExperimentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExperimentName"))
	}
	if s.ExperimentName != nil && len(*s.ExperimentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExperimentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeExperimentOutput struct {
	_ struct{} `type:"structure"`

	// Who created the experiment.
	CreatedBy *UserContext `type:"structure"`

	// When the experiment was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the experiment.
	Description *string `type:"string"`

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string `type:"string"`

	// The name of the experiment.
	ExperimentName *string `min:"1" type:"string"`

	// Who last modified the experiment.
	LastModifiedBy *UserContext `type:"structure"`

	// When the experiment was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ARN of the source and, optionally, the type.
	Source *ExperimentSource `type:"structure"`
}

// String returns the string representation
func (s DescribeExperimentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeExperiment = "DescribeExperiment"

// DescribeExperimentRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Provides a list of an experiment's properties.
//
//    // Example sending a request using DescribeExperimentRequest.
//    req := client.DescribeExperimentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment
func (c *Client) DescribeExperimentRequest(input *DescribeExperimentInput) DescribeExperimentRequest {
	op := &aws.Operation{
		Name:       opDescribeExperiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeExperimentInput{}
	}

	req := c.newRequest(op, input, &DescribeExperimentOutput{})

	return DescribeExperimentRequest{Request: req, Input: input, Copy: c.DescribeExperimentRequest}
}

// DescribeExperimentRequest is the request type for the
// DescribeExperiment API operation.
type DescribeExperimentRequest struct {
	*aws.Request
	Input *DescribeExperimentInput
	Copy  func(*DescribeExperimentInput) DescribeExperimentRequest
}

// Send marshals and sends the DescribeExperiment API request.
func (r DescribeExperimentRequest) Send(ctx context.Context) (*DescribeExperimentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeExperimentResponse{
		DescribeExperimentOutput: r.Request.Data.(*DescribeExperimentOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeExperimentResponse is the response type for the
// DescribeExperiment API operation.
type DescribeExperimentResponse struct {
	*DescribeExperimentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeExperiment request.
func (r *DescribeExperimentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
