// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeProcessingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the processing job. The name must be unique within an AWS Region
	// in the AWS account.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProcessingJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProcessingJobInput"}

	if s.ProcessingJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProcessingJobName"))
	}
	if s.ProcessingJobName != nil && len(*s.ProcessingJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProcessingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProcessingJobOutput struct {
	_ struct{} `type:"structure"`

	// Configures the processing job to run a specified container image.
	//
	// AppSpecification is a required field
	AppSpecification *AppSpecification `type:"structure" required:"true"`

	// The ARN of an AutoML job associated with this processing job.
	AutoMLJobArn *string `min:"1" type:"string"`

	// The time at which the processing job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The environment variables set in the Docker container.
	Environment map[string]string `type:"map"`

	// An optional string, up to one KB in size, that contains metadata from the
	// processing container when the processing job exits.
	ExitMessage *string `type:"string"`

	// The configuration information used to create an experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string `type:"string"`

	// The time at which the processing job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The ARN of a monitoring schedule for an endpoint associated with this processing
	// job.
	MonitoringScheduleArn *string `type:"string"`

	// Networking options for a processing job.
	NetworkConfig *NetworkConfig `type:"structure"`

	// The time at which the processing job completed.
	ProcessingEndTime *time.Time `type:"timestamp"`

	// The inputs for a processing job.
	ProcessingInputs []ProcessingInput `type:"list"`

	// The Amazon Resource Name (ARN) of the processing job.
	//
	// ProcessingJobArn is a required field
	ProcessingJobArn *string `type:"string" required:"true"`

	// The name of the processing job. The name must be unique within an AWS Region
	// in the AWS account.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`

	// Provides the status of a processing job.
	//
	// ProcessingJobStatus is a required field
	ProcessingJobStatus ProcessingJobStatus `type:"string" required:"true" enum:"true"`

	// Output configuration for the processing job.
	ProcessingOutputConfig *ProcessingOutputConfig `type:"structure"`

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a processing job. In distributed training, you specify more than
	// one instance.
	//
	// ProcessingResources is a required field
	ProcessingResources *ProcessingResources `type:"structure" required:"true"`

	// The time at which the processing job started.
	ProcessingStartTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	RoleArn *string `min:"20" type:"string"`

	// The time limit for how long the processing job is allowed to run.
	StoppingCondition *ProcessingStoppingCondition `type:"structure"`

	// The ARN of a training job associated with this processing job.
	TrainingJobArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProcessingJob = "DescribeProcessingJob"

// DescribeProcessingJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns a description of a processing job.
//
//    // Example sending a request using DescribeProcessingJobRequest.
//    req := client.DescribeProcessingJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob
func (c *Client) DescribeProcessingJobRequest(input *DescribeProcessingJobInput) DescribeProcessingJobRequest {
	op := &aws.Operation{
		Name:       opDescribeProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProcessingJobInput{}
	}

	req := c.newRequest(op, input, &DescribeProcessingJobOutput{})

	return DescribeProcessingJobRequest{Request: req, Input: input, Copy: c.DescribeProcessingJobRequest}
}

// DescribeProcessingJobRequest is the request type for the
// DescribeProcessingJob API operation.
type DescribeProcessingJobRequest struct {
	*aws.Request
	Input *DescribeProcessingJobInput
	Copy  func(*DescribeProcessingJobInput) DescribeProcessingJobRequest
}

// Send marshals and sends the DescribeProcessingJob API request.
func (r DescribeProcessingJobRequest) Send(ctx context.Context) (*DescribeProcessingJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProcessingJobResponse{
		DescribeProcessingJobOutput: r.Request.Data.(*DescribeProcessingJobOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProcessingJobResponse is the response type for the
// DescribeProcessingJob API operation.
type DescribeProcessingJobResponse struct {
	*DescribeProcessingJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProcessingJob request.
func (r *DescribeProcessingJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
