// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSubscribedWorkteamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the subscribed work team to describe.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSubscribedWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSubscribedWorkteamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSubscribedWorkteamInput"}

	if s.WorkteamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkteamArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSubscribedWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// A Workteam instance that contains information about the work team.
	//
	// SubscribedWorkteam is a required field
	SubscribedWorkteam *SubscribedWorkteam `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeSubscribedWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSubscribedWorkteam = "DescribeSubscribedWorkteam"

// DescribeSubscribedWorkteamRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Gets information about a work team provided by a vendor. It returns details
// about the subscription with a vendor in the AWS Marketplace.
//
//    // Example sending a request using DescribeSubscribedWorkteamRequest.
//    req := client.DescribeSubscribedWorkteamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam
func (c *Client) DescribeSubscribedWorkteamRequest(input *DescribeSubscribedWorkteamInput) DescribeSubscribedWorkteamRequest {
	op := &aws.Operation{
		Name:       opDescribeSubscribedWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubscribedWorkteamInput{}
	}

	req := c.newRequest(op, input, &DescribeSubscribedWorkteamOutput{})

	return DescribeSubscribedWorkteamRequest{Request: req, Input: input, Copy: c.DescribeSubscribedWorkteamRequest}
}

// DescribeSubscribedWorkteamRequest is the request type for the
// DescribeSubscribedWorkteam API operation.
type DescribeSubscribedWorkteamRequest struct {
	*aws.Request
	Input *DescribeSubscribedWorkteamInput
	Copy  func(*DescribeSubscribedWorkteamInput) DescribeSubscribedWorkteamRequest
}

// Send marshals and sends the DescribeSubscribedWorkteam API request.
func (r DescribeSubscribedWorkteamRequest) Send(ctx context.Context) (*DescribeSubscribedWorkteamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSubscribedWorkteamResponse{
		DescribeSubscribedWorkteamOutput: r.Request.Data.(*DescribeSubscribedWorkteamOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSubscribedWorkteamResponse is the response type for the
// DescribeSubscribedWorkteam API operation.
type DescribeSubscribedWorkteamResponse struct {
	*DescribeSubscribedWorkteamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSubscribedWorkteam request.
func (r *DescribeSubscribedWorkteamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
