// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTrainingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrainingJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrainingJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTrainingJobInput"}

	if s.TrainingJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrainingJobName"))
	}
	if s.TrainingJobName != nil && len(*s.TrainingJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrainingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTrainingJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the algorithm used for training, and algorithm metadata.
	//
	// AlgorithmSpecification is a required field
	AlgorithmSpecification *AlgorithmSpecification `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of an AutoML job.
	AutoMLJobArn *string `min:"1" type:"string"`

	// The billable time in seconds.
	//
	// You can calculate the savings from using managed spot training using the
	// formula (1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100. For example,
	// if BillableTimeInSeconds is 100 and TrainingTimeInSeconds is 500, the savings
	// is 80%.
	BillableTimeInSeconds *int64 `min:"1" type:"integer"`

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig `type:"structure"`

	// A timestamp that indicates when the training job was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration information for the debug hook parameters, collection configuration,
	// and storage paths.
	DebugHookConfig *DebugHookConfig `type:"structure"`

	// Configuration information for debugging rules.
	DebugRuleConfigurations []DebugRuleConfiguration `type:"list"`

	// Status about the debug rule evaluation.
	DebugRuleEvaluationStatuses []DebugRuleEvaluationStatus `type:"list"`

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True. Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use
	// a deep learning algorithms in distributed training.
	EnableInterContainerTrafficEncryption *bool `type:"boolean"`

	// A Boolean indicating whether managed spot training is enabled (True) or not
	// (False).
	EnableManagedSpotTraining *bool `type:"boolean"`

	// If you want to allow inbound or outbound network calls, except for calls
	// between peers within a training cluster for distributed training, choose
	// True. If you enable network isolation for training jobs that are configured
	// to use a VPC, Amazon SageMaker downloads and uploads customer data and model
	// artifacts through the specified VPC, but the training container does not
	// have network access.
	EnableNetworkIsolation *bool `type:"boolean"`

	// Configuration for the experiment.
	ExperimentConfig *ExperimentConfig `type:"structure"`

	// If the training job failed, the reason it failed.
	FailureReason *string `type:"string"`

	// A collection of MetricData objects that specify the names, values, and dates
	// and times that the training algorithm emitted to Amazon CloudWatch.
	FinalMetricDataList []MetricData `type:"list"`

	// Algorithm-specific parameters.
	HyperParameters map[string]string `type:"map"`

	// An array of Channel objects that describes each data input channel.
	InputDataConfig []Channel `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling
	// job that created the transform or training job.
	LabelingJobArn *string `type:"string"`

	// A timestamp that indicates when the status of the training job was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	//
	// ModelArtifacts is a required field
	ModelArtifacts *ModelArtifacts `type:"structure" required:"true"`

	// The S3 path where model artifacts that you configured when creating the job
	// are stored. Amazon SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	//
	// ResourceConfig is a required field
	ResourceConfig *ResourceConfig `type:"structure" required:"true"`

	// The AWS Identity and Access Management (IAM) role configured for the training
	// job.
	RoleArn *string `min:"20" type:"string"`

	// Provides detailed information about the state of the training job. For detailed
	// information on the secondary status of the training job, see StatusMessage
	// under SecondaryStatusTransition.
	//
	// Amazon SageMaker provides primary statuses and secondary statuses that apply
	// to each of them:
	//
	// InProgress
	//
	//    * Starting - Starting the training job.
	//
	//    * Downloading - An optional stage for algorithms that support File training
	//    input mode. It indicates that data is being downloaded to the ML storage
	//    volumes.
	//
	//    * Training - Training is in progress.
	//
	//    * Interrupted - The job stopped because the managed spot training instances
	//    were interrupted.
	//
	//    * Uploading - Training is complete and the model artifacts are being uploaded
	//    to the S3 location.
	//
	// Completed
	//
	//    * Completed - The training job has completed.
	//
	// Failed
	//
	//    * Failed - The training job has failed. The reason for the failure is
	//    returned in the FailureReason field of DescribeTrainingJobResponse.
	//
	// Stopped
	//
	//    * MaxRuntimeExceeded - The job stopped because it exceeded the maximum
	//    allowed runtime.
	//
	//    * MaxWaitTmeExceeded - The job stopped because it exceeded the maximum
	//    allowed wait time.
	//
	//    * Stopped - The training job has stopped.
	//
	// Stopping
	//
	//    * Stopping - Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to change.
	//
	// We no longer support the following secondary statuses:
	//
	//    * LaunchingMLInstances
	//
	//    * PreparingTrainingStack
	//
	//    * DownloadingTrainingImage
	//
	// SecondaryStatus is a required field
	SecondaryStatus SecondaryStatus `type:"string" required:"true" enum:"true"`

	// A history of all of the secondary statuses that the training job has transitioned
	// through.
	SecondaryStatusTransitions []SecondaryStatusTransition `type:"list"`

	// Specifies a limit to how long a model training job can run. It also specifies
	// the maximum time to wait for a spot instance. When the job reaches the time
	// limit, Amazon SageMaker ends the training job. Use this API to cap model
	// training costs.
	//
	// To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which
	// delays job termination for 120 seconds. Algorithms can use this 120-second
	// window to save the model artifacts, so the results of training are not lost.
	//
	// StoppingCondition is a required field
	StoppingCondition *StoppingCondition `type:"structure" required:"true"`

	// Configuration of storage locations for TensorBoard output.
	TensorBoardOutputConfig *TensorBoardOutputConfig `type:"structure"`

	// Indicates the time when the training job ends on training instances. You
	// are billed for the time interval between the value of TrainingStartTime and
	// this time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker
	// detects a job failure.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the training job.
	//
	// TrainingJobArn is a required field
	TrainingJobArn *string `type:"string" required:"true"`

	// Name of the model training job.
	//
	// TrainingJobName is a required field
	TrainingJobName *string `min:"1" type:"string" required:"true"`

	// The status of the training job.
	//
	// Amazon SageMaker provides the following training job statuses:
	//
	//    * InProgress - The training is in progress.
	//
	//    * Completed - The training job has completed.
	//
	//    * Failed - The training job has failed. To see the reason for the failure,
	//    see the FailureReason field in the response to a DescribeTrainingJobResponse
	//    call.
	//
	//    * Stopping - The training job is stopping.
	//
	//    * Stopped - The training job has stopped.
	//
	// For more detailed information, see SecondaryStatus.
	//
	// TrainingJobStatus is a required field
	TrainingJobStatus TrainingJobStatus `type:"string" required:"true" enum:"true"`

	// Indicates the time when the training job starts on training instances. You
	// are billed for the time interval between this time and the value of TrainingEndTime.
	// The start time in CloudWatch Logs might be later than this time. The difference
	// is due to the time it takes to download the training data and to the size
	// of the training container.
	TrainingStartTime *time.Time `type:"timestamp"`

	// The training time in seconds.
	TrainingTimeInSeconds *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job
	// if the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string `type:"string"`

	// A VpcConfig object that specifies the VPC that this training job has access
	// to. For more information, see Protect Training Jobs by Using an Amazon Virtual
	// Private Cloud (https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeTrainingJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTrainingJob = "DescribeTrainingJob"

// DescribeTrainingJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Returns information about a training job.
//
//    // Example sending a request using DescribeTrainingJobRequest.
//    req := client.DescribeTrainingJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob
func (c *Client) DescribeTrainingJobRequest(input *DescribeTrainingJobInput) DescribeTrainingJobRequest {
	op := &aws.Operation{
		Name:       opDescribeTrainingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrainingJobInput{}
	}

	req := c.newRequest(op, input, &DescribeTrainingJobOutput{})

	return DescribeTrainingJobRequest{Request: req, Input: input, Copy: c.DescribeTrainingJobRequest}
}

// DescribeTrainingJobRequest is the request type for the
// DescribeTrainingJob API operation.
type DescribeTrainingJobRequest struct {
	*aws.Request
	Input *DescribeTrainingJobInput
	Copy  func(*DescribeTrainingJobInput) DescribeTrainingJobRequest
}

// Send marshals and sends the DescribeTrainingJob API request.
func (r DescribeTrainingJobRequest) Send(ctx context.Context) (*DescribeTrainingJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTrainingJobResponse{
		DescribeTrainingJobOutput: r.Request.Data.(*DescribeTrainingJobOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTrainingJobResponse is the response type for the
// DescribeTrainingJob API operation.
type DescribeTrainingJobResponse struct {
	*DescribeTrainingJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTrainingJob request.
func (r *DescribeTrainingJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
