// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateTrialComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to disassociate from the trial.
	//
	// TrialComponentName is a required field
	TrialComponentName *string `min:"1" type:"string" required:"true"`

	// The name of the trial to disassociate from.
	//
	// TrialName is a required field
	TrialName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTrialComponentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTrialComponentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateTrialComponentInput"}

	if s.TrialComponentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrialComponentName"))
	}
	if s.TrialComponentName != nil && len(*s.TrialComponentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialComponentName", 1))
	}

	if s.TrialName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrialName"))
	}
	if s.TrialName != nil && len(*s.TrialName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrialName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateTrialComponentOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string `type:"string"`

	// The ARN of the trial component.
	TrialComponentArn *string `type:"string"`
}

// String returns the string representation
func (s DisassociateTrialComponentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateTrialComponent = "DisassociateTrialComponent"

// DisassociateTrialComponentRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Disassociates a trial component from a trial. This doesn't effect other trials
// the component is associated with. Before you can delete a component, you
// must disassociate the component from all trials it is associated with. To
// associate a trial component with a trial, call the AssociateTrialComponent
// API.
//
// To get a list of the trials a component is associated with, use the Search
// API. Specify ExperimentTrialComponent for the Resource parameter. The list
// appears in the response under Results.TrialComponent.Parents.
//
//    // Example sending a request using DisassociateTrialComponentRequest.
//    req := client.DisassociateTrialComponentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DisassociateTrialComponent
func (c *Client) DisassociateTrialComponentRequest(input *DisassociateTrialComponentInput) DisassociateTrialComponentRequest {
	op := &aws.Operation{
		Name:       opDisassociateTrialComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTrialComponentInput{}
	}

	req := c.newRequest(op, input, &DisassociateTrialComponentOutput{})

	return DisassociateTrialComponentRequest{Request: req, Input: input, Copy: c.DisassociateTrialComponentRequest}
}

// DisassociateTrialComponentRequest is the request type for the
// DisassociateTrialComponent API operation.
type DisassociateTrialComponentRequest struct {
	*aws.Request
	Input *DisassociateTrialComponentInput
	Copy  func(*DisassociateTrialComponentInput) DisassociateTrialComponentRequest
}

// Send marshals and sends the DisassociateTrialComponent API request.
func (r DisassociateTrialComponentRequest) Send(ctx context.Context) (*DisassociateTrialComponentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateTrialComponentResponse{
		DisassociateTrialComponentOutput: r.Request.Data.(*DisassociateTrialComponentOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateTrialComponentResponse is the response type for the
// DisassociateTrialComponent API operation.
type DisassociateTrialComponentResponse struct {
	*DisassociateTrialComponentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateTrialComponent request.
func (r *DisassociateTrialComponentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
