// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListAutoMLJobsInput struct {
	_ struct{} `type:"structure"`

	// Request a list of jobs, using a filter for time.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Request a list of jobs, using a filter for time.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// Request a list of jobs, using a filter for time.
	LastModifiedTimeAfter *time.Time `type:"timestamp"`

	// Request a list of jobs, using a filter for time.
	LastModifiedTimeBefore *time.Time `type:"timestamp"`

	// Request a list of jobs up to a specified limit.
	MaxResults *int64 `min:"1" type:"integer"`

	// Request a list of jobs, using a search filter for name.
	NameContains *string `type:"string"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`

	// The parameter by which to sort the results. The default is AutoMLJobName.
	SortBy AutoMLSortBy `type:"string" enum:"true"`

	// The sort order for the results. The default is Descending.
	SortOrder AutoMLSortOrder `type:"string" enum:"true"`

	// Request a list of jobs, using a filter for status.
	StatusEquals AutoMLJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListAutoMLJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAutoMLJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAutoMLJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAutoMLJobsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a summary list of jobs.
	//
	// AutoMLJobSummaries is a required field
	AutoMLJobSummaries []AutoMLJobSummary `type:"list" required:"true"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAutoMLJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAutoMLJobs = "ListAutoMLJobs"

// ListAutoMLJobsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Request a list of jobs.
//
//    // Example sending a request using ListAutoMLJobsRequest.
//    req := client.ListAutoMLJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListAutoMLJobs
func (c *Client) ListAutoMLJobsRequest(input *ListAutoMLJobsInput) ListAutoMLJobsRequest {
	op := &aws.Operation{
		Name:       opListAutoMLJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAutoMLJobsInput{}
	}

	req := c.newRequest(op, input, &ListAutoMLJobsOutput{})

	return ListAutoMLJobsRequest{Request: req, Input: input, Copy: c.ListAutoMLJobsRequest}
}

// ListAutoMLJobsRequest is the request type for the
// ListAutoMLJobs API operation.
type ListAutoMLJobsRequest struct {
	*aws.Request
	Input *ListAutoMLJobsInput
	Copy  func(*ListAutoMLJobsInput) ListAutoMLJobsRequest
}

// Send marshals and sends the ListAutoMLJobs API request.
func (r ListAutoMLJobsRequest) Send(ctx context.Context) (*ListAutoMLJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAutoMLJobsResponse{
		ListAutoMLJobsOutput: r.Request.Data.(*ListAutoMLJobsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAutoMLJobsRequestPaginator returns a paginator for ListAutoMLJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAutoMLJobsRequest(input)
//   p := sagemaker.NewListAutoMLJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAutoMLJobsPaginator(req ListAutoMLJobsRequest) ListAutoMLJobsPaginator {
	return ListAutoMLJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAutoMLJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAutoMLJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAutoMLJobsPaginator struct {
	aws.Pager
}

func (p *ListAutoMLJobsPaginator) CurrentPage() *ListAutoMLJobsOutput {
	return p.Pager.CurrentPage().(*ListAutoMLJobsOutput)
}

// ListAutoMLJobsResponse is the response type for the
// ListAutoMLJobs API operation.
type ListAutoMLJobsResponse struct {
	*ListAutoMLJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAutoMLJobs request.
func (r *ListAutoMLJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
