// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListLabelingJobsForWorkteamInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only labeling jobs created after the specified time
	// (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp"`

	// A filter that returns only labeling jobs created before the specified time
	// (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp"`

	// A filter the limits jobs to only the ones whose job reference code contains
	// the specified string.
	JobReferenceCodeContains *string `min:"1" type:"string"`

	// The maximum number of labeling jobs to return in each page of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous ListLabelingJobsForWorkteam request was truncated,
	// the response includes a NextToken. To retrieve the next set of labeling jobs,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// The field to sort results by. The default is CreationTime.
	SortBy ListLabelingJobsForWorkteamSortByOptions `type:"string" enum:"true"`

	// The sort order for results. The default is Ascending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the work team for which you want to see
	// labeling jobs for.
	//
	// WorkteamArn is a required field
	WorkteamArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListLabelingJobsForWorkteamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLabelingJobsForWorkteamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLabelingJobsForWorkteamInput"}
	if s.JobReferenceCodeContains != nil && len(*s.JobReferenceCodeContains) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobReferenceCodeContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.WorkteamArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkteamArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListLabelingJobsForWorkteamOutput struct {
	_ struct{} `type:"structure"`

	// An array of LabelingJobSummary objects, each describing a labeling job.
	//
	// LabelingJobSummaryList is a required field
	LabelingJobSummaryList []LabelingJobForWorkteamSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of labeling jobs, use it in the subsequent request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLabelingJobsForWorkteamOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLabelingJobsForWorkteam = "ListLabelingJobsForWorkteam"

// ListLabelingJobsForWorkteamRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Gets a list of labeling jobs assigned to a specified work team.
//
//    // Example sending a request using ListLabelingJobsForWorkteamRequest.
//    req := client.ListLabelingJobsForWorkteamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListLabelingJobsForWorkteam
func (c *Client) ListLabelingJobsForWorkteamRequest(input *ListLabelingJobsForWorkteamInput) ListLabelingJobsForWorkteamRequest {
	op := &aws.Operation{
		Name:       opListLabelingJobsForWorkteam,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLabelingJobsForWorkteamInput{}
	}

	req := c.newRequest(op, input, &ListLabelingJobsForWorkteamOutput{})

	return ListLabelingJobsForWorkteamRequest{Request: req, Input: input, Copy: c.ListLabelingJobsForWorkteamRequest}
}

// ListLabelingJobsForWorkteamRequest is the request type for the
// ListLabelingJobsForWorkteam API operation.
type ListLabelingJobsForWorkteamRequest struct {
	*aws.Request
	Input *ListLabelingJobsForWorkteamInput
	Copy  func(*ListLabelingJobsForWorkteamInput) ListLabelingJobsForWorkteamRequest
}

// Send marshals and sends the ListLabelingJobsForWorkteam API request.
func (r ListLabelingJobsForWorkteamRequest) Send(ctx context.Context) (*ListLabelingJobsForWorkteamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLabelingJobsForWorkteamResponse{
		ListLabelingJobsForWorkteamOutput: r.Request.Data.(*ListLabelingJobsForWorkteamOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListLabelingJobsForWorkteamRequestPaginator returns a paginator for ListLabelingJobsForWorkteam.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListLabelingJobsForWorkteamRequest(input)
//   p := sagemaker.NewListLabelingJobsForWorkteamRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListLabelingJobsForWorkteamPaginator(req ListLabelingJobsForWorkteamRequest) ListLabelingJobsForWorkteamPaginator {
	return ListLabelingJobsForWorkteamPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListLabelingJobsForWorkteamInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListLabelingJobsForWorkteamPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListLabelingJobsForWorkteamPaginator struct {
	aws.Pager
}

func (p *ListLabelingJobsForWorkteamPaginator) CurrentPage() *ListLabelingJobsForWorkteamOutput {
	return p.Pager.CurrentPage().(*ListLabelingJobsForWorkteamOutput)
}

// ListLabelingJobsForWorkteamResponse is the response type for the
// ListLabelingJobsForWorkteam API operation.
type ListLabelingJobsForWorkteamResponse struct {
	*ListLabelingJobsForWorkteamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLabelingJobsForWorkteam request.
func (r *ListLabelingJobsForWorkteamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
