// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type StopProcessingJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the processing job to stop.
	//
	// ProcessingJobName is a required field
	ProcessingJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopProcessingJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopProcessingJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopProcessingJobInput"}

	if s.ProcessingJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProcessingJobName"))
	}
	if s.ProcessingJobName != nil && len(*s.ProcessingJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProcessingJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopProcessingJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopProcessingJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopProcessingJob = "StopProcessingJob"

// StopProcessingJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Stops a processing job.
//
//    // Example sending a request using StopProcessingJobRequest.
//    req := client.StopProcessingJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopProcessingJob
func (c *Client) StopProcessingJobRequest(input *StopProcessingJobInput) StopProcessingJobRequest {
	op := &aws.Operation{
		Name:       opStopProcessingJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopProcessingJobInput{}
	}

	req := c.newRequest(op, input, &StopProcessingJobOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return StopProcessingJobRequest{Request: req, Input: input, Copy: c.StopProcessingJobRequest}
}

// StopProcessingJobRequest is the request type for the
// StopProcessingJob API operation.
type StopProcessingJobRequest struct {
	*aws.Request
	Input *StopProcessingJobInput
	Copy  func(*StopProcessingJobInput) StopProcessingJobRequest
}

// Send marshals and sends the StopProcessingJob API request.
func (r StopProcessingJobRequest) Send(ctx context.Context) (*StopProcessingJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopProcessingJobResponse{
		StopProcessingJobOutput: r.Request.Data.(*StopProcessingJobOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopProcessingJobResponse is the response type for the
// StopProcessingJob API operation.
type StopProcessingJobResponse struct {
	*StopProcessingJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopProcessingJob request.
func (r *StopProcessingJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
