// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateEndpointWeightsAndCapacitiesInput struct {
	_ struct{} `type:"structure"`

	// An object that provides new capacity and weight values for a variant.
	//
	// DesiredWeightsAndCapacities is a required field
	DesiredWeightsAndCapacities []DesiredWeightAndCapacity `min:"1" type:"list" required:"true"`

	// The name of an existing Amazon SageMaker endpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointWeightsAndCapacitiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEndpointWeightsAndCapacitiesInput"}

	if s.DesiredWeightsAndCapacities == nil {
		invalidParams.Add(aws.NewErrParamRequired("DesiredWeightsAndCapacities"))
	}
	if s.DesiredWeightsAndCapacities != nil && len(s.DesiredWeightsAndCapacities) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DesiredWeightsAndCapacities", 1))
	}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}
	if s.DesiredWeightsAndCapacities != nil {
		for i, v := range s.DesiredWeightsAndCapacities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DesiredWeightsAndCapacities", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateEndpointWeightsAndCapacitiesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointWeightsAndCapacitiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateEndpointWeightsAndCapacities = "UpdateEndpointWeightsAndCapacities"

// UpdateEndpointWeightsAndCapacitiesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Updates variant weight of one or more variants associated with an existing
// endpoint, or capacity of one variant associated with an existing endpoint.
// When it receives the request, Amazon SageMaker sets the endpoint status to
// Updating. After updating the endpoint, it sets the status to InService. To
// check the status of an endpoint, use the DescribeEndpoint API.
//
//    // Example sending a request using UpdateEndpointWeightsAndCapacitiesRequest.
//    req := client.UpdateEndpointWeightsAndCapacitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateEndpointWeightsAndCapacities
func (c *Client) UpdateEndpointWeightsAndCapacitiesRequest(input *UpdateEndpointWeightsAndCapacitiesInput) UpdateEndpointWeightsAndCapacitiesRequest {
	op := &aws.Operation{
		Name:       opUpdateEndpointWeightsAndCapacities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointWeightsAndCapacitiesInput{}
	}

	req := c.newRequest(op, input, &UpdateEndpointWeightsAndCapacitiesOutput{})

	return UpdateEndpointWeightsAndCapacitiesRequest{Request: req, Input: input, Copy: c.UpdateEndpointWeightsAndCapacitiesRequest}
}

// UpdateEndpointWeightsAndCapacitiesRequest is the request type for the
// UpdateEndpointWeightsAndCapacities API operation.
type UpdateEndpointWeightsAndCapacitiesRequest struct {
	*aws.Request
	Input *UpdateEndpointWeightsAndCapacitiesInput
	Copy  func(*UpdateEndpointWeightsAndCapacitiesInput) UpdateEndpointWeightsAndCapacitiesRequest
}

// Send marshals and sends the UpdateEndpointWeightsAndCapacities API request.
func (r UpdateEndpointWeightsAndCapacitiesRequest) Send(ctx context.Context) (*UpdateEndpointWeightsAndCapacitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEndpointWeightsAndCapacitiesResponse{
		UpdateEndpointWeightsAndCapacitiesOutput: r.Request.Data.(*UpdateEndpointWeightsAndCapacitiesOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEndpointWeightsAndCapacitiesResponse is the response type for the
// UpdateEndpointWeightsAndCapacities API operation.
type UpdateEndpointWeightsAndCapacitiesResponse struct {
	*UpdateEndpointWeightsAndCapacitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEndpointWeightsAndCapacities request.
func (r *UpdateEndpointWeightsAndCapacitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
