// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteSchemaInput struct {
	_ struct{} `type:"structure"`

	// RegistryName is a required field
	RegistryName *string `location:"uri" locationName:"registryName" type:"string" required:"true"`

	// SchemaName is a required field
	SchemaName *string `location:"uri" locationName:"schemaName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSchemaInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSchemaInput"}

	if s.RegistryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistryName"))
	}

	if s.SchemaName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSchemaInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RegistryName != nil {
		v := *s.RegistryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "registryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaName != nil {
		v := *s.SchemaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "schemaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteSchemaOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSchemaOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteSchema = "DeleteSchema"

// DeleteSchemaRequest returns a request value for making API operation for
// Schemas.
//
// Delete a schema definition.
//
//    // Example sending a request using DeleteSchemaRequest.
//    req := client.DeleteSchemaRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema
func (c *Client) DeleteSchemaRequest(input *DeleteSchemaInput) DeleteSchemaRequest {
	op := &aws.Operation{
		Name:       opDeleteSchema,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
	}

	if input == nil {
		input = &DeleteSchemaInput{}
	}

	req := c.newRequest(op, input, &DeleteSchemaOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteSchemaRequest{Request: req, Input: input, Copy: c.DeleteSchemaRequest}
}

// DeleteSchemaRequest is the request type for the
// DeleteSchema API operation.
type DeleteSchemaRequest struct {
	*aws.Request
	Input *DeleteSchemaInput
	Copy  func(*DeleteSchemaInput) DeleteSchemaRequest
}

// Send marshals and sends the DeleteSchema API request.
func (r DeleteSchemaRequest) Send(ctx context.Context) (*DeleteSchemaResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSchemaResponse{
		DeleteSchemaOutput: r.Request.Data.(*DeleteSchemaOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSchemaResponse is the response type for the
// DeleteSchema API operation.
type DeleteSchemaResponse struct {
	*DeleteSchemaOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSchema request.
func (r *DeleteSchemaResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
