// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StopDiscovererInput struct {
	_ struct{} `type:"structure"`

	// DiscovererId is a required field
	DiscovererId *string `location:"uri" locationName:"discovererId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDiscovererInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopDiscovererInput"}

	if s.DiscovererId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiscovererId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopDiscovererInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DiscovererId != nil {
		v := *s.DiscovererId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "discovererId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StopDiscovererOutput struct {
	_ struct{} `type:"structure"`

	DiscovererId *string `type:"string"`

	State DiscovererState `type:"string" enum:"true"`
}

// String returns the string representation
func (s StopDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StopDiscovererOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DiscovererId != nil {
		v := *s.DiscovererId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DiscovererId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opStopDiscoverer = "StopDiscoverer"

// StopDiscovererRequest returns a request value for making API operation for
// Schemas.
//
// Stops the discoverer
//
//    // Example sending a request using StopDiscovererRequest.
//    req := client.StopDiscovererRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer
func (c *Client) StopDiscovererRequest(input *StopDiscovererInput) StopDiscovererRequest {
	op := &aws.Operation{
		Name:       opStopDiscoverer,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discoverers/id/{discovererId}/stop",
	}

	if input == nil {
		input = &StopDiscovererInput{}
	}

	req := c.newRequest(op, input, &StopDiscovererOutput{})

	return StopDiscovererRequest{Request: req, Input: input, Copy: c.StopDiscovererRequest}
}

// StopDiscovererRequest is the request type for the
// StopDiscoverer API operation.
type StopDiscovererRequest struct {
	*aws.Request
	Input *StopDiscovererInput
	Copy  func(*StopDiscovererInput) StopDiscovererRequest
}

// Send marshals and sends the StopDiscoverer API request.
func (r StopDiscovererRequest) Send(ctx context.Context) (*StopDiscovererResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopDiscovererResponse{
		StopDiscovererOutput: r.Request.Data.(*StopDiscovererOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopDiscovererResponse is the response type for the
// StopDiscoverer API operation.
type StopDiscovererResponse struct {
	*StopDiscovererOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopDiscoverer request.
func (r *StopDiscovererResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
