// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package schemasiface provides an interface to enable mocking the Schemas service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package schemasiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/schemas"
)

// ClientAPI provides an interface to enable mocking the
// schemas.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Schemas.
//    func myFunc(svc schemasiface.ClientAPI) bool {
//        // Make svc.CreateDiscoverer request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := schemas.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        schemasiface.ClientPI
//    }
//    func (m *mockClientClient) CreateDiscoverer(input *schemas.CreateDiscovererInput) (*schemas.CreateDiscovererOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateDiscovererRequest(*schemas.CreateDiscovererInput) schemas.CreateDiscovererRequest

	CreateRegistryRequest(*schemas.CreateRegistryInput) schemas.CreateRegistryRequest

	CreateSchemaRequest(*schemas.CreateSchemaInput) schemas.CreateSchemaRequest

	DeleteDiscovererRequest(*schemas.DeleteDiscovererInput) schemas.DeleteDiscovererRequest

	DeleteRegistryRequest(*schemas.DeleteRegistryInput) schemas.DeleteRegistryRequest

	DeleteResourcePolicyRequest(*schemas.DeleteResourcePolicyInput) schemas.DeleteResourcePolicyRequest

	DeleteSchemaRequest(*schemas.DeleteSchemaInput) schemas.DeleteSchemaRequest

	DeleteSchemaVersionRequest(*schemas.DeleteSchemaVersionInput) schemas.DeleteSchemaVersionRequest

	DescribeCodeBindingRequest(*schemas.DescribeCodeBindingInput) schemas.DescribeCodeBindingRequest

	DescribeDiscovererRequest(*schemas.DescribeDiscovererInput) schemas.DescribeDiscovererRequest

	DescribeRegistryRequest(*schemas.DescribeRegistryInput) schemas.DescribeRegistryRequest

	DescribeSchemaRequest(*schemas.DescribeSchemaInput) schemas.DescribeSchemaRequest

	GetCodeBindingSourceRequest(*schemas.GetCodeBindingSourceInput) schemas.GetCodeBindingSourceRequest

	GetDiscoveredSchemaRequest(*schemas.GetDiscoveredSchemaInput) schemas.GetDiscoveredSchemaRequest

	GetResourcePolicyRequest(*schemas.GetResourcePolicyInput) schemas.GetResourcePolicyRequest

	ListDiscoverersRequest(*schemas.ListDiscoverersInput) schemas.ListDiscoverersRequest

	ListRegistriesRequest(*schemas.ListRegistriesInput) schemas.ListRegistriesRequest

	ListSchemaVersionsRequest(*schemas.ListSchemaVersionsInput) schemas.ListSchemaVersionsRequest

	ListSchemasRequest(*schemas.ListSchemasInput) schemas.ListSchemasRequest

	ListTagsForResourceRequest(*schemas.ListTagsForResourceInput) schemas.ListTagsForResourceRequest

	PutCodeBindingRequest(*schemas.PutCodeBindingInput) schemas.PutCodeBindingRequest

	PutResourcePolicyRequest(*schemas.PutResourcePolicyInput) schemas.PutResourcePolicyRequest

	SearchSchemasRequest(*schemas.SearchSchemasInput) schemas.SearchSchemasRequest

	StartDiscovererRequest(*schemas.StartDiscovererInput) schemas.StartDiscovererRequest

	StopDiscovererRequest(*schemas.StopDiscovererInput) schemas.StopDiscovererRequest

	TagResourceRequest(*schemas.TagResourceInput) schemas.TagResourceRequest

	UntagResourceRequest(*schemas.UntagResourceInput) schemas.UntagResourceRequest

	UpdateDiscovererRequest(*schemas.UpdateDiscovererInput) schemas.UpdateDiscovererRequest

	UpdateRegistryRequest(*schemas.UpdateRegistryInput) schemas.UpdateRegistryRequest

	UpdateSchemaRequest(*schemas.UpdateSchemaInput) schemas.UpdateSchemaRequest

	WaitUntilCodeBindingExists(context.Context, *schemas.DescribeCodeBindingInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*schemas.Client)(nil)
