// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeActionTargetsInput struct {
	_ struct{} `type:"structure"`

	// A list of custom action target ARNs for the custom action targets to retrieve.
	ActionTargetArns []string `type:"list"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeActionTargets
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActionTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeActionTargetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeActionTargetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ActionTargetArns != nil {
		v := s.ActionTargetArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ActionTargetArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeActionTargetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ActionTarget objects. Each object includes the ActionTargetArn,
	// Description, and Name of a custom action target available in Security Hub.
	//
	// ActionTargets is a required field
	ActionTargets []ActionTarget `type:"list" required:"true"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeActionTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeActionTargetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionTargets != nil {
		v := s.ActionTargets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ActionTargets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeActionTargets = "DescribeActionTargets"

// DescribeActionTargetsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Returns a list of the custom action targets in Security Hub in your account.
//
//    // Example sending a request using DescribeActionTargetsRequest.
//    req := client.DescribeActionTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets
func (c *Client) DescribeActionTargetsRequest(input *DescribeActionTargetsInput) DescribeActionTargetsRequest {
	op := &aws.Operation{
		Name:       opDescribeActionTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/actionTargets/get",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeActionTargetsInput{}
	}

	req := c.newRequest(op, input, &DescribeActionTargetsOutput{})

	return DescribeActionTargetsRequest{Request: req, Input: input, Copy: c.DescribeActionTargetsRequest}
}

// DescribeActionTargetsRequest is the request type for the
// DescribeActionTargets API operation.
type DescribeActionTargetsRequest struct {
	*aws.Request
	Input *DescribeActionTargetsInput
	Copy  func(*DescribeActionTargetsInput) DescribeActionTargetsRequest
}

// Send marshals and sends the DescribeActionTargets API request.
func (r DescribeActionTargetsRequest) Send(ctx context.Context) (*DescribeActionTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeActionTargetsResponse{
		DescribeActionTargetsOutput: r.Request.Data.(*DescribeActionTargetsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeActionTargetsRequestPaginator returns a paginator for DescribeActionTargets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeActionTargetsRequest(input)
//   p := securityhub.NewDescribeActionTargetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeActionTargetsPaginator(req DescribeActionTargetsRequest) DescribeActionTargetsPaginator {
	return DescribeActionTargetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeActionTargetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeActionTargetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeActionTargetsPaginator struct {
	aws.Pager
}

func (p *DescribeActionTargetsPaginator) CurrentPage() *DescribeActionTargetsOutput {
	return p.Pager.CurrentPage().(*DescribeActionTargetsOutput)
}

// DescribeActionTargetsResponse is the response type for the
// DescribeActionTargets API operation.
type DescribeActionTargetsResponse struct {
	*DescribeActionTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeActionTargets request.
func (r *DescribeActionTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
