// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeProductsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The token that is required for pagination. On your first call to the DescribeProducts
	// operation, set the value of this parameter to NULL.
	//
	// For subsequent calls to the operation, to continue listing data, set the
	// value of this parameter to the value returned from the previous response.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s DescribeProductsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProductsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProductsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProductsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeProductsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to request the next page of results.
	NextToken *string `type:"string"`

	// A list of products, including details for each product.
	//
	// Products is a required field
	Products []Product `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeProductsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Products != nil {
		v := s.Products

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Products", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeProducts = "DescribeProducts"

// DescribeProductsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Returns information about the available products that you can subscribe to
// and integrate with Security Hub in order to consolidate findings.
//
//    // Example sending a request using DescribeProductsRequest.
//    req := client.DescribeProductsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts
func (c *Client) DescribeProductsRequest(input *DescribeProductsInput) DescribeProductsRequest {
	op := &aws.Operation{
		Name:       opDescribeProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/products",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProductsInput{}
	}

	req := c.newRequest(op, input, &DescribeProductsOutput{})

	return DescribeProductsRequest{Request: req, Input: input, Copy: c.DescribeProductsRequest}
}

// DescribeProductsRequest is the request type for the
// DescribeProducts API operation.
type DescribeProductsRequest struct {
	*aws.Request
	Input *DescribeProductsInput
	Copy  func(*DescribeProductsInput) DescribeProductsRequest
}

// Send marshals and sends the DescribeProducts API request.
func (r DescribeProductsRequest) Send(ctx context.Context) (*DescribeProductsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProductsResponse{
		DescribeProductsOutput: r.Request.Data.(*DescribeProductsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeProductsRequestPaginator returns a paginator for DescribeProducts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeProductsRequest(input)
//   p := securityhub.NewDescribeProductsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeProductsPaginator(req DescribeProductsRequest) DescribeProductsPaginator {
	return DescribeProductsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeProductsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeProductsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeProductsPaginator struct {
	aws.Pager
}

func (p *DescribeProductsPaginator) CurrentPage() *DescribeProductsOutput {
	return p.Pager.CurrentPage().(*DescribeProductsOutput)
}

// DescribeProductsResponse is the response type for the
// DescribeProducts API operation.
type DescribeProductsResponse struct {
	*DescribeProductsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProducts request.
func (r *DescribeProductsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
