// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateStandardsControlInput struct {
	_ struct{} `type:"structure"`

	// The updated status of the security standard control.
	ControlStatus ControlStatus `type:"string" enum:"true"`

	// A description of the reason why you are disabling a security standard control.
	// If you are disabling a control, then this is required.
	DisabledReason *string `type:"string"`

	// The ARN of the security standard control to enable or disable.
	//
	// StandardsControlArn is a required field
	StandardsControlArn *string `location:"uri" locationName:"StandardsControlArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateStandardsControlInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStandardsControlInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStandardsControlInput"}

	if s.StandardsControlArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StandardsControlArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStandardsControlInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.ControlStatus) > 0 {
		v := s.ControlStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ControlStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DisabledReason != nil {
		v := *s.DisabledReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisabledReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StandardsControlArn != nil {
		v := *s.StandardsControlArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "StandardsControlArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateStandardsControlOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStandardsControlOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStandardsControlOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateStandardsControl = "UpdateStandardsControl"

// UpdateStandardsControlRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Used to control whether an individual security standard control is enabled
// or disabled.
//
//    // Example sending a request using UpdateStandardsControlRequest.
//    req := client.UpdateStandardsControlRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl
func (c *Client) UpdateStandardsControlRequest(input *UpdateStandardsControlInput) UpdateStandardsControlRequest {
	op := &aws.Operation{
		Name:       opUpdateStandardsControl,
		HTTPMethod: "PATCH",
		HTTPPath:   "/standards/control/{StandardsControlArn+}",
	}

	if input == nil {
		input = &UpdateStandardsControlInput{}
	}

	req := c.newRequest(op, input, &UpdateStandardsControlOutput{})

	return UpdateStandardsControlRequest{Request: req, Input: input, Copy: c.UpdateStandardsControlRequest}
}

// UpdateStandardsControlRequest is the request type for the
// UpdateStandardsControl API operation.
type UpdateStandardsControlRequest struct {
	*aws.Request
	Input *UpdateStandardsControlInput
	Copy  func(*UpdateStandardsControlInput) UpdateStandardsControlRequest
}

// Send marshals and sends the UpdateStandardsControl API request.
func (r UpdateStandardsControlRequest) Send(ctx context.Context) (*UpdateStandardsControlResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateStandardsControlResponse{
		UpdateStandardsControlOutput: r.Request.Data.(*UpdateStandardsControlOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateStandardsControlResponse is the response type for the
// UpdateStandardsControl API operation.
type UpdateStandardsControlResponse struct {
	*UpdateStandardsControlOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateStandardsControl request.
func (r *UpdateStandardsControlResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
