// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The details of an AWS account.
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account.
	AccountId *string `type:"string"`

	// The email of an AWS account.
	Email *string `type:"string"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An ActionTarget object.
type ActionTarget struct {
	_ struct{} `type:"structure"`

	// The ARN for the target action.
	//
	// ActionTargetArn is a required field
	ActionTargetArn *string `type:"string" required:"true"`

	// The description of the target action.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the action target.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ActionTarget) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ActionTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionTargetArn != nil {
		v := *s.ActionTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ActionTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The ID of the subnet. You can specify one subnet per Availability Zone.
	SubnetId *string `type:"string"`

	// The name of the Availability Zone.
	ZoneName *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AvailabilityZone) MarshalFields(e protocol.FieldEncoder) error {
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZoneName != nil {
		v := *s.ZoneName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZoneName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides details about an auto scaling group.
type AwsAutoScalingAutoScalingGroupDetails struct {
	_ struct{} `type:"structure"`

	// The datetime when the auto scaling group was created.
	CreatedTime *string `type:"string"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// it checks the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks.
	HealthCheckType *string `type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `type:"string"`

	// The list of load balancers associated with the group.
	LoadBalancerNames []string `type:"list"`
}

// String returns the string representation
func (s AwsAutoScalingAutoScalingGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsAutoScalingAutoScalingGroupDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HealthCheckGracePeriod != nil {
		v := *s.HealthCheckGracePeriod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HealthCheckGracePeriod", protocol.Int64Value(v), metadata)
	}
	if s.HealthCheckType != nil {
		v := *s.HealthCheckType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HealthCheckType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchConfigurationName != nil {
		v := *s.LaunchConfigurationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchConfigurationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LoadBalancerNames != nil {
		v := s.LoadBalancerNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LoadBalancerNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// A distribution configuration.
type AwsCloudFrontDistributionDetails struct {
	_ struct{} `type:"structure"`

	// The domain name corresponding to the distribution.
	DomainName *string `type:"string"`

	// The entity tag is a hash of the object.
	ETag *string `type:"string"`

	// The date and time that the distribution was last modified.
	LastModifiedTime *string `type:"string"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *AwsCloudFrontDistributionLogging `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *AwsCloudFrontDistributionOrigins `type:"structure"`

	// Indicates the current status of the distribution.
	Status *string `type:"string"`

	// A unique identifier that specifies the AWS WAF web ACL, if any, to associate
	// with this distribution.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudFrontDistributionDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedTime != nil {
		v := *s.LastModifiedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Logging", v, metadata)
	}
	if s.Origins != nil {
		v := s.Origins

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Origins", v, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebAclId != nil {
		v := *s.WebAclId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebAclId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A complex type that controls whether access logs are written for the distribution.
type AwsCloudFrontDistributionLogging struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in.
	Bucket *string `type:"string"`

	// With this field, you can enable or disable the selected distribution.
	Enabled *bool `type:"boolean"`

	// Specifies whether you want CloudFront to include cookies in access logs.
	IncludeCookies *bool `type:"boolean"`

	// An optional string that you want CloudFront to use as a prefix to the access
	// log filenames for this distribution.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionLogging) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudFrontDistributionLogging) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.IncludeCookies != nil {
		v := *s.IncludeCookies

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IncludeCookies", protocol.BoolValue(v), metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A complex type that describes the Amazon S3 bucket, HTTP server (for example,
// a web server), Amazon Elemental MediaStore, or other server from which CloudFront
// gets your files.
type AwsCloudFrontDistributionOriginItem struct {
	_ struct{} `type:"structure"`

	// Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want
	// CloudFront to get objects for this origin.
	DomainName *string `type:"string"`

	// A unique identifier for the origin or origin group.
	Id *string `type:"string"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin.
	OriginPath *string `type:"string"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOriginItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudFrontDistributionOriginItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OriginPath != nil {
		v := *s.OriginPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OriginPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A complex type that contains information about origins and origin groups
// for this distribution.
type AwsCloudFrontDistributionOrigins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins or origin groups for this distribution.
	Items []AwsCloudFrontDistributionOriginItem `type:"list"`
}

// String returns the string representation
func (s AwsCloudFrontDistributionOrigins) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCloudFrontDistributionOrigins) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about an AWS CodeBuild project.
type AwsCodeBuildProjectDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) customer master key (CMK) used to
	// encrypt the build output artifacts.
	//
	// You can specify either the Amazon Resource Name (ARN) of the CMK or, if available,
	// the CMK alias (using the format alias/alias-name).
	EncryptionKey *string `type:"string"`

	// Information about the build environment for this build project.
	Environment *AwsCodeBuildProjectEnvironment `type:"structure"`

	// The name of the build project.
	Name *string `type:"string"`

	// The ARN of the IAM role that enables AWS CodeBuild to interact with dependent
	// AWS services on behalf of the AWS account.
	ServiceRole *string `type:"string"`

	// Information about the build input source code for this build project.
	Source *AwsCodeBuildProjectSource `type:"structure"`

	// Information about the VPC configuration that AWS CodeBuild accesses.
	VpcConfig *AwsCodeBuildProjectVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsCodeBuildProjectDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCodeBuildProjectDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.EncryptionKey != nil {
		v := *s.EncryptionKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncryptionKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceRole != nil {
		v := *s.ServiceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServiceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Source", v, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// Information about the build environment for this build project.
type AwsCodeBuildProjectEnvironment struct {
	_ struct{} `type:"structure"`

	// The certificate to use with this build project.
	Certificate *string `type:"string"`

	// The type of credentials AWS CodeBuild uses to pull images in your build.
	//
	// Valid values:
	//
	//    * CODEBUILD specifies that AWS CodeBuild uses its own credentials. This
	//    requires that you modify your ECR repository policy to trust the AWS CodeBuild
	//    service principal.
	//
	//    * SERVICE_ROLE specifies that AWS CodeBuild uses your build project's
	//    service role.
	//
	// When you use a cross-account or private registry image, you must use SERVICE_ROLE
	// credentials. When you use an AWS CodeBuild curated image, you must use CODEBUILD
	// credentials.
	ImagePullCredentialsType *string `type:"string"`

	// The credentials for access to a private registry.
	RegistryCredential *AwsCodeBuildProjectEnvironmentRegistryCredential `type:"structure"`

	// The type of build environment to use for related builds.
	//
	// The environment type ARM_CONTAINER is available only in Regions US East (N.
	// Virginia), US East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific
	// (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and Europe (Frankfurt).
	//
	// The environment type LINUX_CONTAINER with compute type build.general1.2xlarge
	// is available only in Regions US East (N. Virginia), US East (N. Virginia),
	// US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
	// (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
	// Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
	//
	// The environment type LINUX_GPU_CONTAINER is available only in Regions US
	// East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central),
	// Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo),
	// Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China
	// (Beijing), and China (Ningxia).
	//
	// Valid values: WINDOWS_CONTAINER | LINUX_CONTAINER | LINUX_GPU_CONTAINER |
	// ARM_CONTAINER
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCodeBuildProjectEnvironment) MarshalFields(e protocol.FieldEncoder) error {
	if s.Certificate != nil {
		v := *s.Certificate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Certificate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImagePullCredentialsType != nil {
		v := *s.ImagePullCredentialsType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImagePullCredentialsType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryCredential != nil {
		v := s.RegistryCredential

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RegistryCredential", v, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The credentials for access to a private registry.
type AwsCodeBuildProjectEnvironmentRegistryCredential struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) or name of credentials created using AWS Secrets
	// Manager.
	//
	// The credential can use the name of the credentials only if they exist in
	// your current AWS Region.
	Credential *string `type:"string"`

	// The service that created the credentials to access a private Docker registry.
	//
	// The valid value,SECRETS_MANAGER, is for AWS Secrets Manager.
	CredentialProvider *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCodeBuildProjectEnvironmentRegistryCredential) MarshalFields(e protocol.FieldEncoder) error {
	if s.Credential != nil {
		v := *s.Credential

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Credential", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CredentialProvider != nil {
		v := *s.CredentialProvider

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CredentialProvider", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the build input source code for this build project.
type AwsCodeBuildProjectSource struct {
	_ struct{} `type:"structure"`

	// Information about the Git clone depth for the build project.
	GitCloneDepth *int64 `type:"integer"`

	// Whether to ignore SSL warnings while connecting to the project source code.
	InsecureSsl *bool `type:"boolean"`

	// Information about the location of the source code to be built.
	//
	// Valid values include:
	//
	//    * For source code settings that are specified in the source action of
	//    a pipeline in AWS CodePipeline, location should not be specified. If it
	//    is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
	//    uses the settings in a pipeline's source action instead of this value.
	//
	//    * For source code in an AWS CodeCommit repository, the HTTPS clone URL
	//    to the repository that contains the source code and the build spec file
	//    (for example, https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name
	//    ).
	//
	//    * For source code in an S3 input bucket, one of the following. The path
	//    to the ZIP file that contains the source code (for example, bucket-name/path/to/object-name.zip).
	//    The path to the folder that contains the source code (for example, bucket-name/path/to/source-code/folder/).
	//
	//    * For source code in a GitHub repository, the HTTPS clone URL to the repository
	//    that contains the source and the build spec file.
	//
	//    * For source code in a Bitbucket repository, the HTTPS clone URL to the
	//    repository that contains the source and the build spec file.
	Location *string `type:"string"`

	// The type of repository that contains the source code to be built. Valid values
	// are:
	//
	//    * BITBUCKET - The source code is in a Bitbucket repository.
	//
	//    * CODECOMMIT - The source code is in an AWS CodeCommit repository.
	//
	//    * CODEPIPELINE - The source code settings are specified in the source
	//    action of a pipeline in AWS CodePipeline.
	//
	//    * GITHUB - The source code is in a GitHub repository.
	//
	//    * GITHUB_ENTERPRISE - The source code is in a GitHub Enterprise repository.
	//
	//    * NO_SOURCE - The project does not have input source code.
	//
	//    * S3 - The source code is in an S3 input bucket.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectSource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCodeBuildProjectSource) MarshalFields(e protocol.FieldEncoder) error {
	if s.GitCloneDepth != nil {
		v := *s.GitCloneDepth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GitCloneDepth", protocol.Int64Value(v), metadata)
	}
	if s.InsecureSsl != nil {
		v := *s.InsecureSsl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsecureSsl", protocol.BoolValue(v), metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the VPC configuration that AWS CodeBuild accesses.
type AwsCodeBuildProjectVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security group IDs in your Amazon VPC.
	SecurityGroupIds []string `type:"list"`

	// A list of one or more subnet IDs in your Amazon VPC.
	Subnets []string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsCodeBuildProjectVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsCodeBuildProjectVpcConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Subnets != nil {
		v := s.Subnets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Subnets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of an Amazon EC2 instance.
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// The date/time the instance was launched.
	LaunchedAt *string `type:"string"`

	// The identifier of the subnet that the instance was launched in.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC that the instance was launched in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2InstanceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.IamInstanceProfileArn != nil {
		v := *s.IamInstanceProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamInstanceProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpV4Addresses != nil {
		v := s.IpV4Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpV4Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.IpV6Addresses != nil {
		v := s.IpV6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpV6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.KeyName != nil {
		v := *s.KeyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the network interface attachment.
type AwsEc2NetworkInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The timestamp indicating when the attachment initiated.
	AttachTime *string `type:"string"`

	// The identifier of the network interface attachment
	AttachmentId *string `type:"string"`

	// Indicates whether the network interface is deleted when the instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The device index of the network interface attachment on the instance.
	DeviceIndex *int64 `type:"integer"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// The AWS account ID of the owner of the instance.
	InstanceOwnerId *string `type:"string"`

	// The attachment state.
	//
	// Valid values: attaching | attached | detaching | detached
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2NetworkInterfaceAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachTime != nil {
		v := *s.AttachTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttachTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AttachmentId != nil {
		v := *s.AttachmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttachmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeleteOnTermination != nil {
		v := *s.DeleteOnTermination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteOnTermination", protocol.BoolValue(v), metadata)
	}
	if s.DeviceIndex != nil {
		v := *s.DeviceIndex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceIndex", protocol.Int64Value(v), metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceOwnerId != nil {
		v := *s.InstanceOwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceOwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the network interface
type AwsEc2NetworkInterfaceDetails struct {
	_ struct{} `type:"structure"`

	// The network interface attachment.
	Attachment *AwsEc2NetworkInterfaceAttachment `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `type:"string"`

	// Security groups for the network interface.
	SecurityGroups []AwsEc2NetworkInterfaceSecurityGroup `type:"list"`

	// Indicates whether traffic to or from the instance is validated.
	SourceDestCheck *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2NetworkInterfaceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attachment != nil {
		v := s.Attachment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Attachment", v, metadata)
	}
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NetworkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceDestCheck != nil {
		v := *s.SourceDestCheck

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceDestCheck", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A security group associated with the network interface.
type AwsEc2NetworkInterfaceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2NetworkInterfaceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2NetworkInterfaceSecurityGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about an EC2 security group.
type AwsEc2SecurityGroupDetails struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The inbound rules associated with the security group.
	IpPermissions []AwsEc2SecurityGroupIpPermission `type:"list"`

	// [VPC only] The outbound rules associated with the security group.
	IpPermissionsEgress []AwsEc2SecurityGroupIpPermission `type:"list"`

	// The AWS account ID of the owner of the security group.
	OwnerId *string `type:"string"`

	// [VPC only] The ID of the VPC for the security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpPermissions != nil {
		v := s.IpPermissions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpPermissions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.IpPermissionsEgress != nil {
		v := s.IpPermissionsEgress

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpPermissionsEgress", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An IP permission for an EC2 security group.
type AwsEc2SecurityGroupIpPermission struct {
	_ struct{} `type:"structure"`

	// The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// type number.
	//
	// A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	FromPort *int64 `type:"integer"`

	// The IP protocol name (tcp, udp, icmp, icmpv6) or number.
	//
	// [VPC only] Use -1 to specify all protocols.
	//
	// When authorizing security group rules, specifying -1 or a protocol number
	// other than tcp, udp, icmp, or icmpv6 allows traffic on all ports, regardless
	// of any port range you specify.
	//
	// For tcp, udp, and icmp, you must specify a port range.
	//
	// For icmpv6, the port range is optional. If you omit the port range, traffic
	// for all types and codes is allowed.
	IpProtocol *string `type:"string"`

	// The IPv4 ranges.
	IpRanges []AwsEc2SecurityGroupIpRange `type:"list"`

	// The IPv6 ranges.
	Ipv6Ranges []AwsEc2SecurityGroupIpv6Range `type:"list"`

	// [VPC only] The prefix list IDs for an AWS service. With outbound rules, this
	// is the AWS service to access through a VPC endpoint from instances associated
	// with the security group.
	PrefixListIds []AwsEc2SecurityGroupPrefixListId `type:"list"`

	// The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6
	// code.
	//
	// A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6
	// types, you must specify all codes.
	ToPort *int64 `type:"integer"`

	// The security group and AWS account ID pairs.
	UserIdGroupPairs []AwsEc2SecurityGroupUserIdGroupPair `type:"list"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpPermission) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupIpPermission) MarshalFields(e protocol.FieldEncoder) error {
	if s.FromPort != nil {
		v := *s.FromPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FromPort", protocol.Int64Value(v), metadata)
	}
	if s.IpProtocol != nil {
		v := *s.IpProtocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IpProtocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpRanges != nil {
		v := s.IpRanges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpRanges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Ipv6Ranges != nil {
		v := s.Ipv6Ranges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Ipv6Ranges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PrefixListIds != nil {
		v := s.PrefixListIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PrefixListIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ToPort != nil {
		v := *s.ToPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ToPort", protocol.Int64Value(v), metadata)
	}
	if s.UserIdGroupPairs != nil {
		v := s.UserIdGroupPairs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UserIdGroupPairs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A range of IPv4 addresses.
type AwsEc2SecurityGroupIpRange struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv4 address, use the /32 prefix
	// length.
	CidrIp *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupIpRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.CidrIp != nil {
		v := *s.CidrIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CidrIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A range of IPv6 addresses.
type AwsEc2SecurityGroupIpv6Range struct {
	_ struct{} `type:"structure"`

	// The IPv6 CIDR range. You can specify either a CIDR range or a source security
	// group, but not both. To specify a single IPv6 address, use the /128 prefix
	// length.
	CidrIpv6 *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupIpv6Range) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupIpv6Range) MarshalFields(e protocol.FieldEncoder) error {
	if s.CidrIpv6 != nil {
		v := *s.CidrIpv6

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CidrIpv6", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A prefix list ID.
type AwsEc2SecurityGroupPrefixListId struct {
	_ struct{} `type:"structure"`

	// The ID of the prefix.
	PrefixListId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupPrefixListId) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupPrefixListId) MarshalFields(e protocol.FieldEncoder) error {
	if s.PrefixListId != nil {
		v := *s.PrefixListId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrefixListId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A relationship between a security group and a user.
type AwsEc2SecurityGroupUserIdGroupPair struct {
	_ struct{} `type:"structure"`

	// The ID of the security group.
	GroupId *string `type:"string"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The status of a VPC peering connection, if applicable.
	PeeringStatus *string `type:"string"`

	// The ID of an AWS account.
	//
	// For a referenced security group in another VPC, the account ID of the referenced
	// security group is returned in the response. If the referenced security group
	// is deleted, this value is not returned.
	//
	// [EC2-Classic] Required when adding or removing rules that reference a security
	// group in another AWS.
	UserId *string `type:"string"`

	// The ID of the VPC for the referenced security group, if applicable.
	VpcId *string `type:"string"`

	// The ID of the VPC peering connection, if applicable.
	VpcPeeringConnectionId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2SecurityGroupUserIdGroupPair) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2SecurityGroupUserIdGroupPair) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PeeringStatus != nil {
		v := *s.PeeringStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PeeringStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcPeeringConnectionId != nil {
		v := *s.VpcPeeringConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcPeeringConnectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An attachment to an AWS EC2 volume.
type AwsEc2VolumeAttachment struct {
	_ struct{} `type:"structure"`

	// The datetime when the attachment initiated.
	AttachTime *string `type:"string"`

	// Whether the EBS volume is deleted when the EC2 instance is terminated.
	DeleteOnTermination *bool `type:"boolean"`

	// The identifier of the EC2 instance.
	InstanceId *string `type:"string"`

	// The attachment state of the volume.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VolumeAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2VolumeAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachTime != nil {
		v := *s.AttachTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttachTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeleteOnTermination != nil {
		v := *s.DeleteOnTermination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeleteOnTermination", protocol.BoolValue(v), metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about an EC2 volume.
type AwsEc2VolumeDetails struct {
	_ struct{} `type:"structure"`

	// The volume attachments.
	Attachments []AwsEc2VolumeAttachment `type:"list"`

	// The datetime when the volume was created.
	CreateTime *string `type:"string"`

	// Whether the volume is encrypted.
	Encrypted *bool `type:"boolean"`

	// The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK)
	// that was used to protect the volume encryption key for the volume.
	KmsKeyId *string `type:"string"`

	// The size of the volume, in GiBs.
	Size *int64 `type:"integer"`

	// The snapshot from which the volume was created.
	SnapshotId *string `type:"string"`

	// The volume state.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VolumeDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2VolumeDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attachments != nil {
		v := s.Attachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Attachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreateTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encrypted != nil {
		v := *s.Encrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Encrypted", protocol.BoolValue(v), metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Size", protocol.Int64Value(v), metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SnapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about an EC2 VPC.
type AwsEc2VpcDetails struct {
	_ struct{} `type:"structure"`

	// Information about the IPv4 CIDR blocks associated with the VPC.
	CidrBlockAssociationSet []CidrBlockAssociation `type:"list"`

	// The identifier of the set of Dynamic Host Configuration Protocol (DHCP) options
	// that are associated with the VPC. If the default options are associated with
	// the VPC, then this is default.
	DhcpOptionsId *string `type:"string"`

	// Information about the IPv6 CIDR blocks associated with the VPC.
	Ipv6CidrBlockAssociationSet []Ipv6CidrBlockAssociation `type:"list"`

	// The current state of the VPC.
	State *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2VpcDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2VpcDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CidrBlockAssociationSet != nil {
		v := s.CidrBlockAssociationSet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CidrBlockAssociationSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DhcpOptionsId != nil {
		v := *s.DhcpOptionsId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DhcpOptionsId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ipv6CidrBlockAssociationSet != nil {
		v := s.Ipv6CidrBlockAssociationSet

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Ipv6CidrBlockAssociationSet", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about an Elasticsearch domain.
type AwsElasticsearchDomainDetails struct {
	_ struct{} `type:"structure"`

	// IAM policy document specifying the access policies for the new Amazon ES
	// domain.
	AccessPolicies *string `type:"string"`

	// Additional options for the domain endpoint.
	DomainEndpointOptions *AwsElasticsearchDomainDomainEndpointOptions `type:"structure"`

	// Unique identifier for an Amazon ES domain.
	DomainId *string `type:"string"`

	// Name of an Amazon ES domain.
	//
	// Domain names are unique across all domains owned by the same account within
	// an AWS Region.
	//
	// Domain names must start with a lowercase letter and must be between 3 and
	// 28 characters.
	//
	// Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
	DomainName *string `type:"string"`

	// Elasticsearch version.
	ElasticsearchVersion *string `type:"string"`

	// Details about the configuration for encryption at rest.
	EncryptionAtRestOptions *AwsElasticsearchDomainEncryptionAtRestOptions `type:"structure"`

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to an Amazon ES domain.
	//
	// The endpoint is a service URL.
	Endpoint *string `type:"string"`

	// The key-value pair that exists if the Amazon ES domain uses VPC endpoints.
	Endpoints map[string]string `type:"map"`

	// Details about the configuration for node-to-node encryption.
	NodeToNodeEncryptionOptions *AwsElasticsearchDomainNodeToNodeEncryptionOptions `type:"structure"`

	// Information that Amazon ES derives based on VPCOptions for the domain.
	VPCOptions *AwsElasticsearchDomainVPCOptions `type:"structure"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElasticsearchDomainDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPolicies != nil {
		v := *s.AccessPolicies

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessPolicies", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainEndpointOptions != nil {
		v := s.DomainEndpointOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainEndpointOptions", v, metadata)
	}
	if s.DomainId != nil {
		v := *s.DomainId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ElasticsearchVersion != nil {
		v := *s.ElasticsearchVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ElasticsearchVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EncryptionAtRestOptions != nil {
		v := s.EncryptionAtRestOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EncryptionAtRestOptions", v, metadata)
	}
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Endpoints != nil {
		v := s.Endpoints

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Endpoints", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.NodeToNodeEncryptionOptions != nil {
		v := s.NodeToNodeEncryptionOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NodeToNodeEncryptionOptions", v, metadata)
	}
	if s.VPCOptions != nil {
		v := s.VPCOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VPCOptions", v, metadata)
	}
	return nil
}

// Additional options for the domain endpoint, such as whether to require HTTPS
// for all traffic.
type AwsElasticsearchDomainDomainEndpointOptions struct {
	_ struct{} `type:"structure"`

	// Whether to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool `type:"boolean"`

	// The TLS security policy to apply to the HTTPS endpoint of the Elasticsearch
	// domain.
	//
	// Valid values:
	//
	//    * Policy-Min-TLS-1-0-2019-07, which supports TLSv1.0 and higher
	//
	//    * Policy-Min-TLS-1-2-2019-07, which only supports TLSv1.2
	TLSSecurityPolicy *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainDomainEndpointOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElasticsearchDomainDomainEndpointOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.EnforceHTTPS != nil {
		v := *s.EnforceHTTPS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnforceHTTPS", protocol.BoolValue(v), metadata)
	}
	if s.TLSSecurityPolicy != nil {
		v := *s.TLSSecurityPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TLSSecurityPolicy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the configuration for encryption at rest.
type AwsElasticsearchDomainEncryptionAtRestOptions struct {
	_ struct{} `type:"structure"`

	// Whether encryption at rest is enabled.
	Enabled *bool `type:"boolean"`

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a.
	KmsKeyId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainEncryptionAtRestOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElasticsearchDomainEncryptionAtRestOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the configuration for node-to-node encryption.
type AwsElasticsearchDomainNodeToNodeEncryptionOptions struct {
	_ struct{} `type:"structure"`

	// Whether node-to-node encryption is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElasticsearchDomainNodeToNodeEncryptionOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Enabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information that Amazon ES derives based on VPCOptions for the domain.
type AwsElasticsearchDomainVPCOptions struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []string `type:"list"`

	// The list of security group IDs associated with the VPC endpoints for the
	// domain.
	SecurityGroupIds []string `type:"list"`

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []string `type:"list"`

	// ID for the VPC.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s AwsElasticsearchDomainVPCOptions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElasticsearchDomainVPCOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AvailabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VPCId != nil {
		v := *s.VPCId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VPCId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a load balancer.
type AwsElbv2LoadBalancerDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []AvailabilityZone `type:"list"`

	// The ID of the Amazon Route 53 hosted zone associated with the load balancer.
	CanonicalHostedZoneId *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *string `type:"string"`

	// The public DNS name of the load balancer.
	DNSName *string `type:"string"`

	// The type of IP addresses used by the subnets for your load balancer. The
	// possible values are ipv4 (for IPv4 addresses) and dualstack (for IPv4 and
	// IPv6 addresses).
	IpAddressType *string `type:"string"`

	// The nodes of an Internet-facing load balancer have public IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups for the load balancer.
	SecurityGroups []string `type:"list"`

	// The state of the load balancer.
	State *LoadBalancerState `type:"structure"`

	// The type of load balancer.
	Type *string `type:"string"`

	// The ID of the VPC for the load balancer.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsElbv2LoadBalancerDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsElbv2LoadBalancerDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZones != nil {
		v := s.AvailabilityZones

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AvailabilityZones", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CanonicalHostedZoneId != nil {
		v := *s.CanonicalHostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CanonicalHostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DNSName != nil {
		v := *s.DNSName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DNSName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IpAddressType != nil {
		v := *s.IpAddressType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IpAddressType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Scheme != nil {
		v := *s.Scheme

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Scheme", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "State", v, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// IAM access key details related to a finding.
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The creation date/time of the IAM access key related to a finding.
	CreatedAt *string `type:"string"`

	// The ID of the principal associated with an access key.
	PrincipalId *string `type:"string"`

	// The name of the principal.
	PrincipalName *string `type:"string"`

	// The type of principal associated with an access key.
	PrincipalType *string `type:"string"`

	// The status of the IAM access key related to a finding.
	Status AwsIamAccessKeyStatus `type:"string" enum:"true"`

	// The user associated with the IAM access key related to a finding.
	//
	// The UserName parameter has been replaced with the PrincipalName parameter
	// because access keys can also be assigned to principals that are not IAM users.
	UserName *string `deprecated:"true" type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsIamAccessKeyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalName != nil {
		v := *s.PrincipalName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalType != nil {
		v := *s.PrincipalType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrincipalType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about an IAM role, including all of the role's policies.
type AwsIamRoleDetails struct {
	_ struct{} `type:"structure"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format, when the role was created.
	CreateDate *string `type:"string"`

	// The maximum session duration (in seconds) that you want to set for the specified
	// role.
	MaxSessionDuration *int64 `type:"integer"`

	// The path to the role.
	Path *string `type:"string"`

	// The stable and unique string identifying the role.
	RoleId *string `type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamRoleDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsIamRoleDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsIamRoleDetails"}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsIamRoleDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssumeRolePolicyDocument != nil {
		v := *s.AssumeRolePolicyDocument

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssumeRolePolicyDocument", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreateDate != nil {
		v := *s.CreateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreateDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxSessionDuration != nil {
		v := *s.MaxSessionDuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxSessionDuration", protocol.Int64Value(v), metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleId != nil {
		v := *s.RoleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleName != nil {
		v := *s.RoleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains metadata about a customer master key (CMK).
type AwsKmsKeyDetails struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the AWS account that owns the CMK.
	AWSAccountId *string `type:"string"`

	// The date and time when the CMK was created.
	CreationDate *float64 `type:"double"`

	// The globally unique identifier for the CMK.
	KeyId *string `type:"string"`

	// The manager of the CMK. CMKs in your AWS account are either customer managed
	// or AWS managed.
	KeyManager *string `type:"string"`

	// The state of the CMK.
	KeyState *string `type:"string"`

	// The source of the CMK's key material.
	//
	// When this value is AWS_KMS, AWS KMS created the key material.
	//
	// When this value is EXTERNAL, the key material was imported from your existing
	// key management infrastructure or the CMK lacks key material.
	//
	// When this value is AWS_CLOUDHSM, the key material was created in the AWS
	// CloudHSM cluster associated with a custom key store.
	Origin *string `type:"string"`
}

// String returns the string representation
func (s AwsKmsKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsKmsKeyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AWSAccountId != nil {
		v := *s.AWSAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AWSAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.Float64Value(v), metadata)
	}
	if s.KeyId != nil {
		v := *s.KeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyManager != nil {
		v := *s.KeyManager

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyManager", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyState != nil {
		v := *s.KeyState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Origin != nil {
		v := *s.Origin

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Origin", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type AwsLambdaFunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	ZipFile *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionCode) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionCode) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Bucket != nil {
		v := *s.S3Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Key != nil {
		v := *s.S3Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3ObjectVersion != nil {
		v := *s.S3ObjectVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3ObjectVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ZipFile != nil {
		v := *s.ZipFile

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ZipFile", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The dead-letter queue for failed asynchronous invocations.
type AwsLambdaFunctionDeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionDeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionDeadLetterConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.TargetArn != nil {
		v := *s.TargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a function's configuration.
type AwsLambdaFunctionDetails struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionCode object.
	Code *AwsLambdaFunctionCode `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The function's dead letter queue.
	DeadLetterConfig *AwsLambdaFunctionDeadLetterConfig `type:"structure"`

	// The function's environment variables.
	Environment *AwsLambdaFunctionEnvironment `type:"structure"`

	// The name of the function.
	FunctionName *string `type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that's used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer managed CMK.
	KmsKeyArn *string `type:"string"`

	// The date and time that the function was last updated, in ISO-8601 format
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string `type:"string"`

	// The function's layers.
	Layers []AwsLambdaFunctionLayer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that's allocated to the function.
	MemorySize *int64 `type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string"`

	// The amount of time that Lambda allows a function to run before stopping it.
	Timeout *int64 `type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *AwsLambdaFunctionTracingConfig `type:"structure"`

	// The version of the Lambda function.
	Version *string `type:"string"`

	// The function's networking configuration.
	VpcConfig *AwsLambdaFunctionVpcConfig `type:"structure"`
}

// String returns the string representation
func (s AwsLambdaFunctionDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Code", v, metadata)
	}
	if s.CodeSha256 != nil {
		v := *s.CodeSha256

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSha256", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeadLetterConfig != nil {
		v := s.DeadLetterConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DeadLetterConfig", v, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Handler != nil {
		v := *s.Handler

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Handler", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Layers != nil {
		v := s.Layers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Layers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MasterArn != nil {
		v := *s.MasterArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MasterArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Role != nil {
		v := *s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Runtime != nil {
		v := *s.Runtime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Runtime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	if s.TracingConfig != nil {
		v := s.TracingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TracingConfig", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

// A function's environment variable settings.
type AwsLambdaFunctionEnvironment struct {
	_ struct{} `type:"structure"`

	// An AwsLambdaFunctionEnvironmentError object.
	Error *AwsLambdaFunctionEnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionEnvironment) MarshalFields(e protocol.FieldEncoder) error {
	if s.Error != nil {
		v := s.Error

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Error", v, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Error messages for environment variables that couldn't be applied.
type AwsLambdaFunctionEnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionEnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionEnvironmentError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An AWS Lambda layer.
type AwsLambdaFunctionLayer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsLambdaFunctionLayer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionLayer) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CodeSize != nil {
		v := *s.CodeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CodeSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The function's AWS X-Ray tracing configuration.
type AwsLambdaFunctionTracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionTracingConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionTracingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Mode != nil {
		v := *s.Mode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Mode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The VPC security groups and subnets that are attached to a Lambda function.
// For more information, see VPC Settings.
type AwsLambdaFunctionVpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsLambdaFunctionVpcConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaFunctionVpcConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SubnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a Lambda layer version.
type AwsLambdaLayerVersionDetails struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes. Maximum number of five items.
	//
	// Valid values: nodejs10.x | nodejs12.x | java8 | java11 | python2.7 | python3.6
	// | python3.7 | python3.8 | dotnetcore1.0 | dotnetcore2.1 | go1.x | ruby2.5
	// | provided
	CompatibleRuntimes []string `type:"list"`

	// The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
	CreatedDate *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s AwsLambdaLayerVersionDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsLambdaLayerVersionDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompatibleRuntimes != nil {
		v := s.CompatibleRuntimes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CompatibleRuntimes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An AWS Identity and Access Management (IAM) role associated with the DB instance.
type AwsRdsDbInstanceAssociatedRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the IAM)role.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of the association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - The IAM role ARN is associated with the DB instance and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - The IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - The IAM role ARN is associated with the DB instance. But the
	//    DB instance is unable to assume the IAM role in order to access other
	//    AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceAssociatedRole) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsRdsDbInstanceAssociatedRole) MarshalFields(e protocol.FieldEncoder) error {
	if s.FeatureName != nil {
		v := *s.FeatureName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FeatureName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the details of an Amazon RDS DB instance.
type AwsRdsDbInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The AWS Identity and Access Management (IAM) roles associated with the DB
	// instance.
	AssociatedRoles []AwsRdsDbInstanceAssociatedRole `type:"list"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates whether the DB instance has deletion protection enabled.
	//
	// When deletion protection is enabled, the database cannot be deleted.
	DeletionProtection *bool `type:"boolean"`

	// Specifies the connection endpoint.
	Endpoint *AwsRdsDbInstanceEndpoint `type:"structure"`

	// Provides the name of the database engine to use for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines.
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *string `type:"string"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the accessibility options for the DB instance.
	//
	// A value of true specifies an Internet-facing instance with a publicly resolvable
	// DNS name, which resolves to a public IP address.
	//
	// A value of false specifies an internal instance with a DNS name that resolves
	// to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// A list of VPC security groups that the DB instance belongs to.
	VpcSecurityGroups []AwsRdsDbInstanceVpcSecurityGroup `type:"list"`
}

// String returns the string representation
func (s AwsRdsDbInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsRdsDbInstanceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociatedRoles != nil {
		v := s.AssociatedRoles

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AssociatedRoles", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CACertificateIdentifier != nil {
		v := *s.CACertificateIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CACertificateIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DBClusterIdentifier != nil {
		v := *s.DBClusterIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DBClusterIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DBInstanceClass != nil {
		v := *s.DBInstanceClass

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DBInstanceClass", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DBInstanceIdentifier != nil {
		v := *s.DBInstanceIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DBInstanceIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DBName != nil {
		v := *s.DBName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DBName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DbInstancePort != nil {
		v := *s.DbInstancePort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DbInstancePort", protocol.Int64Value(v), metadata)
	}
	if s.DbiResourceId != nil {
		v := *s.DbiResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DbiResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeletionProtection != nil {
		v := *s.DeletionProtection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeletionProtection", protocol.BoolValue(v), metadata)
	}
	if s.Endpoint != nil {
		v := s.Endpoint

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Endpoint", v, metadata)
	}
	if s.Engine != nil {
		v := *s.Engine

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Engine", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EngineVersion != nil {
		v := *s.EngineVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EngineVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IAMDatabaseAuthenticationEnabled != nil {
		v := *s.IAMDatabaseAuthenticationEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IAMDatabaseAuthenticationEnabled", protocol.BoolValue(v), metadata)
	}
	if s.InstanceCreateTime != nil {
		v := *s.InstanceCreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InstanceCreateTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PubliclyAccessible != nil {
		v := *s.PubliclyAccessible

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PubliclyAccessible", protocol.BoolValue(v), metadata)
	}
	if s.StorageEncrypted != nil {
		v := *s.StorageEncrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StorageEncrypted", protocol.BoolValue(v), metadata)
	}
	if s.TdeCredentialArn != nil {
		v := *s.TdeCredentialArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TdeCredentialArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcSecurityGroups != nil {
		v := s.VpcSecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VpcSecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Specifies the connection endpoint.
type AwsRdsDbInstanceEndpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s AwsRdsDbInstanceEndpoint) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsRdsDbInstanceEndpoint) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := *s.Address

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Address", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A VPC security groups that the DB instance belongs to.
type AwsRdsDbInstanceVpcSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s AwsRdsDbInstanceVpcSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsRdsDbInstanceVpcSecurityGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcSecurityGroupId != nil {
		v := *s.VpcSecurityGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcSecurityGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of an Amazon S3 bucket.
type AwsS3BucketDetails struct {
	_ struct{} `type:"structure"`

	// The date and time when the S3 bucket was created.
	CreatedAt *string `type:"string"`

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string `type:"string"`

	// The display name of the owner of the S3 bucket.
	OwnerName *string `type:"string"`

	// The encryption rules that are applied to the S3 bucket.
	ServerSideEncryptionConfiguration *AwsS3BucketServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s AwsS3BucketDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3BucketDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerName != nil {
		v := *s.OwnerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServerSideEncryptionConfiguration != nil {
		v := s.ServerSideEncryptionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ServerSideEncryptionConfiguration", v, metadata)
	}
	return nil
}

// Specifies the default server-side encryption to apply to new objects in the
// bucket.
type AwsS3BucketServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// AWS KMS customer master key (CMK) ID to use for the default encryption.
	KMSMasterKeyID *string `type:"string"`

	// Server-side encryption algorithm to use for the default encryption.
	SSEAlgorithm *string `type:"string"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3BucketServerSideEncryptionByDefault) MarshalFields(e protocol.FieldEncoder) error {
	if s.KMSMasterKeyID != nil {
		v := *s.KMSMasterKeyID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KMSMasterKeyID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SSEAlgorithm != nil {
		v := *s.SSEAlgorithm

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEAlgorithm", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The encryption configuration for the S3 bucket.
type AwsS3BucketServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption rules that are applied to the S3 bucket.
	Rules []AwsS3BucketServerSideEncryptionRule `type:"list"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3BucketServerSideEncryptionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An encryption rule to apply to the S3 bucket.
type AwsS3BucketServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Specifies the default server-side encryption to apply to new objects in the
	// bucket. If a PUT object request doesn't specify any server-side encryption,
	// this default encryption is applied.
	ApplyServerSideEncryptionByDefault *AwsS3BucketServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s AwsS3BucketServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3BucketServerSideEncryptionRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplyServerSideEncryptionByDefault != nil {
		v := s.ApplyServerSideEncryptionByDefault

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ApplyServerSideEncryptionByDefault", v, metadata)
	}
	return nil
}

// Details about an Amazon S3 object.
type AwsS3ObjectDetails struct {
	_ struct{} `type:"structure"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `type:"string"`

	// The opaque identifier assigned by a web server to a specific version of a
	// resource found at a URL.
	ETag *string `type:"string"`

	// The date and time when the object was last modified.
	LastModified *string `type:"string"`

	// The identifier of the AWS Key Management Service (AWS KMS) symmetric customer
	// managed customer master key (CMK) that was used for the object.
	SSEKMSKeyId *string `type:"string"`

	// If the object is stored using server-side encryption, the value of the server-side
	// encryption algorithm used when storing this object in Amazon S3.
	ServerSideEncryption *string `type:"string"`

	// The version of the object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s AwsS3ObjectDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3ObjectDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ETag", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModified != nil {
		v := *s.LastModified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModified", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SSEKMSKeyId != nil {
		v := *s.SSEKMSKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SSEKMSKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServerSideEncryption != nil {
		v := *s.ServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServerSideEncryption", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between
// AWS security services and third-party solutions, and security standards checks.
//
// A finding is a potential security issue generated either by AWS services
// (Amazon GuardDuty, Amazon Inspector, and Amazon Macie) or by the integrated
// third-party solutions and standards checks.
type AwsSecurityFinding struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// This data type is exclusive to findings that are generated as the result
	// of a check run against a specific rule in a supported security standard,
	// such as CIS AWS Foundations. Contains security standard-related finding details.
	Compliance *Compliance `type:"structure"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider created the potential security issue that a finding captured.
	//
	// CreatedAt is a required field
	CreatedAt *string `type:"string" required:"true"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// A finding's description.
	//
	// In this release, Description is a required property.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt *string `type:"string"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	//
	// GeneratorId is a required field
	GeneratorId *string `type:"string" required:"true"`

	// The security findings provider-specific identifier for a finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt *string `type:"string"`

	// A list of malware related to a finding.
	Malware []Malware `type:"list"`

	// The details of network-related information about a finding.
	Network *Network `type:"structure"`

	// Provides information about a network path that is relevant to a finding.
	// Each entry under NetworkPath represents a component of that path.
	NetworkPath []NetworkPathComponent `type:"list"`

	// A user-defined note added to a finding.
	Note *Note `type:"structure"`

	// The details of process-related information about a finding.
	Process *ProcessDetails `type:"structure"`

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields map[string]string `type:"map"`

	// The record state of a finding.
	RecordState RecordState `type:"string" enum:"true"`

	// A list of related findings.
	RelatedFindings []RelatedFinding `type:"list"`

	// A data type that describes the remediation options for a finding.
	Remediation *Remediation `type:"structure"`

	// A set of resource data types that describe the resources that the finding
	// refers to.
	//
	// Resources is a required field
	Resources []Resource `type:"list" required:"true"`

	// The schema version that a finding is formatted for.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// A finding's severity.
	//
	// Severity is a required field
	Severity *Severity `type:"structure" required:"true"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl *string `type:"string"`

	// Threat intelligence details related to a finding.
	ThreatIntelIndicators []ThreatIntelIndicator `type:"list"`

	// A finding's title.
	//
	// In this release, Title is a required property.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`

	// One or more finding types in the format of namespace/category/classifier
	// that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Types is a required field
	Types []string `type:"list" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]string `type:"map"`

	// Indicates the veracity of a finding.
	VerificationState VerificationState `type:"string" enum:"true"`

	// Provides a list of vulnerabilities associated with the findings.
	Vulnerabilities []Vulnerability `type:"list"`

	// Provides information about the status of the investigation into a finding.
	Workflow *Workflow `type:"structure"`

	// The workflow state of a finding.
	WorkflowState WorkflowState `deprecated:"true" type:"string" enum:"true"`
}

// String returns the string representation
func (s AwsSecurityFinding) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFinding) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsSecurityFinding"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}

	if s.CreatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("CreatedAt"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if s.GeneratorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GeneratorId"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.ProductArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductArn"))
	}

	if s.Resources == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resources"))
	}

	if s.SchemaVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaVersion"))
	}

	if s.Severity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Severity"))
	}

	if s.Title == nil {
		invalidParams.Add(aws.NewErrParamRequired("Title"))
	}

	if s.Types == nil {
		invalidParams.Add(aws.NewErrParamRequired("Types"))
	}

	if s.UpdatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedAt"))
	}
	if s.Compliance != nil {
		if err := s.Compliance.Validate(); err != nil {
			invalidParams.AddNested("Compliance", err.(aws.ErrInvalidParams))
		}
	}
	if s.Malware != nil {
		for i, v := range s.Malware {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Malware", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(aws.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Vulnerabilities != nil {
		for i, v := range s.Vulnerabilities {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Vulnerabilities", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSecurityFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Compliance != nil {
		v := s.Compliance

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Compliance", v, metadata)
	}
	if s.Confidence != nil {
		v := *s.Confidence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Confidence", protocol.Int64Value(v), metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Criticality != nil {
		v := *s.Criticality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Criticality", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FirstObservedAt != nil {
		v := *s.FirstObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FirstObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GeneratorId != nil {
		v := *s.GeneratorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GeneratorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastObservedAt != nil {
		v := *s.LastObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Malware != nil {
		v := s.Malware

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Malware", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Network != nil {
		v := s.Network

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Network", v, metadata)
	}
	if s.NetworkPath != nil {
		v := s.NetworkPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Note != nil {
		v := s.Note

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Note", v, metadata)
	}
	if s.Process != nil {
		v := s.Process

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Process", v, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductFields != nil {
		v := s.ProductFields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ProductFields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.RecordState) > 0 {
		v := s.RecordState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RelatedFindings != nil {
		v := s.RelatedFindings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Remediation != nil {
		v := s.Remediation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Remediation", v, metadata)
	}
	if s.Resources != nil {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Severity != nil {
		v := s.Severity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Severity", v, metadata)
	}
	if s.SourceUrl != nil {
		v := *s.SourceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreatIntelIndicators != nil {
		v := s.ThreatIntelIndicators

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicators", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Types != nil {
		v := s.Types

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Types", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserDefinedFields != nil {
		v := s.UserDefinedFields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserDefinedFields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.VerificationState) > 0 {
		v := s.VerificationState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VerificationState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Vulnerabilities != nil {
		v := s.Vulnerabilities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Vulnerabilities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Workflow != nil {
		v := s.Workflow

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Workflow", v, metadata)
	}
	if len(s.WorkflowState) > 0 {
		v := s.WorkflowState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WorkflowState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A collection of attributes that are applied to all active Security Hub-aggregated
// findings and that result in a subset of findings that are included in this
// insight.
type AwsSecurityFindingFilters struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that a finding is generated in.
	AwsAccountId []StringFilter `type:"list"`

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []StringFilter `type:"list"`

	// Exclusive to findings that are generated as the result of a check run against
	// a specific rule in a supported standard, such as CIS AWS Foundations. Contains
	// security standard-related finding details.
	ComplianceStatus []StringFilter `type:"list"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	//
	// Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
	// zero percent confidence and 100 means 100 percent confidence.
	Confidence []NumberFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider captured the potential security issue that a finding captured.
	CreatedAt []DateFilter `type:"list"`

	// The level of importance assigned to the resources associated with the finding.
	//
	// A score of 0 means that the underlying resources have no criticality, and
	// a score of 100 is reserved for the most critical resources.
	Criticality []NumberFilter `type:"list"`

	// A finding's description.
	Description []StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider first observed the potential security issue that a finding captured.
	FirstObservedAt []DateFilter `type:"list"`

	// The identifier for the solution-specific component (a discrete unit of logic)
	// that generated a finding. In various security-findings providers' solutions,
	// this generator can be called a rule, a check, a detector, a plugin, etc.
	GeneratorId []StringFilter `type:"list"`

	// The security findings provider-specific identifier for a finding.
	Id []StringFilter `type:"list"`

	// A keyword for a finding.
	Keyword []KeywordFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider most recently observed the potential security issue that a finding
	// captured.
	LastObservedAt []DateFilter `type:"list"`

	// The name of the malware that was observed.
	MalwareName []StringFilter `type:"list"`

	// The filesystem path of the malware that was observed.
	MalwarePath []StringFilter `type:"list"`

	// The state of the malware that was observed.
	MalwareState []StringFilter `type:"list"`

	// The type of the malware that was observed.
	MalwareType []StringFilter `type:"list"`

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []StringFilter `type:"list"`

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []IpFilter `type:"list"`

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []IpFilter `type:"list"`

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []NumberFilter `type:"list"`

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []StringFilter `type:"list"`

	// The protocol of network-related information about a finding.
	NetworkProtocol []StringFilter `type:"list"`

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []StringFilter `type:"list"`

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []IpFilter `type:"list"`

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []IpFilter `type:"list"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []StringFilter `type:"list"`

	// The source port of network-related information about a finding.
	NetworkSourcePort []NumberFilter `type:"list"`

	// The text of a note.
	NoteText []StringFilter `type:"list"`

	// The timestamp of when the note was updated.
	NoteUpdatedAt []DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []StringFilter `type:"list"`

	// The date/time that the process was launched.
	ProcessLaunchedAt []DateFilter `type:"list"`

	// The name of the process.
	ProcessName []StringFilter `type:"list"`

	// The parent process ID.
	ProcessParentPid []NumberFilter `type:"list"`

	// The path to the process executable.
	ProcessPath []StringFilter `type:"list"`

	// The process ID.
	ProcessPid []NumberFilter `type:"list"`

	// The date/time that the process was terminated.
	ProcessTerminatedAt []DateFilter `type:"list"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) after this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []StringFilter `type:"list"`

	// A data type where security-findings providers can include additional solution-specific
	// details that aren't part of the defined AwsSecurityFinding format.
	ProductFields []MapFilter `type:"list"`

	// The name of the solution (product) that generates findings.
	ProductName []StringFilter `type:"list"`

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []StringFilter `type:"list"`

	// The updated record state for the finding.
	RecordState []StringFilter `type:"list"`

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []StringFilter `type:"list"`

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []StringFilter `type:"list"`

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []StringFilter `type:"list"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []StringFilter `type:"list"`

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []IpFilter `type:"list"`

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []IpFilter `type:"list"`

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []StringFilter `type:"list"`

	// The date and time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []DateFilter `type:"list"`

	// The identifier of the subnet that the instance was launched in.
	ResourceAwsEc2InstanceSubnetId []StringFilter `type:"list"`

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []StringFilter `type:"list"`

	// The identifier of the VPC that the instance was launched in.
	ResourceAwsEc2InstanceVpcId []StringFilter `type:"list"`

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []DateFilter `type:"list"`

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []StringFilter `type:"list"`

	// The user associated with the IAM access key related to a finding.
	ResourceAwsIamAccessKeyUserName []StringFilter `type:"list"`

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []StringFilter `type:"list"`

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []StringFilter `type:"list"`

	// The identifier of the image related to a finding.
	ResourceContainerImageId []StringFilter `type:"list"`

	// The name of the image related to a finding.
	ResourceContainerImageName []StringFilter `type:"list"`

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []DateFilter `type:"list"`

	// The name of the container related to a finding.
	ResourceContainerName []StringFilter `type:"list"`

	// The details of a resource that doesn't have a specific subfield for the resource
	// type defined.
	ResourceDetailsOther []MapFilter `type:"list"`

	// The canonical identifier for the given resource type.
	ResourceId []StringFilter `type:"list"`

	// The canonical AWS partition name that the Region is assigned to.
	ResourcePartition []StringFilter `type:"list"`

	// The canonical AWS external Region name where this resource is located.
	ResourceRegion []StringFilter `type:"list"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	ResourceTags []MapFilter `type:"list"`

	// Specifies the type of the resource that details are provided for.
	ResourceType []StringFilter `type:"list"`

	// The label of a finding's severity.
	SeverityLabel []StringFilter `type:"list"`

	// The normalized severity of a finding.
	SeverityNormalized []NumberFilter `type:"list"`

	// The native severity as defined by the security-findings provider's solution
	// that generated the finding.
	SeverityProduct []NumberFilter `type:"list"`

	// A URL that links to a page about the current finding in the security-findings
	// provider's solution.
	SourceUrl []StringFilter `type:"list"`

	// The category of a threat intelligence indicator.
	ThreatIntelIndicatorCategory []StringFilter `type:"list"`

	// The date/time of the last observation of a threat intelligence indicator.
	ThreatIntelIndicatorLastObservedAt []DateFilter `type:"list"`

	// The source of the threat intelligence.
	ThreatIntelIndicatorSource []StringFilter `type:"list"`

	// The URL for more details from the source of the threat intelligence.
	ThreatIntelIndicatorSourceUrl []StringFilter `type:"list"`

	// The type of a threat intelligence indicator.
	ThreatIntelIndicatorType []StringFilter `type:"list"`

	// The value of a threat intelligence indicator.
	ThreatIntelIndicatorValue []StringFilter `type:"list"`

	// A finding's title.
	Title []StringFilter `type:"list"`

	// A finding type in the format of namespace/category/classifier that classifies
	// a finding.
	Type []StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the security-findings
	// provider last updated the finding record.
	UpdatedAt []DateFilter `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []MapFilter `type:"list"`

	// The veracity of a finding.
	VerificationState []StringFilter `type:"list"`

	// The workflow state of a finding.
	WorkflowState []StringFilter `type:"list"`

	// The status of the investigation into a finding. Allowed values are the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that the resource owner has been notified about
	//    the security issue. Used when the initial reviewer is not the resource
	//    owner, and needs intervention from the resource owner.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	WorkflowStatus []StringFilter `type:"list"`
}

// String returns the string representation
func (s AwsSecurityFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSecurityFindingFilters) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsAccountId != nil {
		v := s.AwsAccountId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AwsAccountId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CompanyName != nil {
		v := s.CompanyName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CompanyName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ComplianceStatus != nil {
		v := s.ComplianceStatus

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ComplianceStatus", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Confidence != nil {
		v := s.Confidence

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Confidence", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CreatedAt != nil {
		v := s.CreatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CreatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Criticality != nil {
		v := s.Criticality

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Criticality", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Description != nil {
		v := s.Description

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Description", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FirstObservedAt != nil {
		v := s.FirstObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FirstObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.GeneratorId != nil {
		v := s.GeneratorId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GeneratorId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := s.Id

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Id", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Keyword != nil {
		v := s.Keyword

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Keyword", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.LastObservedAt != nil {
		v := s.LastObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LastObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MalwareName != nil {
		v := s.MalwareName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MalwarePath != nil {
		v := s.MalwarePath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwarePath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MalwareState != nil {
		v := s.MalwareState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MalwareType != nil {
		v := s.MalwareType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkDestinationDomain != nil {
		v := s.NetworkDestinationDomain

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationDomain", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkDestinationIpV4 != nil {
		v := s.NetworkDestinationIpV4

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationIpV4", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkDestinationIpV6 != nil {
		v := s.NetworkDestinationIpV6

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationIpV6", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkDestinationPort != nil {
		v := s.NetworkDestinationPort

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationPort", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkDirection != nil {
		v := s.NetworkDirection

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDirection", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkProtocol != nil {
		v := s.NetworkProtocol

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkProtocol", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkSourceDomain != nil {
		v := s.NetworkSourceDomain

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceDomain", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkSourceIpV4 != nil {
		v := s.NetworkSourceIpV4

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceIpV4", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkSourceIpV6 != nil {
		v := s.NetworkSourceIpV6

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceIpV6", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkSourceMac != nil {
		v := s.NetworkSourceMac

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceMac", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NetworkSourcePort != nil {
		v := s.NetworkSourcePort

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourcePort", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NoteText != nil {
		v := s.NoteText

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteText", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NoteUpdatedAt != nil {
		v := s.NoteUpdatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteUpdatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NoteUpdatedBy != nil {
		v := s.NoteUpdatedBy

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteUpdatedBy", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessLaunchedAt != nil {
		v := s.ProcessLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessName != nil {
		v := s.ProcessName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessParentPid != nil {
		v := s.ProcessParentPid

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessParentPid", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessPath != nil {
		v := s.ProcessPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessPid != nil {
		v := s.ProcessPid

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessPid", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProcessTerminatedAt != nil {
		v := s.ProcessTerminatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessTerminatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProductArn != nil {
		v := s.ProductArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProductFields != nil {
		v := s.ProductFields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ProductName != nil {
		v := s.ProductName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RecommendationText != nil {
		v := s.RecommendationText

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecommendationText", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RecordState != nil {
		v := s.RecordState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecordState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RelatedFindingsId != nil {
		v := s.RelatedFindingsId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindingsId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.RelatedFindingsProductArn != nil {
		v := s.RelatedFindingsProductArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindingsProductArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceIamInstanceProfileArn != nil {
		v := s.ResourceAwsEc2InstanceIamInstanceProfileArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIamInstanceProfileArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceImageId != nil {
		v := s.ResourceAwsEc2InstanceImageId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceImageId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceIpV4Addresses != nil {
		v := s.ResourceAwsEc2InstanceIpV4Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIpV4Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceIpV6Addresses != nil {
		v := s.ResourceAwsEc2InstanceIpV6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIpV6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceKeyName != nil {
		v := s.ResourceAwsEc2InstanceKeyName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceKeyName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceLaunchedAt != nil {
		v := s.ResourceAwsEc2InstanceLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceSubnetId != nil {
		v := s.ResourceAwsEc2InstanceSubnetId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceSubnetId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceType != nil {
		v := s.ResourceAwsEc2InstanceType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsEc2InstanceVpcId != nil {
		v := s.ResourceAwsEc2InstanceVpcId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceVpcId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsIamAccessKeyCreatedAt != nil {
		v := s.ResourceAwsIamAccessKeyCreatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyCreatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsIamAccessKeyStatus != nil {
		v := s.ResourceAwsIamAccessKeyStatus

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyStatus", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsIamAccessKeyUserName != nil {
		v := s.ResourceAwsIamAccessKeyUserName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyUserName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsS3BucketOwnerId != nil {
		v := s.ResourceAwsS3BucketOwnerId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsS3BucketOwnerId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceAwsS3BucketOwnerName != nil {
		v := s.ResourceAwsS3BucketOwnerName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsS3BucketOwnerName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceContainerImageId != nil {
		v := s.ResourceContainerImageId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerImageId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceContainerImageName != nil {
		v := s.ResourceContainerImageName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerImageName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceContainerLaunchedAt != nil {
		v := s.ResourceContainerLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceContainerName != nil {
		v := s.ResourceContainerName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceDetailsOther != nil {
		v := s.ResourceDetailsOther

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceDetailsOther", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceId != nil {
		v := s.ResourceId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourcePartition != nil {
		v := s.ResourcePartition

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourcePartition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceRegion != nil {
		v := s.ResourceRegion

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceRegion", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceTags != nil {
		v := s.ResourceTags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceTags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ResourceType != nil {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SeverityLabel != nil {
		v := s.SeverityLabel

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityLabel", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SeverityNormalized != nil {
		v := s.SeverityNormalized

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityNormalized", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SeverityProduct != nil {
		v := s.SeverityProduct

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityProduct", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SourceUrl != nil {
		v := s.SourceUrl

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SourceUrl", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorCategory != nil {
		v := s.ThreatIntelIndicatorCategory

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorCategory", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorLastObservedAt != nil {
		v := s.ThreatIntelIndicatorLastObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorLastObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorSource != nil {
		v := s.ThreatIntelIndicatorSource

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorSource", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorSourceUrl != nil {
		v := s.ThreatIntelIndicatorSourceUrl

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorSourceUrl", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorType != nil {
		v := s.ThreatIntelIndicatorType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ThreatIntelIndicatorValue != nil {
		v := s.ThreatIntelIndicatorValue

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorValue", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Title != nil {
		v := s.Title

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Title", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := s.Type

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Type", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UpdatedAt != nil {
		v := s.UpdatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UpdatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UserDefinedFields != nil {
		v := s.UserDefinedFields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UserDefinedFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VerificationState != nil {
		v := s.VerificationState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VerificationState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.WorkflowState != nil {
		v := s.WorkflowState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "WorkflowState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.WorkflowStatus != nil {
		v := s.WorkflowStatus

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "WorkflowStatus", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Identifies a finding to update using BatchUpdateFindings.
type AwsSecurityFindingIdentifier struct {
	_ struct{} `type:"structure"`

	// The identifier of the finding that was specified by the finding provider.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN generated by Security Hub that uniquely identifies a product that
	// generates findings. This can be the ARN for a third-party product that is
	// integrated with Security Hub, or the ARN for a custom integration.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AwsSecurityFindingIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFindingIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsSecurityFindingIdentifier"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.ProductArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSecurityFindingIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A wrapper type for the topic's Amazon Resource Name (ARN).
type AwsSnsTopicDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS managed customer master key (CMK) for Amazon SNS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// Subscription is an embedded property that describes the subscription endpoints
	// of an Amazon SNS topic.
	Subscription []AwsSnsTopicSubscription `type:"list"`

	// The name of the topic.
	TopicName *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSnsTopicDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.KmsMasterKeyId != nil {
		v := *s.KmsMasterKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsMasterKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subscription != nil {
		v := s.Subscription

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Subscription", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.TopicName != nil {
		v := *s.TopicName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TopicName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type AwsSnsTopicSubscription struct {
	_ struct{} `type:"structure"`

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`
}

// String returns the string representation
func (s AwsSnsTopicSubscription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSnsTopicSubscription) MarshalFields(e protocol.FieldEncoder) error {
	if s.Endpoint != nil {
		v := *s.Endpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Endpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Data about a queue.
type AwsSqsQueueDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dead-letter queue to which Amazon SQS
	// moves messages after the value of maxReceiveCount is exceeded.
	DeadLetterTargetArn *string `type:"string"`

	// The length of time, in seconds, for which Amazon SQS can reuse a data key
	// to encrypt or decrypt messages before calling AWS KMS again.
	KmsDataKeyReusePeriodSeconds *int64 `type:"integer"`

	// The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom
	// CMK.
	KmsMasterKeyId *string `type:"string"`

	// The name of the new queue.
	QueueName *string `type:"string"`
}

// String returns the string representation
func (s AwsSqsQueueDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSqsQueueDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeadLetterTargetArn != nil {
		v := *s.DeadLetterTargetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeadLetterTargetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsDataKeyReusePeriodSeconds != nil {
		v := *s.KmsDataKeyReusePeriodSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsDataKeyReusePeriodSeconds", protocol.Int64Value(v), metadata)
	}
	if s.KmsMasterKeyId != nil {
		v := *s.KmsMasterKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KmsMasterKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.QueueName != nil {
		v := *s.QueueName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "QueueName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a WAF WebACL.
type AwsWafWebAclDetails struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the rules contained in the WebACL match.
	DefaultAction *string `type:"string"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `type:"string"`

	// An array that contains the action for each rule in a WebACL, the priority
	// of the rule, and the ID of the rule.
	Rules []AwsWafWebAclRule `type:"list"`

	// A unique identifier for a WebACL.
	WebAclId *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsWafWebAclDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultAction != nil {
		v := *s.DefaultAction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultAction", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Rules != nil {
		v := s.Rules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Rules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.WebAclId != nil {
		v := *s.WebAclId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebAclId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details for a rule in a WAF WebACL.
type AwsWafWebAclRule struct {
	_ struct{} `type:"structure"`

	// Specifies the action that CloudFront or AWS WAF takes when a web request
	// matches the conditions in the rule.
	Action *WafAction `type:"structure"`

	// Rules to exclude from a rule group.
	ExcludedRules []WafExcludedRule `type:"list"`

	// Use the OverrideAction to test your RuleGroup.
	//
	// Any rule in a RuleGroup can potentially block a request. If you set the OverrideAction
	// to None, the RuleGroup blocks a request if any individual rule in the RuleGroup
	// matches the request and is configured to block that request.
	//
	// However, if you first want to test the RuleGroup, set the OverrideAction
	// to Count. The RuleGroup then overrides any block action specified by individual
	// rules contained within the group. Instead of blocking matching requests,
	// those requests are counted.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	OverrideAction *WafOverrideAction `type:"structure"`

	// Specifies the order in which the rules in a WebACL are evaluated. Rules with
	// a lower value for Priority are evaluated before rules with a higher value.
	// The value must be a unique integer. If you add multiple rules to a WebACL,
	// the values do not need to be consecutive.
	Priority *int64 `type:"integer"`

	// The identifier for a rule.
	RuleId *string `type:"string"`

	// The rule type.
	//
	// Valid values: REGULAR | RATE_BASED | GROUP
	//
	// The default is REGULAR.
	Type *string `type:"string"`
}

// String returns the string representation
func (s AwsWafWebAclRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsWafWebAclRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Action", v, metadata)
	}
	if s.ExcludedRules != nil {
		v := s.ExcludedRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ExcludedRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.OverrideAction != nil {
		v := s.OverrideAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OverrideAction", v, metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.RuleId != nil {
		v := *s.RuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A finding from a BatchUpdateFindings request that Security Hub was unable
// to update.
type BatchUpdateFindingsUnprocessedFinding struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message associated with the error.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The identifier of the finding that was not updated.
	//
	// FindingIdentifier is a required field
	FindingIdentifier *AwsSecurityFindingIdentifier `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchUpdateFindingsUnprocessedFinding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateFindingsUnprocessedFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingIdentifier != nil {
		v := s.FindingIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FindingIdentifier", v, metadata)
	}
	return nil
}

// An IPv4 CIDR block association.
type CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv4 CIDR block.
	AssociationId *string `type:"string"`

	// The IPv4 CIDR block.
	CidrBlock *string `type:"string"`

	// Information about the state of the IPv4 CIDR block.
	CidrBlockState *string `type:"string"`
}

// String returns the string representation
func (s CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CidrBlockAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CidrBlock != nil {
		v := *s.CidrBlock

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CidrBlock", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CidrBlockState != nil {
		v := *s.CidrBlockState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CidrBlockState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains finding details that are specific to control-based findings. Only
// returned for findings generated from controls.
type Compliance struct {
	_ struct{} `type:"structure"`

	// For a control, the industry or regulatory framework requirements that are
	// related to the control. The check for that control is aligned with these
	// requirements.
	RelatedRequirements []string `type:"list"`

	// The result of a standards check.
	//
	// The valid values for Status are as follows.
	//
	//    * PASSED - Standards check passed for all evaluated resources. WARNING
	//    - Some information is missing or this check is not supported for your
	//    configuration. FAILED - Standards check failed for at least one evaluated
	//    resource. NOT_AVAILABLE - Check could not be performed due to a service
	//    outage, API error, or because the result of the AWS Config evaluation
	//    was NOT_APPLICABLE. If the AWS Config evaluation result was NOT_APPLICABLE,
	//    then after 3 days, Security Hub automatically archives the finding.
	Status ComplianceStatus `type:"string" enum:"true"`

	// For findings generated from controls, a list of reasons behind the value
	// of Status. For the list of status reason codes and their meanings, see Standards-related
	// information in the ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the AWS Security Hub User Guide.
	StatusReasons []StatusReason `type:"list"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Compliance) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Compliance"}
	if s.StatusReasons != nil {
		for i, v := range s.StatusReasons {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StatusReasons", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Compliance) MarshalFields(e protocol.FieldEncoder) error {
	if s.RelatedRequirements != nil {
		v := s.RelatedRequirements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedRequirements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReasons != nil {
		v := s.StatusReasons

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "StatusReasons", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Container details related to a finding.
type ContainerDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the image related to a finding.
	ImageId *string `type:"string"`

	// The name of the image related to a finding.
	ImageName *string `type:"string"`

	// The date and time when the container started.
	LaunchedAt *string `type:"string"`

	// The name of the container related to a finding.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageName != nil {
		v := *s.ImageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// CVSS scores from the advisory related to the vulnerability.
type Cvss struct {
	_ struct{} `type:"structure"`

	// The base CVSS score.
	BaseScore *float64 `type:"double"`

	// The base scoring vector for the CVSS score.
	BaseVector *string `type:"string"`

	// The version of CVSS for the CVSS score.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Cvss) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Cvss) MarshalFields(e protocol.FieldEncoder) error {
	if s.BaseScore != nil {
		v := *s.BaseScore

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BaseScore", protocol.Float64Value(v), metadata)
	}
	if s.BaseVector != nil {
		v := *s.BaseVector

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BaseVector", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A date filter for querying findings.
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A date range for the date filter.
	DateRange *DateRange `type:"structure"`

	// An end date for the date filter.
	End *string `type:"string"`

	// A start date for the date filter.
	Start *string `type:"string"`
}

// String returns the string representation
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DateFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.DateRange != nil {
		v := s.DateRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DateRange", v, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A date range for the date filter.
type DateRange struct {
	_ struct{} `type:"structure"`

	// A date range unit for the date filter.
	Unit DateRangeUnit `type:"string" enum:"true"`

	// A date range value for the date filter.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DateRange) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The list of the findings that cannot be imported. For each finding, the list
// provides the error.
type ImportFindingsError struct {
	_ struct{} `type:"structure"`

	// The code of the error returned by the BatchImportFindings operation.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message of the error returned by the BatchImportFindings operation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The identifier of the finding that could not be updated.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportFindingsError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportFindingsError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a Security Hub insight.
type Insight struct {
	_ struct{} `type:"structure"`

	// One or more attributes used to filter the findings included in the insight.
	// The insight only includes findings that match the criteria defined in the
	// filters.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The grouping attribute for the insight's findings. Indicates how to group
	// the matching findings, and identifies the type of item that the insight applies
	// to. For example, if an insight is grouped by resource identifier, then the
	// insight produces a list of resource identifiers.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of a Security Hub insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The name of a Security Hub insight.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Insight) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The insight result values returned by the GetInsightResults operation.
type InsightResultValue struct {
	_ struct{} `type:"structure"`

	// The number of findings returned for each GroupByAttributeValue.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// The value of the attribute that the findings are grouped by for the insight
	// whose results are returned by the GetInsightResults operation.
	//
	// GroupByAttributeValue is a required field
	GroupByAttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InsightResultValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InsightResultValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	if s.GroupByAttributeValue != nil {
		v := *s.GroupByAttributeValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttributeValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The insight results returned by the GetInsightResults operation.
type InsightResults struct {
	_ struct{} `type:"structure"`

	// The attribute that the findings are grouped by for the insight whose results
	// are returned by the GetInsightResults operation.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// ResultValues is a required field
	ResultValues []InsightResultValue `type:"list" required:"true"`
}

// String returns the string representation
func (s InsightResults) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InsightResults) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResultValues != nil {
		v := s.ResultValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResultValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details about an invitation.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The account ID of the Security Hub master account that the invitation was
	// sent from.
	AccountId *string `type:"string"`

	// The ID of the invitation sent to the member account.
	InvitationId *string `type:"string"`

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the association between the member and master accounts.
	MemberStatus *string `type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.MemberStatus != nil {
		v := *s.MemberStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The IP filter for querying findings.
type IpFilter struct {
	_ struct{} `type:"structure"`

	// A finding's CIDR value.
	Cidr *string `type:"string"`
}

// String returns the string representation
func (s IpFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cidr != nil {
		v := *s.Cidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Cidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An IPV6 CIDR block association.
type Ipv6CidrBlockAssociation struct {
	_ struct{} `type:"structure"`

	// The association ID for the IPv6 CIDR block.
	AssociationId *string `type:"string"`

	// Information about the state of the CIDR block.
	CidrBlockState *string `type:"string"`

	// The IPv6 CIDR block.
	Ipv6CidrBlock *string `type:"string"`
}

// String returns the string representation
func (s Ipv6CidrBlockAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Ipv6CidrBlockAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociationId != nil {
		v := *s.AssociationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CidrBlockState != nil {
		v := *s.CidrBlockState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CidrBlockState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ipv6CidrBlock != nil {
		v := *s.Ipv6CidrBlock

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Ipv6CidrBlock", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A keyword filter for querying findings.
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// A value for the keyword.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeywordFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the state of the load balancer.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The state code. The initial state of the load balancer is provisioning.
	//
	// After the load balancer is fully set up and ready to route traffic, its state
	// is active.
	//
	// If the load balancer could not be set up, its state is failed.
	Code *string `type:"string"`

	// A description of the state.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoadBalancerState) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of malware related to a finding.
type Malware struct {
	_ struct{} `type:"structure"`

	// The name of the malware that was observed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The file system path of the malware that was observed.
	Path *string `type:"string"`

	// The state of the malware that was observed.
	State MalwareState `type:"string" enum:"true"`

	// The type of the malware that was observed.
	Type MalwareType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Malware) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Malware) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Malware"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Malware) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The map filter for querying findings.
type MapFilter struct {
	_ struct{} `type:"structure"`

	// The condition to apply to a key value when querying for findings with a map
	// filter.
	Comparison MapFilterComparison `type:"string" enum:"true"`

	// The key of the map filter.
	Key *string `type:"string"`

	// The value for the key in the map filter.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MapFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details about a member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the member account.
	AccountId *string `type:"string"`

	// The email address of the member account.
	Email *string `type:"string"`

	// A timestamp for the date and time when the invitation was sent to the member
	// account.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The AWS account ID of the Security Hub master account associated with this
	// member account.
	MasterId *string `type:"string"`

	// The status of the relationship between the member account and its master
	// account.
	MemberStatus *string `type:"string"`

	// The timestamp for the date and time when the member account was updated.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.MasterId != nil {
		v := *s.MasterId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MasterId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberStatus != nil {
		v := *s.MemberStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The details of network-related information about a finding.
type Network struct {
	_ struct{} `type:"structure"`

	// The destination domain of network-related information about a finding.
	DestinationDomain *string `type:"string"`

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string `type:"string"`

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string `type:"string"`

	// The destination port of network-related information about a finding.
	DestinationPort *int64 `type:"integer"`

	// The direction of network traffic associated with a finding.
	Direction NetworkDirection `type:"string" enum:"true"`

	// The range of open ports that is present on the network.
	OpenPortRange *PortRange `type:"structure"`

	// The protocol of network-related information about a finding.
	Protocol *string `type:"string"`

	// The source domain of network-related information about a finding.
	SourceDomain *string `type:"string"`

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string `type:"string"`

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string `type:"string"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string `type:"string"`

	// The source port of network-related information about a finding.
	SourcePort *int64 `type:"integer"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Network) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationDomain != nil {
		v := *s.DestinationDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationIpV4 != nil {
		v := *s.DestinationIpV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationIpV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationIpV6 != nil {
		v := *s.DestinationIpV6

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationIpV6", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationPort != nil {
		v := *s.DestinationPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPort", protocol.Int64Value(v), metadata)
	}
	if len(s.Direction) > 0 {
		v := s.Direction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Direction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.OpenPortRange != nil {
		v := s.OpenPortRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "OpenPortRange", v, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceDomain != nil {
		v := *s.SourceDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceIpV4 != nil {
		v := *s.SourceIpV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceIpV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceIpV6 != nil {
		v := *s.SourceIpV6

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceIpV6", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceMac != nil {
		v := *s.SourceMac

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceMac", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourcePort != nil {
		v := *s.SourcePort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourcePort", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Details about a network path component that occurs before or after the current
// component.
type NetworkHeader struct {
	_ struct{} `type:"structure"`

	// Information about the destination of the component.
	Destination *NetworkPathComponentDetails `type:"structure"`

	// The protocol used for the component.
	Protocol *string `type:"string"`

	// Information about the origin of the component.
	Source *NetworkPathComponentDetails `type:"structure"`
}

// String returns the string representation
func (s NetworkHeader) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkHeader) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Destination", v, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := s.Source

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Source", v, metadata)
	}
	return nil
}

// Information about a network path component.
type NetworkPathComponent struct {
	_ struct{} `type:"structure"`

	// The identifier of a component in the network path.
	ComponentId *string `type:"string"`

	// The type of component.
	ComponentType *string `type:"string"`

	// Information about the component that comes after the current component in
	// the network path.
	Egress *NetworkHeader `type:"structure"`

	// Information about the component that comes before the current node in the
	// network path.
	Ingress *NetworkHeader `type:"structure"`
}

// String returns the string representation
func (s NetworkPathComponent) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkPathComponent) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComponentId != nil {
		v := *s.ComponentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ComponentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ComponentType != nil {
		v := *s.ComponentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ComponentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Egress != nil {
		v := s.Egress

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Egress", v, metadata)
	}
	if s.Ingress != nil {
		v := s.Ingress

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Ingress", v, metadata)
	}
	return nil
}

// Information about the destination of the next component in the network path.
type NetworkPathComponentDetails struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the destination.
	Address []string `type:"list"`

	// A list of port ranges for the destination.
	PortRanges []PortRange `type:"list"`
}

// String returns the string representation
func (s NetworkPathComponentDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkPathComponentDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Address != nil {
		v := s.Address

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Address", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.PortRanges != nil {
		v := s.PortRanges

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PortRanges", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A user-defined note added to a finding.
type Note struct {
	_ struct{} `type:"structure"`

	// The text of a note.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The timestamp of when the note was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// The principal that created a note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Note) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Note) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Note"}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}

	if s.UpdatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedAt"))
	}

	if s.UpdatedBy == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Note) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedBy != nil {
		v := *s.UpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The updated note.
type NoteUpdate struct {
	_ struct{} `type:"structure"`

	// The updated note text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The principal that updated the note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NoteUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoteUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NoteUpdate"}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}

	if s.UpdatedBy == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoteUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedBy != nil {
		v := *s.UpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A number filter for querying findings.
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// The equal-to condition to be applied to a single field when querying for
	// findings.
	Eq *float64 `type:"double"`

	// The greater-than-equal condition to be applied to a single field when querying
	// for findings.
	Gte *float64 `type:"double"`

	// The less-than-equal condition to be applied to a single field when querying
	// for findings.
	Lte *float64 `type:"double"`
}

// String returns the string representation
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Eq != nil {
		v := *s.Eq

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Eq", protocol.Float64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Gte", protocol.Float64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Lte", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A range of ports.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The first port in the port range.
	Begin *int64 `type:"integer"`

	// The last port in the port range.
	End *int64 `type:"integer"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortRange) MarshalFields(e protocol.FieldEncoder) error {
	if s.Begin != nil {
		v := *s.Begin

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Begin", protocol.Int64Value(v), metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The details of process-related information about a finding.
type ProcessDetails struct {
	_ struct{} `type:"structure"`

	// The date/time that the process was launched.
	LaunchedAt *string `type:"string"`

	// The name of the process.
	Name *string `type:"string"`

	// The parent process ID.
	ParentPid *int64 `type:"integer"`

	// The path to the process executable.
	Path *string `type:"string"`

	// The process ID.
	Pid *int64 `type:"integer"`

	// The date and time when the process was terminated.
	TerminatedAt *string `type:"string"`
}

// String returns the string representation
func (s ProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProcessDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentPid != nil {
		v := *s.ParentPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentPid", protocol.Int64Value(v), metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Pid", protocol.Int64Value(v), metadata)
	}
	if s.TerminatedAt != nil {
		v := *s.TerminatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TerminatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains details about a product.
type Product struct {
	_ struct{} `type:"structure"`

	// The URL used to activate the product.
	ActivationUrl *string `type:"string"`

	// The categories assigned to the product.
	Categories []string `type:"list"`

	// The name of the company that provides the product.
	CompanyName *string `type:"string"`

	// A description of the product.
	Description *string `type:"string"`

	// The types of integration that the product supports. Available values are
	// the following.
	//
	//    * SEND_FINDINGS_TO_SECURITY_HUB - Indicates that the integration sends
	//    findings to Security Hub.
	//
	//    * RECEIVE_FINDINGS_FROM_SECURITY_HUB - Indicates that the integration
	//    receives findings from Security Hub.
	IntegrationTypes []IntegrationType `type:"list"`

	// The URL for the page that contains more information about the product.
	MarketplaceUrl *string `type:"string"`

	// The ARN assigned to the product.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// The name of the product.
	ProductName *string `type:"string"`

	// The resource policy associated with the product.
	ProductSubscriptionResourcePolicy *string `type:"string"`
}

// String returns the string representation
func (s Product) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Product) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActivationUrl != nil {
		v := *s.ActivationUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ActivationUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Categories != nil {
		v := s.Categories

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Categories", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CompanyName != nil {
		v := *s.CompanyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompanyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationTypes != nil {
		v := s.IntegrationTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IntegrationTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MarketplaceUrl != nil {
		v := *s.MarketplaceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MarketplaceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductName != nil {
		v := *s.ProductName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductSubscriptionResourcePolicy != nil {
		v := *s.ProductSubscriptionResourcePolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductSubscriptionResourcePolicy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A recommendation on how to remediate the issue identified in a finding.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// Describes the recommended steps to take to remediate an issue identified
	// in a finding.
	Text *string `type:"string"`

	// A URL to a page or site that contains information about how to remediate
	// a finding.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Recommendation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a related finding.
type RelatedFinding struct {
	_ struct{} `type:"structure"`

	// The product-generated identifier for a related finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN of the product that generated a related finding.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedFinding) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedFinding) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelatedFinding"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.ProductArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RelatedFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the remediation steps for a finding.
type Remediation struct {
	_ struct{} `type:"structure"`

	// A recommendation on the steps to take to remediate the issue identified by
	// a finding.
	Recommendation *Recommendation `type:"structure"`
}

// String returns the string representation
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Remediation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Recommendation != nil {
		v := s.Recommendation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Recommendation", v, metadata)
	}
	return nil
}

// A resource related to a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// Additional details about the resource related to a finding.
	Details *ResourceDetails `type:"structure"`

	// The canonical identifier for the given resource type.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The canonical AWS partition name that the Region is assigned to.
	Partition Partition `type:"string" enum:"true"`

	// The canonical AWS external Region name where this resource is located.
	Region *string `type:"string"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	Tags map[string]string `type:"map"`

	// The type of the resource that details are provided for. If possible, set
	// Type to one of the supported resource types. For example, if the resource
	// is an EC2 instance, then set Type to AwsEc2Instance.
	//
	// If the resource does not match any of the provided types, then set Type to
	// Other.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Resource"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Details != nil {
		if err := s.Details.Validate(); err != nil {
			invalidParams.AddNested("Details", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Partition) > 0 {
		v := s.Partition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Partition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Additional details about a resource related to a finding.
//
// To provide the details, use the object that corresponds to the resource type.
// For example, if the resource type is AwsEc2Instance, then you use the AwsEc2Instance
// object to provide the details.
//
// If the type-specific object does not contain all of the fields you want to
// populate, then you use the Other object to populate those additional fields.
//
// You also use the Other object to populate the details when the selected type
// does not have a corresponding object.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Details for an autoscaling group.
	AwsAutoScalingAutoScalingGroup *AwsAutoScalingAutoScalingGroupDetails `type:"structure"`

	// Details about a CloudFront distribution.
	AwsCloudFrontDistribution *AwsCloudFrontDistributionDetails `type:"structure"`

	// Details for an AWS CodeBuild project.
	AwsCodeBuildProject *AwsCodeBuildProjectDetails `type:"structure"`

	// Details about an Amazon EC2 instance related to a finding.
	AwsEc2Instance *AwsEc2InstanceDetails `type:"structure"`

	// Details for an Amazon EC2 network interface.
	AwsEc2NetworkInterface *AwsEc2NetworkInterfaceDetails `type:"structure"`

	// Details for an EC2 security group.
	AwsEc2SecurityGroup *AwsEc2SecurityGroupDetails `type:"structure"`

	// Details for an EC2 volume.
	AwsEc2Volume *AwsEc2VolumeDetails `type:"structure"`

	// Details for an EC2 VPC.
	AwsEc2Vpc *AwsEc2VpcDetails `type:"structure"`

	// Details for an Elasticsearch domain.
	AwsElasticsearchDomain *AwsElasticsearchDomainDetails `type:"structure"`

	// Details about a load balancer.
	AwsElbv2LoadBalancer *AwsElbv2LoadBalancerDetails `type:"structure"`

	// Details about an IAM access key related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails `type:"structure"`

	// Details about an IAM role.
	AwsIamRole *AwsIamRoleDetails `type:"structure"`

	// Details about a KMS key.
	AwsKmsKey *AwsKmsKeyDetails `type:"structure"`

	// Details about a Lambda function.
	AwsLambdaFunction *AwsLambdaFunctionDetails `type:"structure"`

	// Details for a Lambda layer version.
	AwsLambdaLayerVersion *AwsLambdaLayerVersionDetails `type:"structure"`

	// Details for an Amazon RDS database instance.
	AwsRdsDbInstance *AwsRdsDbInstanceDetails `type:"structure"`

	// Details about an Amazon S3 bucket related to a finding.
	AwsS3Bucket *AwsS3BucketDetails `type:"structure"`

	// Details about an Amazon S3 object related to a finding.
	AwsS3Object *AwsS3ObjectDetails `type:"structure"`

	// Details about an SNS topic.
	AwsSnsTopic *AwsSnsTopicDetails `type:"structure"`

	// Details about an SQS queue.
	AwsSqsQueue *AwsSqsQueueDetails `type:"structure"`

	// Details for a WAF WebACL.
	AwsWafWebAcl *AwsWafWebAclDetails `type:"structure"`

	// Details about a container resource related to a finding.
	Container *ContainerDetails `type:"structure"`

	// Details about a resource that are not available in a type-specific details
	// object. Use the Other object in the following cases.
	//
	//    * The type-specific object does not contain all of the fields that you
	//    want to populate. In this case, first use the type-specific object to
	//    populate those fields. Use the Other object to populate the fields that
	//    are missing from the type-specific object.
	//
	//    * The resource type does not have a corresponding object. This includes
	//    resources for which the type is Other.
	Other map[string]string `type:"map"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceDetails) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceDetails"}
	if s.AwsIamRole != nil {
		if err := s.AwsIamRole.Validate(); err != nil {
			invalidParams.AddNested("AwsIamRole", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsAutoScalingAutoScalingGroup != nil {
		v := s.AwsAutoScalingAutoScalingGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsAutoScalingAutoScalingGroup", v, metadata)
	}
	if s.AwsCloudFrontDistribution != nil {
		v := s.AwsCloudFrontDistribution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsCloudFrontDistribution", v, metadata)
	}
	if s.AwsCodeBuildProject != nil {
		v := s.AwsCodeBuildProject

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsCodeBuildProject", v, metadata)
	}
	if s.AwsEc2Instance != nil {
		v := s.AwsEc2Instance

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2Instance", v, metadata)
	}
	if s.AwsEc2NetworkInterface != nil {
		v := s.AwsEc2NetworkInterface

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2NetworkInterface", v, metadata)
	}
	if s.AwsEc2SecurityGroup != nil {
		v := s.AwsEc2SecurityGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2SecurityGroup", v, metadata)
	}
	if s.AwsEc2Volume != nil {
		v := s.AwsEc2Volume

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2Volume", v, metadata)
	}
	if s.AwsEc2Vpc != nil {
		v := s.AwsEc2Vpc

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2Vpc", v, metadata)
	}
	if s.AwsElasticsearchDomain != nil {
		v := s.AwsElasticsearchDomain

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsElasticsearchDomain", v, metadata)
	}
	if s.AwsElbv2LoadBalancer != nil {
		v := s.AwsElbv2LoadBalancer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsElbv2LoadBalancer", v, metadata)
	}
	if s.AwsIamAccessKey != nil {
		v := s.AwsIamAccessKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsIamAccessKey", v, metadata)
	}
	if s.AwsIamRole != nil {
		v := s.AwsIamRole

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsIamRole", v, metadata)
	}
	if s.AwsKmsKey != nil {
		v := s.AwsKmsKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsKmsKey", v, metadata)
	}
	if s.AwsLambdaFunction != nil {
		v := s.AwsLambdaFunction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsLambdaFunction", v, metadata)
	}
	if s.AwsLambdaLayerVersion != nil {
		v := s.AwsLambdaLayerVersion

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsLambdaLayerVersion", v, metadata)
	}
	if s.AwsRdsDbInstance != nil {
		v := s.AwsRdsDbInstance

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsRdsDbInstance", v, metadata)
	}
	if s.AwsS3Bucket != nil {
		v := s.AwsS3Bucket

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsS3Bucket", v, metadata)
	}
	if s.AwsS3Object != nil {
		v := s.AwsS3Object

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsS3Object", v, metadata)
	}
	if s.AwsSnsTopic != nil {
		v := s.AwsSnsTopic

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsSnsTopic", v, metadata)
	}
	if s.AwsSqsQueue != nil {
		v := s.AwsSqsQueue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsSqsQueue", v, metadata)
	}
	if s.AwsWafWebAcl != nil {
		v := s.AwsWafWebAcl

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsWafWebAcl", v, metadata)
	}
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Container", v, metadata)
	}
	if s.Other != nil {
		v := s.Other

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Other", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Details about the account that was not processed.
type Result struct {
	_ struct{} `type:"structure"`

	// An AWS account ID of the account that was not processed.
	AccountId *string `type:"string"`

	// The reason that the account was not processed.
	ProcessingResult *string `type:"string"`
}

// String returns the string representation
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Result) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProcessingResult != nil {
		v := *s.ProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The severity of the finding.
type Severity struct {
	_ struct{} `type:"structure"`

	// The severity value of the finding. The allowed values are the following.
	//
	//    * INFORMATIONAL - No issue was found.
	//
	//    * LOW - The issue does not require action on its own.
	//
	//    * MEDIUM - The issue must be addressed but not urgently.
	//
	//    * HIGH - The issue must be addressed as a priority.
	//
	//    * CRITICAL - The issue must be remediated immediately to avoid it escalating.
	Label SeverityLabel `type:"string" enum:"true"`

	// Deprecated. This attribute is being deprecated. Instead of providing Normalized,
	// provide Label.
	//
	// If you provide Normalized and do not provide Label, Label is set automatically
	// as follows.
	//
	//    * 0 - INFORMATIONAL
	//
	//    * 1–39 - LOW
	//
	//    * 40–69 - MEDIUM
	//
	//    * 70–89 - HIGH
	//
	//    * 90–100 - CRITICAL
	Normalized *int64 `type:"integer"`

	// The native severity from the finding product that generated the finding.
	Original *string `type:"string"`

	// Deprecated. This attribute is being deprecated. Instead of providing Product,
	// provide Original.
	//
	// The native severity as defined by the AWS service or integrated partner product
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Severity) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Label) > 0 {
		v := s.Label

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Label", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Normalized != nil {
		v := *s.Normalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Normalized", protocol.Int64Value(v), metadata)
	}
	if s.Original != nil {
		v := *s.Original

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Original", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Product != nil {
		v := *s.Product

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Product", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Updates to the severity information for a finding.
type SeverityUpdate struct {
	_ struct{} `type:"structure"`

	// The severity value of the finding. The allowed values are the following.
	//
	//    * INFORMATIONAL - No issue was found.
	//
	//    * LOW - The issue does not require action on its own.
	//
	//    * MEDIUM - The issue must be addressed but not urgently.
	//
	//    * HIGH - The issue must be addressed as a priority.
	//
	//    * CRITICAL - The issue must be remediated immediately to avoid it escalating.
	Label SeverityLabel `type:"string" enum:"true"`

	// The normalized severity for the finding. This attribute is to be deprecated
	// in favor of Label.
	//
	// If you provide Normalized and do not provide Label, Label is set automatically
	// as follows.
	//
	//    * 0 - INFORMATIONAL
	//
	//    * 1–39 - LOW
	//
	//    * 40–69 - MEDIUM
	//
	//    * 70–89 - HIGH
	//
	//    * 90–100 - CRITICAL
	Normalized *int64 `type:"integer"`

	// The native severity as defined by the AWS service or integrated partner product
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s SeverityUpdate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SeverityUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Label) > 0 {
		v := s.Label

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Label", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Normalized != nil {
		v := *s.Normalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Normalized", protocol.Int64Value(v), metadata)
	}
	if s.Product != nil {
		v := *s.Product

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Product", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about a software package.
type SoftwarePackage struct {
	_ struct{} `type:"structure"`

	// The architecture used for the software package.
	Architecture *string `type:"string"`

	// The epoch of the software package.
	Epoch *string `type:"string"`

	// The name of the software package.
	Name *string `type:"string"`

	// The release of the software package.
	Release *string `type:"string"`

	// The version of the software package.
	Version *string `type:"string"`
}

// String returns the string representation
func (s SoftwarePackage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SoftwarePackage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Architecture != nil {
		v := *s.Architecture

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Architecture", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Epoch != nil {
		v := *s.Epoch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Epoch", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Release != nil {
		v := *s.Release

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Release", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A collection of finding attributes used to sort findings.
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The finding attribute used to sort findings.
	Field *string `type:"string"`

	// The order used to sort findings.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriterion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Field != nil {
		v := *s.Field

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Field", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SortOrder) > 0 {
		v := s.SortOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SortOrder", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Provides information about a specific standard.
type Standard struct {
	_ struct{} `type:"structure"`

	// A description of the standard.
	Description *string `type:"string"`

	// Whether the standard is enabled by default. When Security Hub is enabled
	// from the console, if a standard is enabled by default, the check box for
	// that standard is selected by default.
	//
	// When Security Hub is enabled using the EnableSecurityHub API operation, the
	// standard is enabled by default unless EnableDefaultStandards is set to false.
	EnabledByDefault *bool `type:"boolean"`

	// The name of the standard.
	Name *string `type:"string"`

	// The ARN of a standard.
	StandardsArn *string `type:"string"`
}

// String returns the string representation
func (s Standard) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Standard) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnabledByDefault != nil {
		v := *s.EnabledByDefault

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnabledByDefault", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StandardsArn != nil {
		v := *s.StandardsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details for an individual security standard control.
type StandardsControl struct {
	_ struct{} `type:"structure"`

	// The identifier of the security standard control.
	ControlId *string `type:"string"`

	// The current status of the security standard control. Indicates whether the
	// control is enabled or disabled. Security Hub does not check against disabled
	// controls.
	ControlStatus ControlStatus `type:"string" enum:"true"`

	// The date and time that the status of the security standard control was most
	// recently updated.
	ControlStatusUpdatedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The longer description of the security standard control. Provides information
	// about what the control is checking for.
	Description *string `type:"string"`

	// The reason provided for the most recent change in status for the control.
	DisabledReason *string `type:"string"`

	// The list of requirements that are related to this control.
	RelatedRequirements []string `type:"list"`

	// A link to remediation information for the control in the Security Hub user
	// documentation.
	RemediationUrl *string `type:"string"`

	// The severity of findings generated from this security standard control.
	//
	// The finding severity is based on an assessment of how easy it would be to
	// compromise AWS resources if the issue is detected.
	SeverityRating SeverityRating `type:"string" enum:"true"`

	// The ARN of the security standard control.
	StandardsControlArn *string `type:"string"`

	// The title of the security standard control.
	Title *string `type:"string"`
}

// String returns the string representation
func (s StandardsControl) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardsControl) MarshalFields(e protocol.FieldEncoder) error {
	if s.ControlId != nil {
		v := *s.ControlId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ControlId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ControlStatus) > 0 {
		v := s.ControlStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ControlStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ControlStatusUpdatedAt != nil {
		v := *s.ControlStatusUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ControlStatusUpdatedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisabledReason != nil {
		v := *s.DisabledReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisabledReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelatedRequirements != nil {
		v := s.RelatedRequirements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedRequirements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RemediationUrl != nil {
		v := *s.RemediationUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RemediationUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SeverityRating) > 0 {
		v := s.SeverityRating

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SeverityRating", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StandardsControlArn != nil {
		v := *s.StandardsControlArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsControlArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A resource that represents your subscription to a supported standard.
type StandardsSubscription struct {
	_ struct{} `type:"structure"`

	// The ARN of a standard.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	//
	// StandardsInput is a required field
	StandardsInput map[string]string `type:"map" required:"true"`

	// The status of the standards subscription.
	//
	// StandardsStatus is a required field
	StandardsStatus StandardsStatus `type:"string" required:"true" enum:"true"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StandardsSubscription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardsSubscription) MarshalFields(e protocol.FieldEncoder) error {
	if s.StandardsArn != nil {
		v := *s.StandardsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StandardsInput != nil {
		v := s.StandardsInput

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "StandardsInput", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.StandardsStatus) > 0 {
		v := s.StandardsStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StandardsSubscriptionArn != nil {
		v := *s.StandardsSubscriptionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsSubscriptionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The standard that you want to enable.
type StandardsSubscriptionRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the standard that you want to enable. To view the list of available
	// standards and their ARNs, use the DescribeStandards operation.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// A key-value pair of input for the standard.
	StandardsInput map[string]string `type:"map"`
}

// String returns the string representation
func (s StandardsSubscriptionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardsSubscriptionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StandardsSubscriptionRequest"}

	if s.StandardsArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StandardsArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardsSubscriptionRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.StandardsArn != nil {
		v := *s.StandardsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StandardsInput != nil {
		v := s.StandardsInput

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "StandardsInput", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides additional context for the value of Compliance.Status.
type StatusReason struct {
	_ struct{} `type:"structure"`

	// The corresponding description for the status reason code.
	Description *string `type:"string"`

	// A code that represents a reason for the control status. For the list of status
	// reason codes and their meanings, see Standards-related information in the
	// ASFF (https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff)
	// in the AWS Security Hub User Guide.
	//
	// ReasonCode is a required field
	ReasonCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StatusReason) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StatusReason) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StatusReason"}

	if s.ReasonCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReasonCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StatusReason) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReasonCode != nil {
		v := *s.ReasonCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReasonCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A string filter for querying findings.
type StringFilter struct {
	_ struct{} `type:"structure"`

	// The condition to be applied to a string value when querying for findings.
	Comparison StringFilterComparison `type:"string" enum:"true"`

	// The string filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StringFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the threat intelligence related to a finding.
type ThreatIntelIndicator struct {
	_ struct{} `type:"structure"`

	// The category of a threat intelligence indicator.
	Category ThreatIntelIndicatorCategory `type:"string" enum:"true"`

	// The date and time when the most recent instance of a threat intelligence
	// indicator was observed.
	LastObservedAt *string `type:"string"`

	// The source of the threat intelligence indicator.
	Source *string `type:"string"`

	// The URL to the page or site where you can get more information about the
	// threat intelligence indicator.
	SourceUrl *string `type:"string"`

	// The type of threat intelligence indicator.
	Type ThreatIntelIndicatorType `type:"string" enum:"true"`

	// The value of a threat intelligence indicator.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ThreatIntelIndicator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThreatIntelIndicator) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Category) > 0 {
		v := s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Category", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastObservedAt != nil {
		v := *s.LastObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := *s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Source", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceUrl != nil {
		v := *s.SourceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A vulnerability associated with a finding.
type Vulnerability struct {
	_ struct{} `type:"structure"`

	// CVSS scores from the advisory related to the vulnerability.
	Cvss []Cvss `type:"list"`

	// The identifier of the vulnerability.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A list of URLs that provide additional information about the vulnerability.
	ReferenceUrls []string `type:"list"`

	// List of vulnerabilities that are related to this vulnerability.
	RelatedVulnerabilities []string `type:"list"`

	// Information about the vendor that generates the vulnerability report.
	Vendor *VulnerabilityVendor `type:"structure"`

	// List of software packages that have the vulnerability.
	VulnerablePackages []SoftwarePackage `type:"list"`
}

// String returns the string representation
func (s Vulnerability) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Vulnerability) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Vulnerability"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Vendor != nil {
		if err := s.Vendor.Validate(); err != nil {
			invalidParams.AddNested("Vendor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Vulnerability) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cvss != nil {
		v := s.Cvss

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Cvss", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReferenceUrls != nil {
		v := s.ReferenceUrls

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ReferenceUrls", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.RelatedVulnerabilities != nil {
		v := s.RelatedVulnerabilities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedVulnerabilities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Vendor != nil {
		v := s.Vendor

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Vendor", v, metadata)
	}
	if s.VulnerablePackages != nil {
		v := s.VulnerablePackages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VulnerablePackages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A vendor that generates a vulnerability report.
type VulnerabilityVendor struct {
	_ struct{} `type:"structure"`

	// The name of the vendor.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The URL of the vulnerability advisory.
	Url *string `type:"string"`

	// The datetime when the vulnerability advisory was created.
	VendorCreatedAt *string `type:"string"`

	// The severity that the vendor assigned to the vulnerability.
	VendorSeverity *string `type:"string"`

	// The datetime when the vulnerability advisory was last updated.
	VendorUpdatedAt *string `type:"string"`
}

// String returns the string representation
func (s VulnerabilityVendor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VulnerabilityVendor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VulnerabilityVendor"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VulnerabilityVendor) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VendorCreatedAt != nil {
		v := *s.VendorCreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VendorCreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VendorSeverity != nil {
		v := *s.VendorSeverity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VendorSeverity", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VendorUpdatedAt != nil {
		v := *s.VendorUpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VendorUpdatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the action that CloudFront or AWS WAF takes when a web request
// matches the conditions in the rule.
type WafAction struct {
	_ struct{} `type:"structure"`

	// Specifies how you want AWS WAF to respond to requests that match the settings
	// in a rule.
	//
	// Valid settings include the following:
	//
	//    * ALLOW - AWS WAF allows requests
	//
	//    * BLOCK - AWS WAF blocks requests
	//
	//    * COUNT - AWS WAF increments a counter of the requests that match all
	//    of the conditions in the rule. AWS WAF then continues to inspect the web
	//    request based on the remaining rules in the web ACL. You can't specify
	//    COUNT for the default action for a WebACL.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WafAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about a rule to exclude from a rule group.
type WafExcludedRule struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the rule to exclude from the rule group.
	RuleId *string `type:"string"`
}

// String returns the string representation
func (s WafExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WafExcludedRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.RuleId != nil {
		v := *s.RuleId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuleId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about an override action for a rule.
type WafOverrideAction struct {
	_ struct{} `type:"structure"`

	// COUNT overrides the action specified by the individual rule within a RuleGroup .
	//
	// If set to NONE, the rule's action takes place.
	Type *string `type:"string"`
}

// String returns the string representation
func (s WafOverrideAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WafOverrideAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about the status of the investigation into a finding.
type Workflow struct {
	_ struct{} `type:"structure"`

	// The status of the investigation into the finding. The allowed values are
	// the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that you notified the resource owner about the
	//    security issue. Used when the initial reviewer is not the resource owner,
	//    and needs intervention from the resource owner.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	Status WorkflowStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Workflow) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Workflow) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Used to update information about the investigation into the finding.
type WorkflowUpdate struct {
	_ struct{} `type:"structure"`

	// The status of the investigation into the finding. The allowed values are
	// the following.
	//
	//    * NEW - The initial state of a finding, before it is reviewed.
	//
	//    * NOTIFIED - Indicates that you notified the resource owner about the
	//    security issue. Used when the initial reviewer is not the resource owner,
	//    and needs intervention from the resource owner.
	//
	//    * RESOLVED - The finding was reviewed and remediated and is now considered
	//    resolved.
	//
	//    * SUPPRESSED - The finding will not be reviewed again and will not be
	//    acted upon.
	Status WorkflowStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s WorkflowUpdate) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WorkflowUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
