// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package serverlessapplicationrepository

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Author is a required field
	Author *string `locationName:"author" type:"string" required:"true"`

	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	Labels []string `locationName:"labels" type:"list"`

	LicenseBody *string `locationName:"licenseBody" type:"string"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	ReadmeBody *string `locationName:"readmeBody" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SemanticVersion *string `locationName:"semanticVersion" type:"string"`

	SourceCodeArchiveUrl *string `locationName:"sourceCodeArchiveUrl" type:"string"`

	SourceCodeUrl *string `locationName:"sourceCodeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	TemplateBody *string `locationName:"templateBody" type:"string"`

	TemplateUrl *string `locationName:"templateUrl" type:"string"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateApplicationInput"}

	if s.Author == nil {
		invalidParams.Add(aws.NewErrParamRequired("Author"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApplicationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Author != nil {
		v := *s.Author

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "author", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HomePageUrl != nil {
		v := *s.HomePageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "homePageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "labels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LicenseBody != nil {
		v := *s.LicenseBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "licenseBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LicenseUrl != nil {
		v := *s.LicenseUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "licenseUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReadmeBody != nil {
		v := *s.ReadmeBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readmeBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReadmeUrl != nil {
		v := *s.ReadmeUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readmeUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SemanticVersion != nil {
		v := *s.SemanticVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "semanticVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeArchiveUrl != nil {
		v := *s.SourceCodeArchiveUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceCodeArchiveUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceCodeUrl != nil {
		v := *s.SourceCodeUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceCodeUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SpdxLicenseId != nil {
		v := *s.SpdxLicenseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spdxLicenseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateBody != nil {
		v := *s.TemplateBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateUrl != nil {
		v := *s.TemplateUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	ApplicationId *string `locationName:"applicationId" type:"string"`

	Author *string `locationName:"author" type:"string"`

	CreationTime *string `locationName:"creationTime" type:"string"`

	Description *string `locationName:"description" type:"string"`

	HomePageUrl *string `locationName:"homePageUrl" type:"string"`

	IsVerifiedAuthor *bool `locationName:"isVerifiedAuthor" type:"boolean"`

	Labels []string `locationName:"labels" type:"list"`

	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	Name *string `locationName:"name" type:"string"`

	ReadmeUrl *string `locationName:"readmeUrl" type:"string"`

	SpdxLicenseId *string `locationName:"spdxLicenseId" type:"string"`

	VerifiedAuthorUrl *string `locationName:"verifiedAuthorUrl" type:"string"`

	// Application version details.
	Version *Version `locationName:"version" type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateApplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Author != nil {
		v := *s.Author

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "author", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HomePageUrl != nil {
		v := *s.HomePageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "homePageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IsVerifiedAuthor != nil {
		v := *s.IsVerifiedAuthor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isVerifiedAuthor", protocol.BoolValue(v), metadata)
	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "labels", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.LicenseUrl != nil {
		v := *s.LicenseUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "licenseUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReadmeUrl != nil {
		v := *s.ReadmeUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "readmeUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SpdxLicenseId != nil {
		v := *s.SpdxLicenseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "spdxLicenseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VerifiedAuthorUrl != nil {
		v := *s.VerifiedAuthorUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "verifiedAuthorUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := s.Version

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "version", v, metadata)
	}
	return nil
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest returns a request value for making API operation for
// AWSServerlessApplicationRepository.
//
// Creates an application, optionally including an AWS SAM file to create the
// first application version in the same call.
//
//    // Example sending a request using CreateApplicationRequest.
//    req := client.CreateApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication
func (c *Client) CreateApplicationRequest(input *CreateApplicationInput) CreateApplicationRequest {
	op := &aws.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req := c.newRequest(op, input, &CreateApplicationOutput{})

	return CreateApplicationRequest{Request: req, Input: input, Copy: c.CreateApplicationRequest}
}

// CreateApplicationRequest is the request type for the
// CreateApplication API operation.
type CreateApplicationRequest struct {
	*aws.Request
	Input *CreateApplicationInput
	Copy  func(*CreateApplicationInput) CreateApplicationRequest
}

// Send marshals and sends the CreateApplication API request.
func (r CreateApplicationRequest) Send(ctx context.Context) (*CreateApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateApplicationResponse{
		CreateApplicationOutput: r.Request.Data.(*CreateApplicationOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateApplicationResponse is the response type for the
// CreateApplication API operation.
type CreateApplicationResponse struct {
	*CreateApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateApplication request.
func (r *CreateApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
