// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateTagOptionWithResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The TagOption identifier.
	//
	// TagOptionId is a required field
	TagOptionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTagOptionWithResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTagOptionWithResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateTagOptionWithResourceInput"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}

	if s.TagOptionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagOptionId"))
	}
	if s.TagOptionId != nil && len(*s.TagOptionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagOptionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateTagOptionWithResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateTagOptionWithResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateTagOptionWithResource = "AssociateTagOptionWithResource"

// AssociateTagOptionWithResourceRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Associate the specified TagOption with the specified portfolio or product.
//
//    // Example sending a request using AssociateTagOptionWithResourceRequest.
//    req := client.AssociateTagOptionWithResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateTagOptionWithResource
func (c *Client) AssociateTagOptionWithResourceRequest(input *AssociateTagOptionWithResourceInput) AssociateTagOptionWithResourceRequest {
	op := &aws.Operation{
		Name:       opAssociateTagOptionWithResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTagOptionWithResourceInput{}
	}

	req := c.newRequest(op, input, &AssociateTagOptionWithResourceOutput{})

	return AssociateTagOptionWithResourceRequest{Request: req, Input: input, Copy: c.AssociateTagOptionWithResourceRequest}
}

// AssociateTagOptionWithResourceRequest is the request type for the
// AssociateTagOptionWithResource API operation.
type AssociateTagOptionWithResourceRequest struct {
	*aws.Request
	Input *AssociateTagOptionWithResourceInput
	Copy  func(*AssociateTagOptionWithResourceInput) AssociateTagOptionWithResourceRequest
}

// Send marshals and sends the AssociateTagOptionWithResource API request.
func (r AssociateTagOptionWithResourceRequest) Send(ctx context.Context) (*AssociateTagOptionWithResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateTagOptionWithResourceResponse{
		AssociateTagOptionWithResourceOutput: r.Request.Data.(*AssociateTagOptionWithResourceOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateTagOptionWithResourceResponse is the response type for the
// AssociateTagOptionWithResource API operation.
type AssociateTagOptionWithResourceResponse struct {
	*AssociateTagOptionWithResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateTagOptionWithResource request.
func (r *AssociateTagOptionWithResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
