// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeletePortfolioShareInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The AWS account ID.
	AccountId *string `type:"string"`

	// The organization node to whom you are going to stop sharing.
	OrganizationNode *OrganizationNode `type:"structure"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortfolioShareInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortfolioShareInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePortfolioShareInput"}

	if s.PortfolioId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePortfolioShareOutput struct {
	_ struct{} `type:"structure"`

	// The portfolio share unique identifier. This will only be returned if delete
	// is made to an organization node.
	PortfolioShareToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeletePortfolioShareOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePortfolioShare = "DeletePortfolioShare"

// DeletePortfolioShareRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Stops sharing the specified portfolio with the specified account or organization
// node. Shares to an organization node can only be deleted by the master account
// of an organization or by a delegated administrator.
//
// Note that if a delegated admin is de-registered, portfolio shares created
// from that account are removed.
//
//    // Example sending a request using DeletePortfolioShareRequest.
//    req := client.DeletePortfolioShareRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolioShare
func (c *Client) DeletePortfolioShareRequest(input *DeletePortfolioShareInput) DeletePortfolioShareRequest {
	op := &aws.Operation{
		Name:       opDeletePortfolioShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePortfolioShareInput{}
	}

	req := c.newRequest(op, input, &DeletePortfolioShareOutput{})

	return DeletePortfolioShareRequest{Request: req, Input: input, Copy: c.DeletePortfolioShareRequest}
}

// DeletePortfolioShareRequest is the request type for the
// DeletePortfolioShare API operation.
type DeletePortfolioShareRequest struct {
	*aws.Request
	Input *DeletePortfolioShareInput
	Copy  func(*DeletePortfolioShareInput) DeletePortfolioShareRequest
}

// Send marshals and sends the DeletePortfolioShare API request.
func (r DeletePortfolioShareRequest) Send(ctx context.Context) (*DeletePortfolioShareResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePortfolioShareResponse{
		DeletePortfolioShareOutput: r.Request.Data.(*DeletePortfolioShareOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePortfolioShareResponse is the response type for the
// DeletePortfolioShare API operation.
type DeletePortfolioShareResponse struct {
	*DeletePortfolioShareOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePortfolioShare request.
func (r *DeletePortfolioShareResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
