// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteProvisionedProductPlanInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// If set to true, AWS Service Catalog stops managing the specified provisioned
	// product even if it cannot delete the underlying resources.
	IgnoreErrors *bool `type:"boolean"`

	// The plan identifier.
	//
	// PlanId is a required field
	PlanId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisionedProductPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisionedProductPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProvisionedProductPlanInput"}

	if s.PlanId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PlanId"))
	}
	if s.PlanId != nil && len(*s.PlanId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteProvisionedProductPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisionedProductPlanOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteProvisionedProductPlan = "DeleteProvisionedProductPlan"

// DeleteProvisionedProductPlanRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Deletes the specified plan.
//
//    // Example sending a request using DeleteProvisionedProductPlanRequest.
//    req := client.DeleteProvisionedProductPlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeleteProvisionedProductPlan
func (c *Client) DeleteProvisionedProductPlanRequest(input *DeleteProvisionedProductPlanInput) DeleteProvisionedProductPlanRequest {
	op := &aws.Operation{
		Name:       opDeleteProvisionedProductPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProvisionedProductPlanInput{}
	}

	req := c.newRequest(op, input, &DeleteProvisionedProductPlanOutput{})

	return DeleteProvisionedProductPlanRequest{Request: req, Input: input, Copy: c.DeleteProvisionedProductPlanRequest}
}

// DeleteProvisionedProductPlanRequest is the request type for the
// DeleteProvisionedProductPlan API operation.
type DeleteProvisionedProductPlanRequest struct {
	*aws.Request
	Input *DeleteProvisionedProductPlanInput
	Copy  func(*DeleteProvisionedProductPlanInput) DeleteProvisionedProductPlanRequest
}

// Send marshals and sends the DeleteProvisionedProductPlan API request.
func (r DeleteProvisionedProductPlanRequest) Send(ctx context.Context) (*DeleteProvisionedProductPlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProvisionedProductPlanResponse{
		DeleteProvisionedProductPlanOutput: r.Request.Data.(*DeleteProvisionedProductPlanOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProvisionedProductPlanResponse is the response type for the
// DeleteProvisionedProductPlan API operation.
type DeleteProvisionedProductPlanResponse struct {
	*DeleteProvisionedProductPlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProvisionedProductPlan request.
func (r *DeleteProvisionedProductPlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
