// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateServiceActionFromProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The product identifier. For example, prod-abcdzk7xy33qa.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`

	// The self-service action identifier. For example, act-fs7abcd89wxyz.
	//
	// ServiceActionId is a required field
	ServiceActionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateServiceActionFromProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateServiceActionFromProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateServiceActionFromProvisioningArtifactInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if s.ServiceActionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceActionId"))
	}
	if s.ServiceActionId != nil && len(*s.ServiceActionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateServiceActionFromProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateServiceActionFromProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateServiceActionFromProvisioningArtifact = "DisassociateServiceActionFromProvisioningArtifact"

// DisassociateServiceActionFromProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Disassociates the specified self-service action association from the specified
// provisioning artifact.
//
//    // Example sending a request using DisassociateServiceActionFromProvisioningArtifactRequest.
//    req := client.DisassociateServiceActionFromProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DisassociateServiceActionFromProvisioningArtifact
func (c *Client) DisassociateServiceActionFromProvisioningArtifactRequest(input *DisassociateServiceActionFromProvisioningArtifactInput) DisassociateServiceActionFromProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opDisassociateServiceActionFromProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateServiceActionFromProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &DisassociateServiceActionFromProvisioningArtifactOutput{})

	return DisassociateServiceActionFromProvisioningArtifactRequest{Request: req, Input: input, Copy: c.DisassociateServiceActionFromProvisioningArtifactRequest}
}

// DisassociateServiceActionFromProvisioningArtifactRequest is the request type for the
// DisassociateServiceActionFromProvisioningArtifact API operation.
type DisassociateServiceActionFromProvisioningArtifactRequest struct {
	*aws.Request
	Input *DisassociateServiceActionFromProvisioningArtifactInput
	Copy  func(*DisassociateServiceActionFromProvisioningArtifactInput) DisassociateServiceActionFromProvisioningArtifactRequest
}

// Send marshals and sends the DisassociateServiceActionFromProvisioningArtifact API request.
func (r DisassociateServiceActionFromProvisioningArtifactRequest) Send(ctx context.Context) (*DisassociateServiceActionFromProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateServiceActionFromProvisioningArtifactResponse{
		DisassociateServiceActionFromProvisioningArtifactOutput: r.Request.Data.(*DisassociateServiceActionFromProvisioningArtifactOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateServiceActionFromProvisioningArtifactResponse is the response type for the
// DisassociateServiceActionFromProvisioningArtifact API operation.
type DisassociateServiceActionFromProvisioningArtifactResponse struct {
	*DisassociateServiceActionFromProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateServiceActionFromProvisioningArtifact request.
func (r *DisassociateServiceActionFromProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
