// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListProvisioningArtifactsForServiceActionInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The self-service action identifier. For example, act-fs7abcd89wxyz.
	//
	// ServiceActionId is a required field
	ServiceActionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListProvisioningArtifactsForServiceActionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisioningArtifactsForServiceActionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListProvisioningArtifactsForServiceActionInput"}

	if s.ServiceActionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceActionId"))
	}
	if s.ServiceActionId != nil && len(*s.ServiceActionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServiceActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListProvisioningArtifactsForServiceActionOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// An array of objects with information about product views and provisioning
	// artifacts.
	ProvisioningArtifactViews []ProvisioningArtifactView `type:"list"`
}

// String returns the string representation
func (s ListProvisioningArtifactsForServiceActionOutput) String() string {
	return awsutil.Prettify(s)
}

const opListProvisioningArtifactsForServiceAction = "ListProvisioningArtifactsForServiceAction"

// ListProvisioningArtifactsForServiceActionRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists all provisioning artifacts (also known as versions) for the specified
// self-service action.
//
//    // Example sending a request using ListProvisioningArtifactsForServiceActionRequest.
//    req := client.ListProvisioningArtifactsForServiceActionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListProvisioningArtifactsForServiceAction
func (c *Client) ListProvisioningArtifactsForServiceActionRequest(input *ListProvisioningArtifactsForServiceActionInput) ListProvisioningArtifactsForServiceActionRequest {
	op := &aws.Operation{
		Name:       opListProvisioningArtifactsForServiceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProvisioningArtifactsForServiceActionInput{}
	}

	req := c.newRequest(op, input, &ListProvisioningArtifactsForServiceActionOutput{})

	return ListProvisioningArtifactsForServiceActionRequest{Request: req, Input: input, Copy: c.ListProvisioningArtifactsForServiceActionRequest}
}

// ListProvisioningArtifactsForServiceActionRequest is the request type for the
// ListProvisioningArtifactsForServiceAction API operation.
type ListProvisioningArtifactsForServiceActionRequest struct {
	*aws.Request
	Input *ListProvisioningArtifactsForServiceActionInput
	Copy  func(*ListProvisioningArtifactsForServiceActionInput) ListProvisioningArtifactsForServiceActionRequest
}

// Send marshals and sends the ListProvisioningArtifactsForServiceAction API request.
func (r ListProvisioningArtifactsForServiceActionRequest) Send(ctx context.Context) (*ListProvisioningArtifactsForServiceActionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListProvisioningArtifactsForServiceActionResponse{
		ListProvisioningArtifactsForServiceActionOutput: r.Request.Data.(*ListProvisioningArtifactsForServiceActionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListProvisioningArtifactsForServiceActionRequestPaginator returns a paginator for ListProvisioningArtifactsForServiceAction.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListProvisioningArtifactsForServiceActionRequest(input)
//   p := servicecatalog.NewListProvisioningArtifactsForServiceActionRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListProvisioningArtifactsForServiceActionPaginator(req ListProvisioningArtifactsForServiceActionRequest) ListProvisioningArtifactsForServiceActionPaginator {
	return ListProvisioningArtifactsForServiceActionPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListProvisioningArtifactsForServiceActionInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListProvisioningArtifactsForServiceActionPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListProvisioningArtifactsForServiceActionPaginator struct {
	aws.Pager
}

func (p *ListProvisioningArtifactsForServiceActionPaginator) CurrentPage() *ListProvisioningArtifactsForServiceActionOutput {
	return p.Pager.CurrentPage().(*ListProvisioningArtifactsForServiceActionOutput)
}

// ListProvisioningArtifactsForServiceActionResponse is the response type for the
// ListProvisioningArtifactsForServiceAction API operation.
type ListProvisioningArtifactsForServiceActionResponse struct {
	*ListProvisioningArtifactsForServiceActionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListProvisioningArtifactsForServiceAction request.
func (r *ListProvisioningArtifactsForServiceActionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
