// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListStackInstancesForProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The identifier of the provisioned product.
	//
	// ProvisionedProductId is a required field
	ProvisionedProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListStackInstancesForProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStackInstancesForProvisionedProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListStackInstancesForProvisionedProductInput"}

	if s.ProvisionedProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisionedProductId"))
	}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisionedProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListStackInstancesForProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// List of stack instances.
	StackInstances []StackInstance `type:"list"`
}

// String returns the string representation
func (s ListStackInstancesForProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

const opListStackInstancesForProvisionedProduct = "ListStackInstancesForProvisionedProduct"

// ListStackInstancesForProvisionedProductRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Returns summary information about stack instances that are associated with
// the specified CFN_STACKSET type provisioned product. You can filter for stack
// instances that are associated with a specific AWS account name or region.
//
//    // Example sending a request using ListStackInstancesForProvisionedProductRequest.
//    req := client.ListStackInstancesForProvisionedProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListStackInstancesForProvisionedProduct
func (c *Client) ListStackInstancesForProvisionedProductRequest(input *ListStackInstancesForProvisionedProductInput) ListStackInstancesForProvisionedProductRequest {
	op := &aws.Operation{
		Name:       opListStackInstancesForProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListStackInstancesForProvisionedProductInput{}
	}

	req := c.newRequest(op, input, &ListStackInstancesForProvisionedProductOutput{})

	return ListStackInstancesForProvisionedProductRequest{Request: req, Input: input, Copy: c.ListStackInstancesForProvisionedProductRequest}
}

// ListStackInstancesForProvisionedProductRequest is the request type for the
// ListStackInstancesForProvisionedProduct API operation.
type ListStackInstancesForProvisionedProductRequest struct {
	*aws.Request
	Input *ListStackInstancesForProvisionedProductInput
	Copy  func(*ListStackInstancesForProvisionedProductInput) ListStackInstancesForProvisionedProductRequest
}

// Send marshals and sends the ListStackInstancesForProvisionedProduct API request.
func (r ListStackInstancesForProvisionedProductRequest) Send(ctx context.Context) (*ListStackInstancesForProvisionedProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListStackInstancesForProvisionedProductResponse{
		ListStackInstancesForProvisionedProductOutput: r.Request.Data.(*ListStackInstancesForProvisionedProductOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListStackInstancesForProvisionedProductResponse is the response type for the
// ListStackInstancesForProvisionedProduct API operation.
type ListStackInstancesForProvisionedProductResponse struct {
	*ListStackInstancesForProvisionedProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListStackInstancesForProvisionedProduct request.
func (r *ListStackInstancesForProvisionedProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
