// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchProductsAsAdminInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The search filters. If no search filters are specified, the output includes
	// all products to which the administrator has access.
	Filters map[string][]string `type:"map"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The portfolio identifier.
	PortfolioId *string `min:"1" type:"string"`

	// Access level of the source of the product.
	ProductSource ProductSource `type:"string" enum:"true"`

	// The sort field. If no value is specified, the results are not sorted.
	SortBy ProductViewSortBy `type:"string" enum:"true"`

	// The sort order. If no value is specified, the results are not sorted.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SearchProductsAsAdminInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProductsAsAdminInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchProductsAsAdminInput"}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchProductsAsAdminOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// Information about the product views.
	ProductViewDetails []ProductViewDetail `type:"list"`
}

// String returns the string representation
func (s SearchProductsAsAdminOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchProductsAsAdmin = "SearchProductsAsAdmin"

// SearchProductsAsAdminRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Gets information about the products for the specified portfolio or all products.
//
//    // Example sending a request using SearchProductsAsAdminRequest.
//    req := client.SearchProductsAsAdminRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProductsAsAdmin
func (c *Client) SearchProductsAsAdminRequest(input *SearchProductsAsAdminInput) SearchProductsAsAdminRequest {
	op := &aws.Operation{
		Name:       opSearchProductsAsAdmin,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchProductsAsAdminInput{}
	}

	req := c.newRequest(op, input, &SearchProductsAsAdminOutput{})

	return SearchProductsAsAdminRequest{Request: req, Input: input, Copy: c.SearchProductsAsAdminRequest}
}

// SearchProductsAsAdminRequest is the request type for the
// SearchProductsAsAdmin API operation.
type SearchProductsAsAdminRequest struct {
	*aws.Request
	Input *SearchProductsAsAdminInput
	Copy  func(*SearchProductsAsAdminInput) SearchProductsAsAdminRequest
}

// Send marshals and sends the SearchProductsAsAdmin API request.
func (r SearchProductsAsAdminRequest) Send(ctx context.Context) (*SearchProductsAsAdminResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchProductsAsAdminResponse{
		SearchProductsAsAdminOutput: r.Request.Data.(*SearchProductsAsAdminOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchProductsAsAdminRequestPaginator returns a paginator for SearchProductsAsAdmin.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchProductsAsAdminRequest(input)
//   p := servicecatalog.NewSearchProductsAsAdminRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchProductsAsAdminPaginator(req SearchProductsAsAdminRequest) SearchProductsAsAdminPaginator {
	return SearchProductsAsAdminPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchProductsAsAdminInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchProductsAsAdminPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchProductsAsAdminPaginator struct {
	aws.Pager
}

func (p *SearchProductsAsAdminPaginator) CurrentPage() *SearchProductsAsAdminOutput {
	return p.Pager.CurrentPage().(*SearchProductsAsAdminOutput)
}

// SearchProductsAsAdminResponse is the response type for the
// SearchProductsAsAdmin API operation.
type SearchProductsAsAdminResponse struct {
	*SearchProductsAsAdminOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchProductsAsAdmin request.
func (r *SearchProductsAsAdminResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
