// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateProvisioningArtifactInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// Indicates whether the product version is active.
	//
	// Inactive provisioning artifacts are invisible to end users. End users cannot
	// launch or update a provisioned product from an inactive provisioning artifact.
	Active *bool `type:"boolean"`

	// The updated description of the provisioning artifact.
	Description *string `type:"string"`

	// Information set by the administrator to provide guidance to end users about
	// which provisioning artifacts to use.
	//
	// The DEFAULT value indicates that the product version is active.
	//
	// The administrator can set the guidance to DEPRECATED to inform users that
	// the product version is deprecated. Users are able to make updates to a provisioned
	// product of a deprecated version but cannot launch new provisioned products
	// using a deprecated version.
	Guidance ProvisioningArtifactGuidance `type:"string" enum:"true"`

	// The updated name of the provisioning artifact.
	Name *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the provisioning artifact.
	//
	// ProvisioningArtifactId is a required field
	ProvisioningArtifactId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProvisioningArtifactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisioningArtifactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProvisioningArtifactInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if s.ProvisioningArtifactId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProvisioningArtifactId"))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateProvisioningArtifactOutput struct {
	_ struct{} `type:"structure"`

	// The URL of the CloudFormation template in Amazon S3.
	Info map[string]string `min:"1" type:"map"`

	// Information about the provisioning artifact.
	ProvisioningArtifactDetail *ProvisioningArtifactDetail `type:"structure"`

	// The status of the current request.
	Status Status `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateProvisioningArtifactOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateProvisioningArtifact = "UpdateProvisioningArtifact"

// UpdateProvisioningArtifactRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Updates the specified provisioning artifact (also known as a version) for
// the specified product.
//
// You cannot update a provisioning artifact for a product that was shared with
// you.
//
//    // Example sending a request using UpdateProvisioningArtifactRequest.
//    req := client.UpdateProvisioningArtifactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisioningArtifact
func (c *Client) UpdateProvisioningArtifactRequest(input *UpdateProvisioningArtifactInput) UpdateProvisioningArtifactRequest {
	op := &aws.Operation{
		Name:       opUpdateProvisioningArtifact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProvisioningArtifactInput{}
	}

	req := c.newRequest(op, input, &UpdateProvisioningArtifactOutput{})

	return UpdateProvisioningArtifactRequest{Request: req, Input: input, Copy: c.UpdateProvisioningArtifactRequest}
}

// UpdateProvisioningArtifactRequest is the request type for the
// UpdateProvisioningArtifact API operation.
type UpdateProvisioningArtifactRequest struct {
	*aws.Request
	Input *UpdateProvisioningArtifactInput
	Copy  func(*UpdateProvisioningArtifactInput) UpdateProvisioningArtifactRequest
}

// Send marshals and sends the UpdateProvisioningArtifact API request.
func (r UpdateProvisioningArtifactRequest) Send(ctx context.Context) (*UpdateProvisioningArtifactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateProvisioningArtifactResponse{
		UpdateProvisioningArtifactOutput: r.Request.Data.(*UpdateProvisioningArtifactOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateProvisioningArtifactResponse is the response type for the
// UpdateProvisioningArtifact API operation.
type UpdateProvisioningArtifactResponse struct {
	*UpdateProvisioningArtifactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateProvisioningArtifact request.
func (r *UpdateProvisioningArtifactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
