// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to delete.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteServiceInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Deletes a specified service. If the service still contains one or more registered
// instances, the request fails.
//
//    // Example sending a request using DeleteServiceRequest.
//    req := client.DeleteServiceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService
func (c *Client) DeleteServiceRequest(input *DeleteServiceInput) DeleteServiceRequest {
	op := &aws.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	req := c.newRequest(op, input, &DeleteServiceOutput{})

	return DeleteServiceRequest{Request: req, Input: input, Copy: c.DeleteServiceRequest}
}

// DeleteServiceRequest is the request type for the
// DeleteService API operation.
type DeleteServiceRequest struct {
	*aws.Request
	Input *DeleteServiceInput
	Copy  func(*DeleteServiceInput) DeleteServiceRequest
}

// Send marshals and sends the DeleteService API request.
func (r DeleteServiceRequest) Send(ctx context.Context) (*DeleteServiceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteServiceResponse{
		DeleteServiceOutput: r.Request.Data.(*DeleteServiceOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteServiceResponse is the response type for the
// DeleteService API operation.
type DeleteServiceResponse struct {
	*DeleteServiceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteService request.
func (r *DeleteServiceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
